/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.service.BridgeException;
import com.sun.messaging.bridge.service.FaultInjection;
import com.sun.messaging.bridge.service.MessageTransformer;
import com.sun.messaging.bridge.service.jms.AutoDestination;
import com.sun.messaging.bridge.service.jms.DMQ;
import com.sun.messaging.bridge.service.jms.EventListener;
import com.sun.messaging.bridge.service.jms.EventNotifier;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.MessageHeaders;
import com.sun.messaging.bridge.service.jms.PooledConnection;
import com.sun.messaging.bridge.service.jms.Refable;
import com.sun.messaging.bridge.service.jms.SharedConnection;
import com.sun.messaging.bridge.service.jms.XAResourceImpl;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public class Link
implements Runnable {
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();
    private Logger _logger = null;
    private TransactionManager _tm = null;
    private Object _sourceCF = null;
    private Object _targetCF = null;
    private Object _sourceDest = null;
    private Object _targetDest = null;
    private MessageConsumer _consumer = null;
    private MessageProducer _producer = null;
    private Session _sourceSession = null;
    private Session _targetSession = null;
    private Connection _sourceConn = null;
    private Connection _targetConn = null;
    private String _name = null;
    private Properties _linkAttrs = null;
    private Properties _srcAttrs = null;
    private Properties _tgtAttrs = null;
    private Properties _tgtProps = null;
    private JMSBridge _parent = null;
    private Properties _msgTransformerProps = null;
    private LinkState _state = LinkState.UNINITIALIZED;
    private Thread _thread = null;
    private boolean _targetStayConnected = false;
    private boolean _sourceConnException = false;
    private boolean _targetConnException = false;
    private String _sourceProviderName = null;
    private String _targetProviderName = null;
    private String _sourceDestName = null;
    private String _targetDestName = null;
    private EventNotifier _notifier = null;
    private static final int MIN_TRANSACTION_TIMEOUT = 60;
    private boolean _enabled = true;
    private boolean _isTransacted = true;
    private MessageTransformer<Message, Message> _msgTransformer = null;
    private boolean _consumeOnTransformError = false;
    private boolean _retainReplyTo = false;
    private FaultInjection _fi = FaultInjection.getInjection();
    private String _targetConnType = null;
    private String _sourceConnType = null;
    private MessageProducer _branchProducer = null;
    private String _targetCurrentDestinationName = null;
    private boolean _unidentifiedProducer = false;
    private boolean _firstTransformerBranchTo = true;
    private boolean _firstTransformerNoTransfer = true;
    private boolean _firstTransformerAsSourceChange = true;
    private int _sourceAttemptInterval = 5;
    private int _targetAttemptInterval = 5;
    private final Object _listenerLock = new Object();
    private static final int MAX_CONSECUTIVE_THROWABLES = 5;

    public synchronized void init(Properties properties, Properties properties2, Properties properties3, Properties properties4, JMSBridge jMSBridge) throws Exception {
        this._linkAttrs = properties;
        this._srcAttrs = properties2;
        this._tgtAttrs = properties3;
        this._tgtProps = properties4;
        this._parent = jMSBridge;
        this._notifier = jMSBridge._notifier;
        this._msgTransformerProps = this._tgtProps == null ? new Properties() : new Properties(this._tgtProps);
        this._msgTransformerProps.setProperty("JMS_SUN_JMSBRIDGE_NAME", this._parent.getBridgeName());
        if (this._sourceDest == null || this._targetDest == null || this._sourceCF == null || this._targetCF == null) {
            throw new IllegalStateException(_jbr.getKString("BSJ4021", this._sourceCF == null ? _jbr.getString("BSJ0003") : _jbr.getString("BSJ0004"), this._name));
        }
        if (this._logger == null) {
            throw new IllegalStateException("No logger set for " + this);
        }
        this._enabled = Boolean.valueOf(this._linkAttrs.getProperty("enabled", "true"));
        this._isTransacted = Boolean.valueOf(this._linkAttrs.getProperty("transacted", "true"));
        if (this._isTransacted && !(this._sourceCF instanceof XAConnectionFactory)) {
            Object[] objectArray = new String[3];
            objectArray[0] = "XAConnectionFactory";
            objectArray[1] = _jbr.getString("BSJ0005");
            objectArray[2] = this.toString();
            Object[] objectArray2 = objectArray;
            throw new IllegalArgumentException(_jbr.getKString("BSJ4022", objectArray2));
        }
        if (!this._isTransacted && this._sourceCF instanceof XAConnectionFactory) {
            Object[] objectArray = new String[3];
            objectArray[0] = "ConnectionFactory";
            objectArray[1] = _jbr.getString("BSJ0006");
            objectArray[2] = this.toString();
            Object[] objectArray3 = objectArray;
            throw new IllegalArgumentException(_jbr.getKString("BSJ4022", objectArray3));
        }
        String string = this._tgtAttrs.getProperty("message-transformer-class");
        if (string != null) {
            this._msgTransformer = (MessageTransformer)Class.forName(string).newInstance();
        }
        this._consumeOnTransformError = Boolean.valueOf(this._tgtAttrs.getProperty("consume-no-transfer-on-transform-error", "false"));
        this._retainReplyTo = Boolean.valueOf(this._tgtAttrs.getProperty("retain-replyto", "false"));
        String string2 = this._parent.getCFAttributes(this._sourceCF).getProperty("connect-attempt-interval-in-seconds", "5");
        if (string2 != null) {
            this._sourceAttemptInterval = Integer.valueOf(string2);
        }
        if ((string2 = this._parent.getCFAttributes(this._targetCF).getProperty("connect-attempt-interval-in-seconds", "5")) != null) {
            this._targetAttemptInterval = Integer.valueOf(string2);
        }
        if (this._sourceCF instanceof XAConnectionFactory) {
            this._tm = this._parent.getTransactionManager();
            if (this._tm == null) {
                throw new IllegalStateException("No transaction manager for XA in " + this);
            }
            if (this._parent.supportTransactionTimeout()) {
                if (this._parent.getTransactionTimeout() < 60) {
                    throw new IllegalArgumentException("Transaction timeout " + this._parent.getTransactionTimeout() + " is too small");
                }
                this._logger.log(Level.INFO, "Link " + this + " uses TM " + this._tm.getClass().toString() + ", transaction timeout " + this._parent.getTransactionTimeout() + " seconds");
            } else {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1026", this.toString(), this._tm.getClass().toString()));
            }
        }
        Object[] objectArray = new String[]{this.toString(), this._linkAttrs == null ? "null" : this._linkAttrs.toString(), this._srcAttrs == null ? "null" : this._srcAttrs.toString(), this._tgtAttrs == null ? "null" : this._tgtAttrs.toString(), this._tgtProps == null ? "null" : this._tgtProps.toString()};
        this._logger.log(Level.INFO, _jbr.getString("BSJ1064", objectArray));
        this._state = LinkState.STOPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerXAResources() throws Exception {
        if (!(this._sourceCF instanceof XAConnectionFactory)) {
            return;
        }
        XAResourceHandle xAResourceHandle = new XAResourceHandle(false);
        XAResourceHandle xAResourceHandle2 = new XAResourceHandle(true);
        Transaction transaction = null;
        try {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1027", this.toString()));
            this.initSource(false, false, false);
            this.initTarget(false, false, false);
            xAResourceHandle.xar = ((XASession)this._sourceSession).getXAResource();
            if (((Refable)this._targetCF).isEmbeded() && ((Refable)this._sourceCF).isEmbeded()) {
                xAResourceHandle2.xar = xAResourceHandle.xar;
            } else {
                xAResourceHandle2.xar = ((XASession)this._targetSession).getXAResource();
                if (xAResourceHandle2.xar.getClass().getName().equals(xAResourceHandle.xar.getClass().getName())) {
                    xAResourceHandle2.xar = new XAResourceImpl(xAResourceHandle2.xar);
                    this._logger.log(Level.INFO, _jbr.getString("BSJ1028", xAResourceHandle2.xar.getClass().getName()));
                }
            }
            this._tm.begin();
            transaction = this._tm.getTransaction();
            if (!this.doEnlistAndRollbackOnError(transaction, this._tm, xAResourceHandle)) {
                throw xAResourceHandle.ex;
            }
            if (xAResourceHandle.xar != xAResourceHandle2.xar && !this.doEnlistAndRollbackOnError(this._tm.getTransaction(), this._tm, xAResourceHandle2)) {
                throw xAResourceHandle2.ex;
            }
            this.doFinally(transaction, this._tm, xAResourceHandle, xAResourceHandle2);
            this.closeSource();
            this.closeTarget();
        }
        catch (Throwable throwable) {
            this.doFinally(transaction, this._tm, xAResourceHandle, xAResourceHandle2);
            this.closeSource();
            this.closeTarget();
            throw throwable;
        }
        this._logger.log(Level.INFO, _jbr.getString("BSJ1029", this.toString()));
    }

    public boolean isEnabled() {
        if (this._state == LinkState.UNINITIALIZED) {
            throw new IllegalStateException("Link is not initialized");
        }
        return this._enabled;
    }

    public boolean isTransacted() {
        if (this._state == LinkState.UNINITIALIZED) {
            throw new IllegalStateException("Link is not initialized");
        }
        return this._isTransacted;
    }

    public void enable() throws Exception {
        if (this.isEnabled()) {
            this._logger.log(Level.INFO, this + " is already enabled");
            return;
        }
        this._enabled = true;
    }

    public synchronized void start(boolean bl) throws Exception {
        if (this._state == LinkState.UNINITIALIZED) {
            throw new IllegalStateException("Link not initialized !");
        }
        if (this._state == LinkState.STARTED) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1030", this.toString()));
            return;
        }
        this._state = LinkState.STARTING;
        try {
            this.initSource(true, bl, true);
            this.initTarget(true, bl, true);
            this._thread = new Thread(this);
            this._thread.setDaemon(true);
            this._thread.setName(this.toString());
            this._thread.start();
        }
        catch (Throwable throwable) {
            this._logger.log(Level.SEVERE, _jbr.getKString("BSJ3010", this.toString(), throwable.getMessage()), throwable);
            try {
                this.stop(!bl);
            }
            catch (Throwable throwable2) {
                this._logger.log(Level.WARNING, _jbr.getKString("BSJ3011", this.toString()), throwable2);
            }
            throw new Exception(throwable);
        }
    }

    public synchronized void postStart() throws Exception {
        if (this._state == LinkState.STARTED) {
            return;
        }
        if (this._state != LinkState.STARTING) {
            throw new IllegalStateException(_jbr.getKString("BSJ4023", this.toString(), this._state.toString()));
        }
        try {
            this.resume(false);
            this._state = LinkState.STARTED;
        }
        catch (Exception exception) {
            try {
                this.stop();
            }
            catch (Throwable throwable) {
                this._logger.log(Level.WARNING, _jbr.getKString("BSJ3012", this.toString()), throwable);
            }
            throw exception;
        }
    }

    public synchronized void pause() throws Exception {
        if (this._sourceConn == null) {
            throw new IllegalStateException("Source connection not created");
        }
        if (this._state == LinkState.UNINITIALIZED || this._state == LinkState.STOPPED || this._state == LinkState.STOPPING) {
            throw new IllegalStateException(_jbr.getKString("BSJ4024", this.toString(), this._state.toString()));
        }
        if (this._state == LinkState.PAUSED || this._state == LinkState.PAUSING) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1031", this.toString()));
            return;
        }
        this._state = LinkState.PAUSING;
        try {
            this._sourceConn.stop();
        }
        catch (Exception exception) {
            this._logger.log(Level.SEVERE, _jbr.getKString("BSJ3013", this.toString()), exception);
            try {
                this.stop();
            }
            catch (Exception exception2) {
                this._logger.log(Level.SEVERE, _jbr.getString("BSJ3014", this.toString()), exception);
            }
            throw exception;
        }
        this._state = LinkState.PAUSED;
    }

    public synchronized void resume(boolean bl) throws Exception {
        if (this._sourceConn == null) {
            throw new IllegalStateException("Source connection not created");
        }
        if (this._state == LinkState.UNINITIALIZED || this._state == LinkState.STOPPED || this._state == LinkState.STOPPING) {
            Object[] objectArray = new String[3];
            objectArray[0] = bl ? _jbr.getString("BSJ0007") : _jbr.getString("BSJ0008");
            objectArray[1] = this.toString();
            objectArray[2] = this._state.toString();
            Object[] objectArray2 = objectArray;
            throw new IllegalStateException(_jbr.getKString("BSJ4025", objectArray2));
        }
        if (bl) {
            if (this._state == LinkState.STARTING || this._state == LinkState.STARTED) {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1032", this.toString()));
                return;
            }
        } else if (this._state == LinkState.PAUSING || this._state == LinkState.PAUSED) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1033", this.toString(), this._state.toString()));
            return;
        }
        try {
            this._sourceConn.start();
        }
        catch (Exception exception) {
            this._logger.log(Level.SEVERE, _jbr.getKString("BSJ3015", bl ? _jbr.getString("BSJ0009") : _jbr.getString("BSJ0010"), this.toString()), exception);
            try {
                this.stop();
            }
            catch (Exception exception2) {
                this._logger.log(Level.SEVERE, _jbr.getKString("BSJ3016", this.toString(), bl ? _jbr.getString("BSJ0009") : _jbr.getString("BSJ0010")), exception);
            }
            throw exception;
        }
        this._state = LinkState.STARTED;
    }

    public void stop() throws Exception {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean bl) throws Exception {
        this._notifier.notifyEvent(EventListener.EventType.LINK_STOP, this);
        Thread thread = null;
        Throwable throwable = null;
        Link link = this;
        synchronized (link) {
            block18: {
                this._state = LinkState.STOPPING;
                thread = this._thread;
                this._logger.log(Level.INFO, _jbr.getString("BSJ1034", this.toString()));
                if (this._thread != null && Thread.currentThread() != this._thread) {
                    this._thread.interrupt();
                }
                try {
                    if (this._sourceConn != null) {
                        this._sourceConn.close();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                try {
                    this.closeTarget();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block18;
                    throwable = throwable3;
                }
            }
            if (throwable == null) {
                this._state = LinkState.STOPPED;
                this.notifyAll();
                this._thread = null;
            }
        }
        if (thread != null && Thread.currentThread() != thread) {
            thread.interrupt();
            if (!bl) {
                thread.join(30000L);
            } else {
                while (true) {
                    try {
                        while (true) {
                            thread.join(60000L);
                            this._logger.log(Level.INFO, "BSJ1077", this.toString());
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
        if (throwable != null) {
            throw new Exception(throwable);
        }
    }

    private void initSource() throws Exception {
        this.initSource(false, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initSource(boolean bl, boolean bl2, boolean bl3) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (bl3 && (this._state == LinkState.STOPPING || this._state == LinkState.STOPPED)) {
            throw new JMSException(_jbr.getKString("BSJ4026", this.toString()));
        }
        this._sourceConnException = false;
        String string = this._srcAttrs.getProperty("clientid");
        this._sourceConnType = "D";
        this._logger.log(Level.INFO, _jbr.getString("BSJ1035", this.toString(), string == null ? "" : _jbr.getString("BSJ0000", string)));
        EventListener eventListener = new EventListener(this);
        try {
            this._notifier.addEventListener(EventListener.EventType.LINK_STOP, eventListener);
            this._notifier.addEventListener(EventListener.EventType.BRIDGE_STOP, eventListener);
            this._sourceConn = JMSBridge.openConnection(this._sourceCF, this._parent.getCFAttributes(this._sourceCF), _jbr.getString("BSJ0001"), this, eventListener, this._logger, bl2);
        }
        finally {
            this._notifier.removeEventListener(eventListener);
        }
        if (string != null) {
            try {
                this._sourceConn.setClientID(string);
            }
            catch (JMSException jMSException) {
                this._logger.log(Level.WARNING, "Set client id " + string + " to source connection failed in " + this + ", try again ...", jMSException);
                if (Thread.currentThread().isInterrupted()) {
                    throw jMSException;
                }
                Thread.sleep(this._sourceAttemptInterval);
                this._sourceConn.setClientID(string);
            }
        }
        this._sourceConn.stop();
        this._sourceConn.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException jMSException) {
                Logger logger = Link.this._logger;
                JMSBridgeResources jMSBridgeResources = _jbr;
                _jbr;
                JMSBridgeResources jMSBridgeResources2 = _jbr;
                _jbr;
                logger.log(Level.WARNING, jMSBridgeResources.getKString("BSJ2015", jMSBridgeResources2.getString("BSJ0003"), this.toString()), jMSException);
                if (Link.this._targetConn instanceof PooledConnection) {
                    ((PooledConnection)((Object)Link.this._targetConn)).invalid();
                } else if (Link.this._targetConn instanceof SharedConnection) {
                    ((SharedConnection)((Object)Link.this._targetConn)).invalid();
                }
                Link.this._sourceConnException = true;
            }
        });
        try {
            object3 = this._sourceConn.getMetaData();
            this._sourceProviderName = object3.getJMSProviderName();
        }
        catch (Exception exception) {
            this._sourceProviderName = null;
            this._logger.log(Level.WARNING, "Unable to get source JMSProvider from conn " + this._sourceConn + " in " + this + ": " + exception.getMessage());
        }
        if (this._sourceConn instanceof XAConnection) {
            this._sourceSession = ((XAConnection)this._sourceConn).createXASession();
            object3 = ((XASession)this._sourceSession).getXAResource();
            object2 = ((Refable)this._sourceCF).getRef();
            try {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1025", object2, object3.toString()));
                this._parent.getTransactionManagerAdapter().registerRM((String)object2, (XAResource)object3);
            }
            catch (Exception exception) {
                Object[] objectArray = new String[]{object3.toString(), object2, this.toString()};
                this._logger.log(Level.WARNING, _jbr.getKString("BSJ2016", objectArray), exception);
                throw exception;
            }
        } else {
            this._sourceSession = this._sourceConn.createSession(false, 2);
        }
        object3 = this._srcAttrs.getProperty("selector");
        object2 = this._sourceDest;
        if (this._sourceDest instanceof AutoDestination) {
            object = (AutoDestination)this._sourceDest;
            object2 = ((AutoDestination)object).isQueue() ? this._sourceSession.createQueue(((AutoDestination)object).getName()) : this._sourceSession.createTopic(((AutoDestination)object).getName());
        }
        if (object2 instanceof Topic) {
            object = this._srcAttrs.getProperty("durable-sub");
            this._consumer = object != null ? this._sourceSession.createDurableSubscriber((Topic)object2, (String)object, (String)object3, true) : this._sourceSession.createConsumer((Topic)object2, (String)object3, true);
        } else if (object2 instanceof Queue) {
            this._consumer = this._sourceSession.createConsumer((Queue)object2, (String)object3);
        } else {
            throw new IllegalArgumentException("Unknown source destination type: " + object2.getClass().getName() + " in " + this);
        }
    }

    private void initTarget() throws Exception {
        this.initTarget(false, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initTarget(boolean bl, boolean bl2, boolean bl3) throws Exception {
        Object object;
        if (bl3 && (this._state == LinkState.STOPPING || this._state == LinkState.STOPPED)) {
            throw new JMSException("Link " + this + " is stopped");
        }
        this._targetConnException = false;
        String string = this._tgtAttrs.getProperty("stay-connected", "true");
        this._targetStayConnected = Boolean.valueOf(string);
        string = this._tgtAttrs.getProperty("clientid");
        if (string != null || this._targetStayConnected) {
            this._targetConnType = "D";
            this._logger.log(Level.INFO, _jbr.getString("BSJ1036", this.toString(), string == null ? "" : _jbr.getString("BSJ0000", string)));
            object = new EventListener(this);
            try {
                this._notifier.addEventListener(EventListener.EventType.LINK_STOP, (EventListener)object);
                this._notifier.addEventListener(EventListener.EventType.BRIDGE_STOP, (EventListener)object);
                this._targetConn = JMSBridge.openConnection(this._targetCF, this._parent.getCFAttributes(this._targetCF), _jbr.getString("BSJ0002"), this, (EventListener)object, this._logger, bl2);
            }
            finally {
                this._notifier.removeEventListener((EventListener)object);
            }
            if (string != null) {
                try {
                    this._targetConn.setClientID(string);
                }
                catch (JMSException jMSException) {
                    this._logger.log(Level.WARNING, "Set client id " + string + " to target connection failed in " + this + ", try again ...", jMSException);
                    if (Thread.currentThread().isInterrupted()) {
                        throw jMSException;
                    }
                    Thread.sleep(this._targetAttemptInterval);
                    this._targetConn.setClientID(string);
                }
            }
        } else if (!bl) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1037", this.toString()));
            this._targetConn = this._parent.obtainConnection(this._targetCF, _jbr.getString("BSJ0002"), this, bl);
        } else {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1038", this.toString()));
            return;
        }
        if (this._targetConn instanceof PooledConnection) {
            this._targetConnType = "P";
        } else if (this._targetConn instanceof SharedConnection) {
            this._targetConnType = "S";
        }
        this._targetConn.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException jMSException) {
                Logger logger = Link.this._logger;
                JMSBridgeResources jMSBridgeResources = _jbr;
                _jbr;
                JMSBridgeResources jMSBridgeResources2 = _jbr;
                _jbr;
                logger.log(Level.WARNING, jMSBridgeResources.getKString("BSJ2015", jMSBridgeResources2.getString("BSJ0004"), this.toString()), jMSException);
                if (Link.this._targetConn instanceof PooledConnection) {
                    ((PooledConnection)((Object)Link.this._targetConn)).invalid();
                } else if (Link.this._targetConn instanceof SharedConnection) {
                    ((SharedConnection)((Object)Link.this._targetConn)).invalid();
                }
                Link.this._targetConnException = true;
            }
        });
        try {
            object = this._targetConn.getMetaData();
            this._targetProviderName = object.getJMSProviderName();
        }
        catch (Exception exception) {
            this._targetProviderName = null;
            this._logger.log(Level.WARNING, "Unable to get target JMSProvider from conn " + this._targetConn + " in " + this + ": " + exception.getMessage());
        }
        if (this._targetConn instanceof XAConnection) {
            this._targetSession = ((XAConnection)this._targetConn).createXASession();
            object = ((XASession)this._targetSession).getXAResource();
            String string2 = ((Refable)this._targetCF).getRef();
            try {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1025", string2, object.toString()));
                this._parent.getTransactionManagerAdapter().registerRM(string2, (XAResource)object);
            }
            catch (Exception exception) {
                Object[] objectArray = new String[]{object.toString(), string2, this.toString()};
                this._logger.log(Level.WARNING, _jbr.getKString("BSJ2017", objectArray), exception);
                throw exception;
            }
        } else {
            this._targetSession = this._targetConn.createSession(false, 2);
        }
        if (this._targetDest instanceof Destination) {
            this._producer = this._targetSession.createProducer((Destination)this._targetDest);
        } else if (this._targetDest instanceof AutoDestination) {
            object = (AutoDestination)this._targetDest;
            this._producer = ((AutoDestination)object).isQueue() ? this._targetSession.createProducer(this._targetSession.createQueue(((AutoDestination)object).getName())) : this._targetSession.createProducer(this._targetSession.createTopic(((AutoDestination)object).getName()));
        } else if (this._targetDest.equals("AS_SOURCE")) {
            this._unidentifiedProducer = true;
            this._producer = null;
        } else {
            throw new IllegalArgumentException("Unknown target destination type: " + this._targetDest.getClass().getName() + " in " + this);
        }
        if (this._producer != null && this._producer instanceof MessageProducerImpl) {
            ((MessageProducerImpl)this._producer)._setForJMSBridge();
        }
    }

    private MessageProducer createProducer(Object object, String string, boolean bl) throws Exception {
        MessageProducer messageProducer = null;
        Object object2 = object;
        if (object instanceof String) {
            object2 = this._parent.createDestination((String)object);
        }
        if (object2 instanceof Destination) {
            Destination destination = null;
            if (bl) {
                destination = (Destination)object2;
            } else if (object2 instanceof Queue) {
                destination = this._targetSession.createQueue(((Queue)object2).getQueueName());
            } else if (object2 instanceof Topic) {
                destination = this._targetSession.createTopic(((Topic)object2).getTopicName());
            } else {
                throw new JMSException("Unsupported JMS Destination type: " + object);
            }
            messageProducer = this._targetSession.createProducer(destination);
        } else if (object2 instanceof AutoDestination) {
            AutoDestination autoDestination = (AutoDestination)object2;
            messageProducer = autoDestination.isQueue() ? this._targetSession.createProducer(this._targetSession.createQueue(autoDestination.getName())) : this._targetSession.createProducer(this._targetSession.createTopic(autoDestination.getName()));
        } else {
            throw new IllegalArgumentException("Unsupported destination type: " + object2.getClass().getName() + " to create target producer for message " + string + " in " + this);
        }
        if (messageProducer != null && messageProducer instanceof MessageProducerImpl) {
            ((MessageProducerImpl)messageProducer)._setForJMSBridge();
        }
        return messageProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeTarget() {
        this._targetConnException = false;
        if (this._targetConn != null) {
            if (this._targetConn instanceof SharedConnection || this._targetConn instanceof PooledConnection) {
                try {
                    this._targetSession.close();
                }
                catch (Throwable throwable) {
                    this._logger.log(Level.WARNING, "Unable to close target Session in " + this, throwable);
                }
                finally {
                    try {
                        this._parent.returnConnection(this._targetConn, this._targetCF);
                    }
                    catch (Throwable throwable) {
                        this._logger.log(Level.WARNING, "Unable to return target connection " + this._targetConn + " in " + this, throwable);
                    }
                }
            } else {
                try {
                    this._logger.log(Level.INFO, _jbr.getString("BSJ1074", this._targetConn.getClass().getName() + '@' + Integer.toHexString(this._targetConn.hashCode()), this.toString()));
                    this._targetConn.close();
                }
                catch (Throwable throwable) {
                    this._logger.log(Level.WARNING, "Unable to close target connection " + this._targetConn + " in " + this, throwable);
                }
            }
            this._targetConn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeSource() {
        this._sourceConnException = false;
        if (this._sourceConn != null) {
            if (this._sourceConn instanceof SharedConnection || this._sourceConn instanceof PooledConnection) {
                try {
                    this._sourceSession.close();
                }
                catch (Throwable throwable) {
                    this._logger.log(Level.WARNING, "Unable to close source Session in " + this, throwable);
                }
                finally {
                    try {
                        this._parent.returnConnection(this._sourceConn, this._sourceCF);
                    }
                    catch (Throwable throwable) {
                        this.logWarning("Unable to return source connection " + this._sourceConn + " in " + this, throwable);
                    }
                }
            } else {
                try {
                    this._logger.log(Level.INFO, _jbr.getString("BSJ1073", this._sourceConn.getClass().getName() + '@' + Integer.toHexString(this._sourceConn.hashCode()), this.toString()));
                    this._sourceConn.close();
                }
                catch (Throwable throwable) {
                    this.logWarning("Unable to close source connection " + this._sourceConn + " in " + this, throwable);
                }
            }
            this._sourceConn = null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("link(" + this.getName() + ")[");
        stringBuffer.append(this.getSourceString());
        stringBuffer.append("-->");
        stringBuffer.append(this.getTargetString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getSourceString() {
        if (this._state == LinkState.UNINITIALIZED) {
            return "";
        }
        return ((Refable)this._sourceCF).getRef() + ":" + (this._sourceConnType == null ? "" : this._sourceConnType) + ":" + this.getSourceDestinationName();
    }

    public String getTargetString() {
        if (this._state == LinkState.UNINITIALIZED) {
            return "";
        }
        return ((Refable)this._targetCF).getRef() + ":" + (this._targetConnType == null ? "" : this._targetConnType) + ":" + this.getTargetDestinationName();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getSourceProviderName() {
        String string = this._sourceProviderName;
        if (string != null) {
            return string;
        }
        return ((Refable)this._sourceCF).getRefed().getClass().getName();
    }

    public String getTargetProviderName() {
        String string = this._targetProviderName;
        if (string != null) {
            return string;
        }
        return ((Refable)this._targetCF).getRefed().getClass().getName();
    }

    public String getSourceDestinationName() {
        if (this._sourceDestName != null) {
            return this._sourceDestName;
        }
        Object object = this._sourceDest;
        try {
            if (object instanceof Queue) {
                this._sourceDestName = "queue:" + ((Queue)object).getQueueName();
                return this._sourceDestName;
            }
            if (object instanceof Topic) {
                this._sourceDestName = "topic:" + ((Topic)object).getTopicName();
                return this._sourceDestName;
            }
            this._sourceDestName = object.toString();
            return this._sourceDestName;
        }
        catch (Throwable throwable) {
            this._logger.log(Level.WARNING, "Unable to get source destination name in " + this, throwable);
            this._sourceDestName = object.toString();
            return this._sourceDestName;
        }
    }

    public String getTargetDestinationName() {
        if (this._targetDestName == null) {
            this._targetDestName = this.toDestinationName(this._targetDest);
        }
        return this._targetDestName;
    }

    private String toDestinationName(Object object) {
        Object object2 = object;
        try {
            if (object2 instanceof Queue) {
                return "queue:" + ((Queue)object2).getQueueName();
            }
            if (object instanceof Topic) {
                return "topic:" + ((Topic)object2).getTopicName();
            }
            return object2.toString();
        }
        catch (Throwable throwable) {
            this._logger.log(Level.WARNING, "Unable to get destination from object " + object + " in " + this, throwable);
            return object2.toString();
        }
    }

    public String getTargetCurrentDestinationName() {
        if (this._targetCurrentDestinationName == null) {
            return this.getTargetDestinationName();
        }
        return this._targetCurrentDestinationName;
    }

    public void setSourceConnectionFactory(Object object) {
        this._sourceCF = object;
    }

    public void setTargetConnectionFactory(Object object) {
        this._targetCF = object;
    }

    public void setSourceDestination(Object object) {
        this._sourceDest = object;
    }

    public void setTargetDestination(Object object) {
        this._targetDest = object;
    }

    public Object getSourceDestination() {
        return this._sourceDest;
    }

    public Object getTargetDestination() {
        return this._targetDest;
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this._sourceConn instanceof XAConnection) {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1039", this.toString()));
                this.runTransacted();
            } else {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1040", this.toString()));
                this.runNonTransacted();
            }
        }
        catch (Throwable throwable) {
            Level level = Level.WARNING;
            if (this._state != LinkState.STOPPING && this._state != LinkState.STOPPED) {
                level = Level.SEVERE;
            }
            if (throwable instanceof InterruptedException) {
                this._logger.log(level, "Link thread is interrupted in " + this);
            } else {
                this._logger.log(level, "Runtime exception in " + this, throwable);
            }
        }
        finally {
            this.closeSource();
            this.closeTarget();
        }
        if (this._state != LinkState.STOPPING && this._state != LinkState.STOPPED) {
            try {
                this.stop();
            }
            catch (Throwable throwable) {
                this._logger.log(Level.WARNING, "Exception in stopping link " + this + ": " + throwable.getMessage());
            }
        }
        this._logger.log(Level.INFO, _jbr.getString("BSJ1041", this.toString()));
    }

    /*
     * Exception decompiling
     */
    private void runTransacted() throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logWarning(String string, Throwable throwable) {
        if (this._state == LinkState.STOPPING || this._state == LinkState.STOPPED) {
            this._logger.log(Level.WARNING, string + ": " + throwable.getMessage());
        } else {
            this._logger.log(Level.WARNING, string, throwable);
        }
    }

    private void sendToDMQ(Message message, String string, DMQ.DMQReason dMQReason, Throwable throwable) throws Throwable {
        try {
            this._parent.toDMQ(message, string, dMQReason, throwable, this);
        }
        catch (Throwable throwable2) {
            this._logger.log(Level.SEVERE, "Failed to send " + (Object)((Object)dMQReason) + " message " + string + " to DMQ in " + this, throwable2);
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExpiredMessage(Message message, String string, Transaction transaction, TransactionManager transactionManager, XAResourceHandle xAResourceHandle) throws Throwable {
        Object[] objectArray = new String[]{string, xAResourceHandle.toString(), transaction.toString(), this.toString()};
        this._logger.log(Level.INFO, _jbr.getString("BSJ1042", objectArray));
        try {
            this.sendToDMQ(message, string, DMQ.DMQReason.MESSAGE_EXPIRED, null);
        }
        finally {
            try {
                transactionManager.rollback();
            }
            catch (Throwable throwable) {
                this._logger.log(Level.WARNING, "Unable to rollback transaction " + transaction + " for expired message " + string + " in " + this, throwable);
            }
        }
    }

    private boolean doEnlistAndRollbackOnError(Transaction transaction, TransactionManager transactionManager, XAResourceHandle xAResourceHandle) {
        try {
            xAResourceHandle.enlisted = transaction.enlistResource(xAResourceHandle.xar);
        }
        catch (RollbackException rollbackException) {
            this._logger.log(Level.SEVERE, "The transaction " + transaction + " is marked rollback only by " + xAResourceHandle + " in " + this, rollbackException);
            try {
                transactionManager.rollback();
            }
            catch (Throwable throwable) {
                this._logger.log(Level.SEVERE, "Exception in rollback transacion " + transaction + " after enlist returned rollback-only in " + this, throwable);
            }
            xAResourceHandle.ex = new RuntimeException("The transaction " + transaction + " is marked rollback only by " + xAResourceHandle + " in " + this, rollbackException);
            return false;
        }
        catch (Throwable throwable) {
            this._logger.log(Level.SEVERE, "Exception to enlist " + xAResourceHandle + " to transaction " + transaction + " in " + this, throwable);
            try {
                transactionManager.rollback();
            }
            catch (Throwable throwable2) {
                this._logger.log(Level.SEVERE, "Exception in rollback transacion " + transaction + " after enlist " + xAResourceHandle + " failure in " + this, throwable2);
            }
            xAResourceHandle.ex = new RuntimeException("Exception to enlist " + xAResourceHandle + " to transaction " + transaction + " in " + this, throwable);
            return false;
        }
        if (!xAResourceHandle.enlisted) {
            this._logger.log(Level.SEVERE, xAResourceHandle + " was not enlisted to transaction " + transaction + " successfully in " + this);
            try {
                transactionManager.rollback();
            }
            catch (Throwable throwable) {
                this._logger.log(Level.SEVERE, "Exception in rollback transacion " + transaction + " after enlist " + xAResourceHandle + " failure in " + this, throwable);
            }
            xAResourceHandle.ex = new RuntimeException(xAResourceHandle + " was not enlisted to transaction " + transaction + " successfully in " + this);
            return false;
        }
        return true;
    }

    private boolean doDelistAndRollbackOnError(Transaction transaction, TransactionManager transactionManager, XAResourceHandle xAResourceHandle) {
        try {
            xAResourceHandle.delisted = transaction.delistResource(xAResourceHandle.xar, 0x4000000);
        }
        catch (Throwable throwable) {
            this._logger.log(Level.WARNING, "Unable delist " + xAResourceHandle + " from transaction " + transaction + " in " + this, throwable);
            try {
                transactionManager.rollback();
            }
            catch (Throwable throwable2) {
                this._logger.log(Level.WARNING, "Unable to rollback transaction " + transaction + " after delist " + xAResourceHandle + " failure in " + this, throwable2);
            }
            xAResourceHandle.ex = new RuntimeException("Unable delist " + xAResourceHandle + " from transaction " + transaction + " in " + this, throwable);
            return false;
        }
        if (!xAResourceHandle.delisted) {
            this._logger.log(Level.SEVERE, xAResourceHandle + " was not delisted from transaction " + transaction + " successfully in " + this);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception) {
                this._logger.log(Level.SEVERE, "Exception in rollback transacion " + transaction + " in " + this, exception);
            }
            xAResourceHandle.ex = new RuntimeException(xAResourceHandle + " was not delisted from transaction " + transaction + " successfully in " + this);
            return false;
        }
        return true;
    }

    private void doFinally(Transaction transaction, TransactionManager transactionManager, XAResourceHandle xAResourceHandle, XAResourceHandle xAResourceHandle2) {
        if (transaction != null) {
            int n = 0;
            try {
                n = transaction.getStatus();
            }
            catch (Throwable throwable) {
                this._logger.log(Level.WARNING, "Unable to get transaction " + transaction + " status in " + this, throwable);
            }
            if (n != 6) {
                if (xAResourceHandle.enlisted && !xAResourceHandle.delisted) {
                    try {
                        transaction.delistResource(xAResourceHandle.xar, 0x20000000);
                    }
                    catch (Throwable throwable) {
                        this._logger.log(Level.WARNING, "Unable to delist " + xAResourceHandle + " in transaction " + transaction + " " + this + ": " + throwable.getMessage());
                    }
                }
                if (xAResourceHandle2 != null && xAResourceHandle2.xar != xAResourceHandle.xar && xAResourceHandle2.enlisted && !xAResourceHandle2.delisted) {
                    try {
                        transaction.delistResource(xAResourceHandle2.xar, 0x20000000);
                    }
                    catch (Throwable throwable) {
                        this._logger.log(Level.WARNING, "Unable to delist " + xAResourceHandle2 + " in transaction " + transaction + " " + this + ": " + throwable.getMessage());
                    }
                }
                this._sourceConnException = true;
                this._targetConnException = true;
            }
            try {
                n = transaction.getStatus();
            }
            catch (Throwable throwable) {
                this._logger.log(Level.WARNING, "Unable to get transaction " + transaction + " status in " + this, throwable);
            }
            if (n != 6 && n != 3 && n != 8 && n != 4 && n != 9 && n != 5 && n != 1) {
                this._logger.log(Level.WARNING, "Rolling back transaction (status=" + n + ")" + transaction + " in " + this);
                try {
                    transactionManager.rollback();
                }
                catch (Throwable throwable) {
                    this._logger.log(Level.WARNING, "Exception to rollback transaction " + transaction + " in " + this, throwable);
                }
            }
        }
        if (!this._targetStayConnected) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Close target in " + this);
            }
            this.closeTarget();
        }
    }

    private boolean isTransactionActive(Transaction transaction, TransactionManager transactionManager) {
        boolean bl = false;
        int n = 0;
        try {
            n = transaction.getStatus();
        }
        catch (Throwable throwable) {
            this._logger.log(Level.SEVERE, "Unable to get transaction " + transaction + " status in " + this, throwable);
            bl = true;
        }
        if (!bl) {
            switch (n) {
                case 0: {
                    return true;
                }
                case 3: {
                    this._logger.log(Level.WARNING, "Unexpected STATUS_COMMITTED for transaction " + transaction + " in " + this);
                    return false;
                }
                case 8: {
                    this._logger.log(Level.WARNING, "Unexpected STATUS_COMMITTED for transaction " + transaction + " in " + this);
                    return false;
                }
                case 1: {
                    this._logger.log(Level.WARNING, "Transaction " + transaction + " marked rollback, rolling back ... in " + this);
                    bl = true;
                    break;
                }
                case 6: {
                    this._logger.log(Level.WARNING, "Transaction " + transaction + " has STATUS_NO_TRANSACTION");
                    return false;
                }
                case 2: {
                    this._logger.log(Level.WARNING, "Unexpected STATUS_PREPARED for transaction " + transaction + ", rolling back ... in " + this);
                    bl = true;
                    break;
                }
                case 7: {
                    this._logger.log(Level.WARNING, "Unexpected STATUS_PREPARING for transaction " + transaction + ", set rollback only ... in " + this);
                    try {
                        transaction.setRollbackOnly();
                    }
                    catch (Throwable throwable) {
                        this._logger.log(Level.WARNING, "Unable to set transaction " + transaction + " rollback only in " + this);
                    }
                    bl = true;
                }
                case 4: {
                    this._logger.log(Level.WARNING, "Transaction " + transaction + " has STATUS_ROLLEDBACK in " + this);
                    return false;
                }
                case 9: {
                    this._logger.log(Level.WARNING, "Transaction " + transaction + " has STATUS_ROLLING_BACK in " + this);
                    return false;
                }
                case 5: {
                    this._logger.log(Level.WARNING, "Unexpected STATUS_UNKNOWN for transaction " + transaction + ", rolling back ... in " + this);
                    bl = true;
                    break;
                }
                default: {
                    this._logger.log(Level.WARNING, "Unexpected status " + n + " for transaction " + transaction + ", rolling back ... in " + this);
                    bl = true;
                }
            }
        }
        try {
            transactionManager.rollback();
        }
        catch (Throwable throwable) {
            this._logger.log(Level.WARNING, "Exception in rollback transacion " + transaction + " in " + this, throwable);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void runNonTransacted() throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message handleMessageTransformer(Message message, MessageHeaders messageHeaders) throws Throwable {
        Message message2 = message;
        String string = messageHeaders.mid;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Retain JMSReplyTo " + this._retainReplyTo + " for message " + string + " in " + this);
        }
        if (!this._retainReplyTo) {
            try {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Setting JMSReplyTo null for message " + string + " in " + this);
                }
                message2.setJMSReplyTo(null);
            }
            catch (Throwable throwable) {
                this._logger.log(Level.WARNING, "setJMSReplyTo(null) failed: " + throwable.getMessage() + " in " + this, throwable);
            }
        }
        boolean bl = false;
        Destination destination = message.getJMSDestination();
        if (this._msgTransformer != null) {
            this._msgTransformer.init(this._targetSession, "JMS");
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Transforming message " + string + " using " + this._msgTransformer.getClass().getName() + " in " + this);
            }
            try {
                try {
                    message2 = this._msgTransformer.transform(message, true, null, this.getSourceProviderName(), this.getTargetProviderName(), this._msgTransformerProps);
                    bl = true;
                    if (message2 == null) {
                        throw new BridgeException(_jbr.getKString("BSJ4034", this._msgTransformer.getClass().getName() + ".transform()", string));
                    }
                }
                finally {
                    MessageHeaders.resetMessageHeaders(message, messageHeaders);
                }
                if (this._fi.FAULT_INJECTION) {
                    this._fi.setLogger(this._logger);
                    this._fi.checkFaultAndThrowException("transform.2", null, "javax.jms.JMSException", true);
                }
                if (this._msgTransformer.isNoTransfer()) {
                    Object[] objectArray = new String[]{"MessageTransformer.transform()", string, this.toString()};
                    this._logger.log(Level.INFO, _jbr.getString("BSJ1065", objectArray));
                    if (this._firstTransformerNoTransfer) {
                        this.sendToDMQ(message, string, DMQ.DMQReason.FIRST_TRANSFORMER_NOTRANSFER, null);
                        this._firstTransformerNoTransfer = false;
                    }
                    return null;
                }
            }
            catch (Throwable throwable) {
                if (this._consumeOnTransformError && (!bl || message2 == null)) {
                    this._logger.log(Level.WARNING, "Exception from message transformer: " + throwable.getMessage() + " for message " + message + " in " + this, throwable);
                    this.sendToDMQ(message, string, DMQ.DMQReason.TRANSFORMER_FAILURE, throwable);
                    return null;
                }
                throw throwable;
            }
            if (this._logger.isLoggable(Level.FINE)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Transformed message " + string);
                try {
                    stringBuffer.append(" to " + message2 + " in " + this);
                }
                catch (Throwable throwable) {
                    stringBuffer.append(" in " + this);
                }
                this._logger.log(Level.FINE, stringBuffer.toString());
            }
        }
        this.handleBranchTo(message, message2, string, bl, destination);
        return message2;
    }

    private void handleBranchTo(Message message, Message message2, String string, boolean bl, Destination destination) throws Throwable {
        this._branchProducer = null;
        if (!bl) {
            if (this._unidentifiedProducer) {
                this._targetCurrentDestinationName = this.toDestinationName(destination);
                this._branchProducer = this.createProducer(destination, string, false);
                Object[] objectArray = new String[]{string, "Message.getJMSDestination:" + this.getTargetCurrentDestinationName(), this.toString()};
                this._logger.log(Level.INFO, _jbr.getString("BSJ1066", objectArray));
            }
            return;
        }
        Object object = this._msgTransformer.getBranchTo();
        if (object == null) {
            if (this._unidentifiedProducer) {
                this._targetCurrentDestinationName = this.toDestinationName(destination);
                this._branchProducer = this.createProducer(destination, string, false);
                Object[] objectArray = new String[]{string, "Message.getJMSDestination:" + this.getTargetCurrentDestinationName(), this.toString()};
                this._logger.log(Level.INFO, _jbr.getString("BSJ1067", objectArray));
            }
            return;
        }
        this._branchProducer = this.createProducer(object, string, true);
        this._targetCurrentDestinationName = this.toDestinationName(this._branchProducer.getDestination());
        Object[] objectArray = new String[]{string, (object instanceof String ? "[destination-ref:" + object + "]" : "") + this.getTargetCurrentDestinationName(), this.toString()};
        this._logger.log(Level.INFO, _jbr.getString("BSJ1069", objectArray));
        if (this._firstTransformerBranchTo) {
            this.sendToDMQ(message, string, DMQ.DMQReason.FIRST_TRANSFORMER_BRANCHTO, null);
            this._firstTransformerBranchTo = false;
        }
    }

    public LinkState getState() {
        return this._state;
    }

    class XAResourceHandle {
        XAResource xar = null;
        boolean enlisted = false;
        boolean delisted = true;
        boolean istarget = false;
        RuntimeException ex = null;

        public XAResourceHandle(boolean bl) {
            this.istarget = bl;
        }

        public String toString() {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("[");
            if (this.istarget) {
                JMSBridgeResources jMSBridgeResources = _jbr;
                _jbr;
                string = jMSBridgeResources.getString("BSJ0002");
            } else {
                JMSBridgeResources jMSBridgeResources = _jbr;
                _jbr;
                string = jMSBridgeResources.getString("BSJ0001");
            }
            return stringBuilder.append(string).append("]").append(this.xar).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkState {
        UNINITIALIZED{

            public String toString(ResourceBundle resourceBundle) {
                return resourceBundle.getString("BS1500");
            }
        }
        ,
        STARTING{

            public String toString(ResourceBundle resourceBundle) {
                return resourceBundle.getString("BS1501");
            }
        }
        ,
        STARTED{

            public String toString(ResourceBundle resourceBundle) {
                return resourceBundle.getString("BS1502");
            }
        }
        ,
        STOPPING{

            public String toString(ResourceBundle resourceBundle) {
                return resourceBundle.getString("BS1503");
            }
        }
        ,
        STOPPED{

            public String toString(ResourceBundle resourceBundle) {
                return resourceBundle.getString("BS1504");
            }
        }
        ,
        PAUSING{

            public String toString(ResourceBundle resourceBundle) {
                return resourceBundle.getString("BS1505");
            }
        }
        ,
        PAUSED{

            public String toString(ResourceBundle resourceBundle) {
                return resourceBundle.getString("BS1506");
            }
        };


        public abstract String toString(ResourceBundle var1);

        public String toString() {
            return this.toString(_jbr);
        }
    }
}

