/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store;

import java.io.Serializable;
import java.util.Map;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.shoal.ha.cache.api.DataStore;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.DataStoreFactory;
import org.shoal.ha.cache.api.DefaultObjectInputOutputStreamFactory;

public class InMemoryBackingStore<K extends Serializable, V extends Serializable>
extends BackingStore<K, V> {
    DataStore<K, V> dataStore;

    protected void initialize(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        ClassLoader cl;
        super.initialize(conf);
        DataStoreConfigurator dsConf = new DataStoreConfigurator();
        dsConf.setInstanceName(conf.getInstanceName()).setGroupName(conf.getClusterName()).setStoreName(conf.getStoreName()).setKeyClazz(conf.getKeyClazz()).setValueClazz(conf.getValueClazz());
        Map vendorSpecificMap = conf.getVendorSpecificSettings();
        Object stGMS = vendorSpecificMap.get("start.gms");
        boolean startGMS = false;
        if (stGMS != null) {
            if (stGMS instanceof String) {
                try {
                    startGMS = Boolean.valueOf((String)stGMS);
                }
                catch (Throwable th) {}
            } else if (stGMS instanceof Boolean) {
                startGMS = (Boolean)stGMS;
            }
        }
        if ((cl = (ClassLoader)vendorSpecificMap.get("class.loader")) == null) {
            cl = conf.getValueClazz().getClassLoader();
        }
        dsConf.setClassLoader(cl).setStartGMS(startGMS);
        dsConf.setObjectInputOutputStreamFactory(new DefaultObjectInputOutputStreamFactory());
        this.dataStore = DataStoreFactory.createDataStore(dsConf);
    }

    public V load(K key, String version) throws BackingStoreException {
        return (V)((Serializable)this.dataStore.get(key));
    }

    public String save(K key, V value, boolean isNew) throws BackingStoreException {
        return this.dataStore.put(key, value);
    }

    public void remove(K key) throws BackingStoreException {
        this.dataStore.remove(key);
    }

    public int removeExpired(long idleTime) throws BackingStoreException {
        return this.dataStore.removeIdleEntries(idleTime);
    }

    public int size() throws BackingStoreException {
        return 0;
    }

    public void destroy() throws BackingStoreException {
        this.dataStore.close();
    }

    public void updateTimestamp(K key, long time) throws BackingStoreException {
        this.dataStore.touch(key, time);
    }
}

