/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.api;

import java.io.IOException;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.Utility;

public abstract class DataStoreEntry<K, V> {
    private K key;
    private long version;
    private long maxIdleTime;
    private long lastAccessedAt;

    public void setKey(K key) {
        this.key = key;
    }

    public K getKey() {
        return this.key;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public long getLastAccessedAt() {
        return this.lastAccessedAt;
    }

    public void setLastAccessedAt(long lastAccessedAt) {
        this.lastAccessedAt = lastAccessedAt;
    }

    public final void writeDataStoreEntry(DataStoreContext<K, V> ctx, ReplicationOutputStream ros) throws IOException {
        int payloadOffsetMark = ros.mark();
        int payloadOffset = ros.mark();
        ros.write(Utility.intToBytes(payloadOffset));
        ros.write(Utility.longToBytes(this.getVersion()));
        ros.write(Utility.longToBytes(this.getMaxIdleTime()));
        ros.write(Utility.longToBytes(this.getLastAccessedAt()));
        ctx.getDataStoreKeyHelper().writeKey(ros, this.key);
        payloadOffset = ros.mark() - payloadOffset;
        ros.reWrite(payloadOffsetMark, Utility.intToBytes(payloadOffset));
        this.writePayloadState(ctx.getDataStoreEntryHelper(), ros);
    }

    public void readDataStoreEntry(DataStoreContext<K, V> ctx, byte[] data, int index) throws IOException {
        int payloadOffset = Utility.bytesToInt(data, index);
        this.setVersion(Utility.bytesToLong(data, index + 4));
        this.setMaxIdleTime(Utility.bytesToLong(data, index + 12));
        this.setLastAccessedAt(Utility.bytesToLong(data, index + 20));
        this.setKey(ctx.getDataStoreKeyHelper().readKey(data, index + 28));
        this.readPayloadState(ctx.getDataStoreEntryHelper(), data, index + payloadOffset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReplicationState: [");
        sb.append(this.key).append("; ").append("; ").append(this.maxIdleTime).append("; ").append(this.lastAccessedAt);
        return sb.toString();
    }

    protected void writePayloadState(DataStoreEntryHelper<K, V> helper, ReplicationOutputStream ros) throws IOException {
    }

    protected void readPayloadState(DataStoreEntryHelper<K, V> helper, byte[] data, int index) {
    }
}

