/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.interceptor.ExecutionInterceptor;
import org.shoal.ha.cache.impl.util.MessageReceiver;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class CommandManager<K, V>
extends MessageReceiver {
    private static final Logger logger = Logger.getLogger("ReplicationLogger");
    private String myName;
    private String groupName;
    private DataStoreContext<K, V> dsc;
    private Command<K, V>[] commands = (Command[])Array.newInstance(Command.class, 256);
    private int interceptorSz = 0;
    private volatile ExecutionInterceptor<K, V> head;
    private volatile ExecutionInterceptor<K, V> tail;

    public CommandManager(DataStoreContext<K, V> dsc) {
        super(dsc.getServiceName());
        this.dsc = dsc;
        this.myName = dsc.getInstanceName();
        this.groupName = dsc.getGroupName();
    }

    public void registerCommand(Command<K, V> command) {
        this.commands[command.getOpcode()] = command;
        command.initialize(this.dsc);
    }

    public void unregisterCommand(byte opcode) {
        this.commands[opcode] = null;
    }

    public synchronized void registerExecutionInterceptor(ExecutionInterceptor<K, V> interceptor) {
        interceptor.initialize(this.dsc);
        if (this.head == null) {
            this.head = interceptor;
        } else {
            this.tail.setNext(interceptor);
        }
        interceptor.setPrev(this.tail);
        interceptor.setNext(null);
        this.tail = interceptor;
        ++this.interceptorSz;
    }

    public Command getCommand(byte opcode) {
        return this.commands[opcode];
    }

    public void execute(Command<K, V> cmd) {
        this.execute(cmd, true, this.myName);
    }

    public void execute(Command<K, V> cmd, boolean forward, String initiator) {
        cmd.initialize(this.dsc);
        if (this.head != null) {
            if (forward) {
                cmd.prepareToTransmit(this.dsc);
                if (!cmd.getTargetName().equals(this.myName)) {
                    this.head.onTransmit(cmd);
                } else {
                    cmd.execute(this.dsc);
                }
            } else {
                this.tail.onReceive(cmd);
            }
        }
    }

    public Command<K, V> createNewInstance(byte opcode, byte[] data, int offset) throws IOException {
        Command<K, V> cmd2 = this.commands[opcode];
        Command<K, V> cmd = null;
        if (cmd2 != null) {
            cmd = cmd2.createNewInstance();
            cmd.initialize(this.dsc);
            cmd.readCommandState(data, offset);
        }
        return cmd;
    }

    public void transmit(Command<K, V> cmd) {
    }

    public ResponseMediator getResponseMediator() {
        return this.dsc.getResponseMediator();
    }

    @Override
    protected void handleMessage(String sourceMemberName, String token, byte[] frameData) {
        byte opCode = frameData[0];
        Command<K, V> cmd2 = this.commands[opCode];
        if (cmd2 != null) {
            Command<K, V> cmd = cmd2.createNewInstance();
            cmd.initialize(this.dsc);
            try {
                cmd.readCommandState(frameData, 0);
                this.execute(cmd, false, sourceMemberName);
            }
            catch (IOException dse) {
                // empty catch block
            }
        }
    }
}

