/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.util.ObjectInputStreamWithLoader;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ReplicationState;
import org.shoal.ha.cache.impl.util.SimpleSerializer;

public class DefaultDataStoreEntryHelper<K, V>
implements DataStoreEntryHelper<K, V> {
    private ClassLoader loader;

    public DefaultDataStoreEntryHelper(ClassLoader cl) {
        this.loader = cl;
    }

    @Override
    public DataStoreEntry<K, V> createDataStoreEntry() {
        return new ReplicationState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStoreEntry<K, V> createDataStoreEntry(K k, V obj) {
        ReplicationState state = new ReplicationState();
        state.setKey(k);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
        }
        catch (IOException ioEx) {
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException ioEx) {}
            try {
                bos.close();
            }
            catch (IOException ioEx) {}
        }
        byte[] data = bos.toByteArray();
        state.setAttribute("value", data);
        return state;
    }

    @Override
    public V getV(DataStoreEntry<K, V> replicationEntry) throws DataStoreException {
        byte[] data = ((ReplicationState)replicationEntry).getAttribute("value");
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream ois = null;
        Object v = null;
        try {
            ois = new ObjectInputStreamWithLoader(bis, this.loader);
            v = ois.readObject();
        }
        catch (IOException ioEx) {
            throw new DataStoreException(ioEx);
        }
        catch (ClassNotFoundException cnfEx) {
            throw new DataStoreException(cnfEx);
        }
        finally {
            try {
                ois.close();
            }
            catch (IOException ioEx1) {}
            try {
                bis.close();
            }
            catch (IOException ioEx2) {}
        }
        return (V)v;
    }

    @Override
    public void writeObject(ReplicationOutputStream ros, Object obj) throws IOException {
        SimpleSerializer.serialize(ros, obj);
    }

    @Override
    public Object readObject(byte[] data, int index) throws DataStoreException {
        try {
            return SimpleSerializer.deserialize(this.loader, data, index);
        }
        catch (ClassNotFoundException cnfEx) {
            throw new DataStoreException("Cannot desrialize value", cnfEx);
        }
        catch (IOException ioEx) {
            throw new DataStoreException("Cannot desrialize value", ioEx);
        }
    }

    @Override
    public void updateDelta(K k, DataStoreEntry<K, V> kvDataStoreEntry, Object obj) {
        throw new UnsupportedOperationException("updateDelta(K k, DataStoreEntry<K, V> kvDataStoreEntry, Object obj) not supported");
    }
}

