/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.util.Collection;
import org.shoal.ha.cache.api.DataStore;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreEntryEvaluator;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.DataStoreKeyHelper;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.cache.impl.command.LoadRequestCommand;
import org.shoal.ha.cache.impl.command.LoadResponseCommand;
import org.shoal.ha.cache.impl.command.RemoveCommand;
import org.shoal.ha.cache.impl.command.SaveCommand;
import org.shoal.ha.cache.impl.command.TouchCommand;
import org.shoal.ha.cache.impl.command.UpdateDeltaCommand;
import org.shoal.ha.cache.impl.interceptor.CommandMonitorInterceptor;
import org.shoal.ha.cache.impl.interceptor.TransmitInterceptor;
import org.shoal.ha.cache.impl.store.ReplicaStore;
import org.shoal.ha.cache.impl.util.DefaultKeyMapper;
import org.shoal.ha.group.GroupService;
import org.shoal.ha.mapper.KeyMapper;

public class ReplicatedDataStore<K, V>
implements DataStore<K, V> {
    private String storeName;
    private String instanceName;
    private String groupName;
    private GroupService gs;
    private CommandManager<K, V> cm;
    private DataStoreEntryHelper<K, V> transformer;
    private DataStoreContext<K, V> dsc;
    private DataStoreConfigurator<K, V> conf;

    public ReplicatedDataStore(DataStoreConfigurator<K, V> conf, GroupService gs) {
        this.conf = conf;
        this.storeName = conf.getStoreName();
        this.gs = gs;
        this.instanceName = gs.getMemberName();
        this.groupName = gs.getGroupName();
        this.initialize(conf.getClassLoader(), conf.getDataStoreEntryHelper(), conf.getDataStoreKeyHelper(), conf.getKeyMapper());
    }

    public ReplicatedDataStore(String storeName, GroupService gs, ClassLoader loader, DataStoreEntryHelper<K, V> helper, DataStoreKeyHelper<K> keyHelper, KeyMapper keyMapper) {
        DataStoreConfigurator conf = new DataStoreConfigurator();
        conf.setStoreName(storeName).setClassLoader(loader);
        this.storeName = storeName;
        this.gs = gs;
        this.instanceName = gs.getMemberName();
        this.groupName = gs.getGroupName();
        this.initialize(loader, helper, keyHelper, keyMapper);
    }

    private void initialize(ClassLoader loader, DataStoreEntryHelper<K, V> helper, DataStoreKeyHelper<K> keyHelper, KeyMapper keyMapper) {
        this.dsc = new DataStoreContext(this.storeName, this.gs, loader);
        this.transformer = helper;
        this.dsc.setDataStoreEntryHelper(helper);
        this.dsc.setDataStoreKeyHelper(keyHelper);
        this.dsc.setKeyMapper(keyMapper);
        this.cm = this.dsc.getCommandManager();
        this.cm.registerExecutionInterceptor(new CommandMonitorInterceptor());
        this.cm.registerExecutionInterceptor(new TransmitInterceptor());
        this.cm.registerCommand(new SaveCommand());
        this.cm.registerCommand(new LoadRequestCommand());
        this.cm.registerCommand(new LoadResponseCommand(null, null, 0L));
        this.cm.registerCommand(new RemoveCommand());
        this.cm.registerCommand(new TouchCommand());
        if (keyMapper != null && keyMapper instanceof DefaultKeyMapper) {
            this.gs.registerGroupMemberEventListener((DefaultKeyMapper)keyMapper);
            for (String member : this.gs.getCurrentCoreMembers()) {
                ((DefaultKeyMapper)keyMapper).registerInstance(member);
            }
        }
        this.gs.registerGroupMessageReceiver(this.storeName, this.cm);
    }

    @Override
    public String put(K k, V v) {
        SaveCommand<K, V> cmd = new SaveCommand<K, V>(k, v);
        this.cm.execute(cmd);
        return cmd.getTargetName();
    }

    @Override
    public void updateDelta(K k, Object obj) {
        UpdateDeltaCommand cmd = new UpdateDeltaCommand();
        cmd.setObject(obj);
        this.cm.execute(cmd);
    }

    @Override
    public V get(K k) {
        ReplicaStore<K, V> replicaStore = this.dsc.getReplicaStore();
        DataStoreEntry<K, V> entry = replicaStore.get(k);
        V v = null;
        try {
            if (entry == null) {
                LoadRequestCommand cmd = new LoadRequestCommand(k);
                this.cm.execute(cmd);
                entry = cmd.getResult();
            }
            if (entry != null) {
                v = this.transformer.getV(entry);
            }
        }
        catch (DataStoreException dseEx) {
            dseEx.printStackTrace();
        }
        return v;
    }

    @Override
    public void remove(K k) {
        RemoveCommand cmd = new RemoveCommand();
        cmd.setKey(k);
        this.cm.execute(cmd);
    }

    @Override
    public void touch(K k, long ttl) {
        TouchCommand tc = new TouchCommand(k, 0L, 0L, ttl);
    }

    @Override
    public int removeIdleEntries(long idleFor) {
        return 0;
    }

    @Override
    public Collection find(DataStoreEntryEvaluator<K, V> kvDataStoreEntryEvaluator) {
        return null;
    }

    @Override
    public void update(DataStoreEntryEvaluator<K, V> kvDataStoreEntryEvaluator) {
    }

    @Override
    public void close() {
    }
}

