/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.command.LoadResponseCommand;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationIOUtils;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;
import org.shoal.ha.cache.impl.util.Utility;

public class LoadRequestCommand<K, V>
extends Command<K, V> {
    private K key;
    CommandResponse resp;
    private Future future;
    private long tokenId;
    private String originatingInstance;

    public LoadRequestCommand() {
        this(null);
    }

    public LoadRequestCommand(K key) {
        super((byte)35);
        this.key = key;
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    @Override
    protected LoadRequestCommand<K, V> createNewInstance() {
        return new LoadRequestCommand<K, V>();
    }

    @Override
    public void writeCommandPayload(DataStoreContext<K, V> trans, ReplicationOutputStream ros) throws IOException {
        ros.write(Utility.longToBytes(this.resp.getTokenId()));
        int keyLen = ReplicationIOUtils.writeLengthPrefixedKey(this.key, trans.getDataStoreKeyHelper(), ros);
        ReplicationIOUtils.writeLengthPrefixedString(ros, this.originatingInstance);
        trans.getDataStoreKeyHelper().writeKey(ros, this.key);
    }

    @Override
    public void readCommandPayload(DataStoreContext<K, V> trans, byte[] data, int offset) throws IOException {
        this.tokenId = Utility.bytesToLong(data, offset);
        ReplicationIOUtils.KeyInfo<K> keyInfo = ReplicationIOUtils.readLengthPrefixedKey(trans.getDataStoreKeyHelper(), data, offset + 8);
        this.key = keyInfo.key;
        this.originatingInstance = ReplicationIOUtils.readLengthPrefixedString(data, offset + 8 + 4 + keyInfo.keyLen);
    }

    @Override
    protected void prepareToTransmit(DataStoreContext<K, V> ctx) {
        this.originatingInstance = ctx.getInstanceName();
        String targetName = ctx.getKeyMapper().findReplicaInstance(ctx.getGroupName(), this.key);
        this.setTargetName(targetName);
        System.out.println("**Sending loadRequest to: " + this.getTargetName());
        ResponseMediator respMed = ctx.getResponseMediator();
        this.resp = respMed.createCommandResponse();
        this.future = this.resp.getFuture();
    }

    @Override
    public void execute(DataStoreContext<K, V> ctx) {
        DataStoreEntry<K, V> e = ctx.getReplicaStore().get(this.key);
        if (!this.originatingInstance.equals(ctx.getInstanceName())) {
            LoadResponseCommand<K, V> rsp = new LoadResponseCommand<K, V>(this.key, e, this.tokenId);
            rsp.setOriginatingInstance(this.originatingInstance);
            System.out.println("LoadRequestCommand.execute: key: " + this.key + " from " + this.originatingInstance + "; tokenId: " + this.tokenId);
            this.getCommandManager().execute(rsp);
        } else {
            this.resp.setResult(e);
        }
    }

    public DataStoreEntry<K, V> getResult() throws DataStoreException {
        try {
            return (DataStoreEntry)this.future.get(15000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException inEx) {
            System.out.println("Error: InterruptedException while waiting for result");
            throw new DataStoreException(inEx);
        }
        catch (TimeoutException timeoutEx) {
            System.out.println("Error: Timedout while waiting for result");
            throw new DataStoreException(timeoutEx);
        }
        catch (ExecutionException exeEx) {
            System.out.println("Error: ExecutionException while waiting for result");
            throw new DataStoreException(exeEx);
        }
    }
}

