/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.command.ReplicationCommandTransmitter;
import org.shoal.ha.cache.impl.interceptor.ExecutionInterceptor;

public class ReplicationCommandTransmitterManager<K, V>
extends ExecutionInterceptor<K, V> {
    private static final Logger logger = GMSLogDomain.getLogger((String)"ShoalLogger");
    private ConcurrentHashMap<String, ReplicationCommandTransmitter<K, V>> transmitters = new ConcurrentHashMap();
    private AtomicInteger indexCounter = new AtomicInteger();
    private ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap();
    private volatile String[] instances = new String[0];

    public void memberReady(String instanceName, String groupName) {
        logger.info("**=> ReplicationCommandTransmitterManager::memberReady(" + instanceName + ", " + groupName + ")");
        ReplicationCommandTransmitter trans = new ReplicationCommandTransmitter();
        trans.initialize(instanceName, this.getDataStoreContext());
        TreeSet<String> set = new TreeSet<String>(Arrays.asList(this.instances));
        set.add(instanceName);
        this.instances = set.toArray(new String[0]);
        this.transmitters.put(instanceName, trans);
    }

    public void memberLeft(String instanceName, String groupName) {
        this.map.remove(instanceName);
        TreeSet<String> set = new TreeSet<String>(Arrays.asList(this.instances));
        set.remove(instanceName);
        this.instances = set.toArray(new String[0]);
        logger.info(" ReplicationServiceImpl.memberLeft() ==> " + instanceName);
        this.transmitters.remove(instanceName);
    }

    public void groupShutdown(String groupName) {
    }

    public String getMappedInstance(String key) {
        int index = Math.abs(key.hashCode()) % this.instances.length;
        return this.instances[index];
    }

    public String[] getMappedInstances(String key) {
        int index = Math.abs(key.hashCode()) % this.instances.length;
        return new String[]{this.instances[index]};
    }

    @Override
    public void onTransmit(Command<K, V> cmd) {
        if (cmd.getOpcode() != 51) {
            String target = cmd.getTargetName();
            System.out.println("** ReplicationCommandTransmitterManager: About to transmit to " + target + "; cmd: " + cmd);
            ReplicationCommandTransmitter<K, V> rft = this.transmitters.get(target);
            if (rft == null) {
                rft = new ReplicationCommandTransmitter();
                rft.initialize(target, this.getDataStoreContext());
                this.transmitters.put(target, rft);
            }
            rft.addCommand(cmd);
        } else {
            super.onTransmit(cmd);
        }
    }
}

