/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.util.concurrent.ConcurrentHashMap;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreEntryHelper;

public class ReplicaStore<K, V> {
    private DataStoreContext<K, V> ctx;
    private ConcurrentHashMap<K, DataStoreEntry<K, V>> map = new ConcurrentHashMap();

    public ReplicaStore(DataStoreContext<K, V> ctx) {
        this.ctx = ctx;
    }

    public void put(K k, V v) {
        DataStoreEntryHelper<K, V> helper = this.ctx.getDataStoreEntryHelper();
        DataStoreEntry<K, V> e = helper.createDataStoreEntry(k, v);
        this.map.put(k, e);
        System.out.println("** ReplicaStore::put(" + k + ", " + v);
    }

    public DataStoreEntry<K, V> get(K k) {
        return this.map.get(k);
    }

    public void remove(K k) {
        this.map.remove(k);
    }

    public void touch(K k, long ts, long version, long ttl) {
        DataStoreEntry<K, V> e = this.map.get(k);
        if (e != null) {
            e.setLastAccessedAt(ts);
            e.setMaxIdleTime(ttl);
            e.setVersion(version);
        }
    }

    public int size() {
        return this.map.size();
    }
}

