/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.shoal.ha.cache.api.DataStore;
import org.shoal.ha.cache.api.DataStoreFactory;

public class DataStoreShell {
    DataStore ds;
    int counter = 0;

    public static void main(String[] args) {
        DataStore<String, Serializable> ds = DataStoreFactory.createDataStore(args[0], args[1], args[2]);
        DataStoreShell main = new DataStoreShell();
        main.runShell(ds);
    }

    private void runShell(DataStore ds) {
        this.ds = ds;
        String line = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        do {
            this.prompt();
            try {
                line = br.readLine();
                ArrayList<String> args = new ArrayList<String>();
                StringTokenizer tok = new StringTokenizer(line, "\n\r\t\f \f");
                while (tok.hasMoreTokens()) {
                    String str = tok.nextToken();
                    args.add(str);
                }
                if (args.size() <= 0) continue;
                String command = (String)args.remove(0);
                String[] params = args.toArray(new String[0]);
                this.execute(command, params);
                ++this.counter;
            }
            catch (IOException ioEx) {
                // empty catch block
            }
        } while (!"quit".equalsIgnoreCase(line));
    }

    private void prompt() {
        System.out.print("" + this.counter + ">");
        System.out.flush();
    }

    private void execute(String command, String[] params) {
        if ("put".equalsIgnoreCase(command)) {
            this.ds.put(params[0], params[1]);
        } else if ("get".equalsIgnoreCase(command)) {
            System.out.println("get(" + params[0] + ") => " + this.ds.get(params[0]));
        } else if ("remove".equalsIgnoreCase(command)) {
            this.ds.remove(params[0]);
        }
    }
}

