/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JoinedAndReadyNotificationSignalImpl
implements JoinedAndReadyNotificationSignal {
    private String memberToken;
    private String groupName;
    private List<String> currentCoreMembers;
    private List<String> allCurrentMembers;
    private static final String MEMBER_DETAILS = "MEMBERDETAILS";
    private GMSContext ctx;
    private final GMSConstants.startupType startupKind;
    protected static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private long startTime;

    public JoinedAndReadyNotificationSignalImpl(String memberToken, List<String> currentCoreMembers, List<String> allCurrentMembers, String groupName, long startTime) {
        this.memberToken = memberToken;
        this.currentCoreMembers = currentCoreMembers;
        this.allCurrentMembers = allCurrentMembers;
        this.groupName = groupName;
        this.startTime = startTime;
        this.ctx = GMSContextFactory.getGMSContext(groupName);
        GMSConstants.startupType startupType2 = this.startupKind = this.ctx.isGroupStartup() ? GMSConstants.startupType.GROUP_STARTUP : GMSConstants.startupType.INSTANCE_STARTUP;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JoinAndReadyNotificationSignalImpl ctor: member=" + memberToken + " group=" + groupName + " startupKind=" + this.startupKind.toString());
        }
    }

    JoinedAndReadyNotificationSignalImpl(JoinedAndReadyNotificationSignal signal) {
        this(signal.getMemberToken(), signal.getCurrentCoreMembers(), signal.getAllCurrentMembers(), signal.getGroupName(), signal.getStartTime());
    }

    @Override
    public void acquire() throws SignalAcquireException {
    }

    @Override
    public void release() throws SignalReleaseException {
        this.memberToken = null;
        this.currentCoreMembers = null;
        this.allCurrentMembers = null;
    }

    @Override
    public String getMemberToken() {
        return this.memberToken;
    }

    @Override
    public List<String> getCurrentCoreMembers() {
        return this.currentCoreMembers;
    }

    @Override
    public List<String> getAllCurrentMembers() {
        return this.allCurrentMembers;
    }

    @Override
    public Map<Serializable, Serializable> getMemberDetails() {
        DistributedStateCache dsc;
        HashMap<Serializable, Serializable> ret = new HashMap();
        if (this.ctx == null) {
            this.ctx = GMSContextFactory.getGMSContext(this.groupName);
        }
        if ((dsc = this.ctx.getDistributedStateCache()) != null) {
            ret = dsc.getFromCacheForPattern(MEMBER_DETAILS, this.memberToken);
        } else {
            logger.log(Level.WARNING, "no.instance.dsc", new Object[]{this.memberToken});
        }
        return ret;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public GMSConstants.startupType getEventSubType() {
        return this.startupKind;
    }
}

