/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport;

import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.mgmt.transport.BlockingIOMulticastSender;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageSender;
import com.sun.enterprise.mgmt.transport.NetworkManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VirtualMulticastSender
extends BlockingIOMulticastSender {
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    final List<PeerID> virtualPeerIdList = new ArrayList<PeerID>();
    final NetworkManager networkManager;

    public VirtualMulticastSender(String host, String multicastAddress, int multicastPort, String networkInterfaceName, int multicastPacketSize, PeerID localPeerID, Executor executor, NetworkManager networkManager, List<PeerID> virtualPeerIdList) throws IOException {
        super(host, multicastAddress, multicastPort, networkInterfaceName, multicastPacketSize, localPeerID, executor, networkManager);
        this.networkManager = networkManager;
        if (virtualPeerIdList != null && !virtualPeerIdList.isEmpty()) {
            this.virtualPeerIdList.addAll(virtualPeerIdList);
        }
    }

    @Override
    public synchronized void stop() throws IOException {
        super.stop();
        this.virtualPeerIdList.clear();
    }

    @Override
    protected boolean doBroadcast(Message message) throws IOException {
        boolean result = true;
        if (!super.doBroadcast(message)) {
            result = false;
        }
        MessageSender tcpSender = this.networkManager.getMessageSender(0);
        for (PeerID peerID : this.virtualPeerIdList) {
            try {
                if (tcpSender.send(peerID, message)) continue;
                result = false;
            }
            catch (IOException ie) {
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.log(Level.FINEST, "failed to send a message to a virtual multicast endpoint(" + peerID + ")", ie);
            }
        }
        return result;
    }
}

