/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.AliveAndReadyView;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.RejoinSubevent;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.common.AliveAndReadyViewImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.spi.MemberStates;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AliveAndReadyViewWindow {
    protected static final Logger LOG = Logger.getLogger("ShoalLogger.ready");
    static final long MIN_VIEW_DURATION = 1000L;
    private long MAX_CLUSTER_STARTTIME_DURATION_MS = 10000L;
    static final int MAX_ALIVE_AND_READY_VIEWS = 5;
    private final List<AliveAndReadyView> aliveAndReadyView = new LinkedList<AliveAndReadyView>();
    private long viewId = 1L;
    private JoinedAndReadyNotificationActionFactoryImpl joinedAndReadyActionFactory = null;
    private FailureNotificationActionFactoryImpl failureActionFactory = null;
    private PlannedShutdownActionFactoryImpl plannedShutdownFactory = null;
    private final JoinedAndReadyCallBack jrcallback;
    private final LeaveCallBack leaveCallback;
    private long simulatedStartClusterTime;
    private AtomicBoolean isSimulatedStartCluster = new AtomicBoolean(false);
    private static final Level TRACE_LEVEL = Level.FINE;

    public AliveAndReadyViewWindow(GMSContext ctx) {
        Router router = ctx.getRouter();
        this.jrcallback = new JoinedAndReadyCallBack(ctx.getGroupHandle(), this.aliveAndReadyView);
        this.joinedAndReadyActionFactory = new JoinedAndReadyNotificationActionFactoryImpl(this.jrcallback);
        this.leaveCallback = new LeaveCallBack(ctx.getGroupHandle(), this.aliveAndReadyView);
        this.failureActionFactory = new FailureNotificationActionFactoryImpl(this.leaveCallback);
        this.plannedShutdownFactory = new PlannedShutdownActionFactoryImpl(this.leaveCallback);
        router.addSystemDestination(this.joinedAndReadyActionFactory);
        router.addSystemDestination(this.failureActionFactory);
        router.addSystemDestination(this.plannedShutdownFactory);
    }

    AliveAndReadyViewWindow() {
        this.jrcallback = new JoinedAndReadyCallBack(null, this.aliveAndReadyView);
        this.leaveCallback = new LeaveCallBack(null, this.aliveAndReadyView);
    }

    public void setStartClusterMaxDuration(long durationInMs) {
        this.MAX_CLUSTER_STARTTIME_DURATION_MS = durationInMs;
    }

    void junitProcessNotification(Signal signal) {
        if (signal instanceof JoinedAndReadyNotificationSignal) {
            this.jrcallback.processNotification(signal);
        } else if (signal instanceof PlannedShutdownSignal || signal instanceof FailureNotificationSignal) {
            this.leaveCallback.processNotification(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AliveAndReadyView getPreviousView() {
        AliveAndReadyView result = null;
        List<AliveAndReadyView> list = this.aliveAndReadyView;
        synchronized (list) {
            int size = this.aliveAndReadyView.size();
            if (size >= 2) {
                result = this.aliveAndReadyView.get(size - 2);
                Signal signal = result.getSignal();
                if (signal != null && signal instanceof JoinedAndReadyNotificationSignal) {
                    long duration;
                    JoinedAndReadyNotificationSignal jrsignal = (JoinedAndReadyNotificationSignal)signal;
                    if (jrsignal.getEventSubType() == GMSConstants.startupType.GROUP_STARTUP) {
                        if (LOG.isLoggable(TRACE_LEVEL)) {
                            LOG.log(TRACE_LEVEL, "getPreviousAliveAndReadyView: returning current view during cluster startup. JoinedAndReadyNotificationSignal indicates " + (Object)((Object)jrsignal.getEventSubType()));
                        }
                        result = this.aliveAndReadyView.get(size - 1);
                    } else if (this.isSimulatedStartCluster.get() && (duration = result.getSignalTime() - this.simulatedStartClusterTime) < this.MAX_CLUSTER_STARTTIME_DURATION_MS) {
                        if (LOG.isLoggable(TRACE_LEVEL)) {
                            LOG.log(TRACE_LEVEL, "getPreviousAliveAndReadyView: returning current view since detected cluster startup due to JoinedAndReadyNotification occurring within " + duration + " ms of initial startup");
                        }
                        result = this.aliveAndReadyView.get(size - 1);
                    }
                }
            } else if (size == 1) {
                result = this.aliveAndReadyView.get(0);
            }
        }
        if (LOG.isLoggable(TRACE_LEVEL)) {
            LOG.log(TRACE_LEVEL, "getPreviousAliveAndReadyView: returning " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AliveAndReadyView getCurrentView() {
        AliveAndReadyView result = null;
        List<AliveAndReadyView> list = this.aliveAndReadyView;
        synchronized (list) {
            int length = this.aliveAndReadyView.size();
            if (length > 0) {
                result = this.aliveAndReadyView.get(length - 1);
            }
        }
        return result;
    }

    private class JoinedAndReadyCallBack
    extends CommonCallBack {
        public JoinedAndReadyCallBack(GroupHandle gh, List<AliveAndReadyView> aliveAndReadyView) {
            super(gh, aliveAndReadyView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processNotification(Signal signal) {
            if (signal instanceof JoinedAndReadyNotificationSignal) {
                JoinedAndReadyNotificationSignal jrns = (JoinedAndReadyNotificationSignal)signal;
                RejoinSubevent rejoin = jrns.getRejoinSubevent();
                if (jrns.getCurrentCoreMembers().contains(signal.getMemberToken())) {
                    List list = this.aliveAndReadyView;
                    synchronized (list) {
                        if (this.aliveAndReadyView.size() == 0) {
                            if (LOG.isLoggable(TRACE_LEVEL)) {
                                LOG.log(TRACE_LEVEL, "first alive and ready view: initializing");
                            }
                            TreeSet<String> aliveAndReadyMembers = new TreeSet<String>();
                            block7: for (String member : jrns.getCurrentCoreMembers()) {
                                if (member.compareTo(signal.getMemberToken()) == 0) {
                                    aliveAndReadyMembers.add(member);
                                    continue;
                                }
                                if (this.gh == null) continue;
                                MemberStates states = this.gh.getMemberState(member, 10000L, 0L);
                                switch (states) {
                                    case ALIVEANDREADY: 
                                    case READY: {
                                        aliveAndReadyMembers.add(member);
                                        if (!LOG.isLoggable(TRACE_LEVEL)) continue block7;
                                        LOG.log(TRACE_LEVEL, "member added " + member + " with  a heartbeat state of " + states.toString());
                                        continue block7;
                                    }
                                    case UNKNOWN: {
                                        if (!LOG.isLoggable(TRACE_LEVEL)) continue block7;
                                        LOG.log(TRACE_LEVEL, "aliveAndReadyView initialization: member " + member + " has an UNKNOWN member state from 10 seconds of heartbeat state");
                                        continue block7;
                                    }
                                }
                                if (!LOG.isLoggable(TRACE_LEVEL)) continue;
                                LOG.log(TRACE_LEVEL, "member " + member + " not added with a heartbeat state of " + states.toString());
                            }
                            if (aliveAndReadyMembers.size() > 0) {
                                this.add(signal, aliveAndReadyMembers);
                            }
                        } else {
                            AliveAndReadyView current = (AliveAndReadyView)this.aliveAndReadyView.get(this.aliveAndReadyView.size() - 1);
                            TreeSet<String> currentMembers = new TreeSet<String>(current.getMembers());
                            if (rejoin == null) {
                                boolean result = currentMembers.add(signal.getMemberToken());
                                assert (result);
                            }
                            this.add(signal, currentMembers);
                        }
                    }
                }
            }
        }
    }

    private class LeaveCallBack
    extends CommonCallBack {
        public LeaveCallBack(GroupHandle gh, List<AliveAndReadyView> aliveAndReadyView) {
            super(gh, aliveAndReadyView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processNotification(Signal signal) {
            if (signal instanceof PlannedShutdownSignal || signal instanceof FailureNotificationSignal) {
                List list = this.aliveAndReadyView;
                synchronized (list) {
                    AliveAndReadyView current = AliveAndReadyViewWindow.this.getCurrentView();
                    if (current != null && current.getMembers().contains(signal.getMemberToken())) {
                        TreeSet<String> currentMembers = new TreeSet<String>(current.getMembers());
                        boolean result = currentMembers.remove(signal.getMemberToken());
                        assert (result);
                        this.add(signal, currentMembers);
                    }
                }
            }
        }
    }

    private abstract class CommonCallBack
    implements CallBack {
        protected final List<AliveAndReadyView> aliveAndReadyView;
        protected final GroupHandle gh;

        public CommonCallBack(GroupHandle gh, List<AliveAndReadyView> aliveAndReadyViews) {
            this.aliveAndReadyView = aliveAndReadyViews;
            this.gh = gh;
        }

        public void add(Signal signal, SortedSet<String> members) {
            AliveAndReadyViewImpl current = (AliveAndReadyViewImpl)AliveAndReadyViewWindow.this.getCurrentView();
            if (current != null) {
                current.setSignal(signal);
            }
            AliveAndReadyViewImpl arview = new AliveAndReadyViewImpl(members, AliveAndReadyViewWindow.this.viewId++);
            this.aliveAndReadyView.add(arview);
            if (this.aliveAndReadyView.size() > 5) {
                this.aliveAndReadyView.remove(0);
            }
        }
    }
}

