/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.Action;
import com.sun.enterprise.ee.cms.core.ActionException;
import com.sun.enterprise.ee.cms.core.FailureNotificationAction;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureRecoveryAction;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.FailureSuspectedAction;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.FailureSuspectedSignal;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationAction;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinNotificationAction;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationAction;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.MessageAction;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownAction;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.common.FailureNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.FailureRecoverySignalImpl;
import com.sun.enterprise.ee.cms.impl.common.FailureSuspectedSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.GroupLeadershipNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.JoinNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.JoinedAndReadyNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.PlannedShutdownSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.SignalHandler;
import com.sun.enterprise.ee.cms.impl.common.SignalPacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Router {
    private final Vector<FailureNotificationActionFactory> failureNotificationAF = new Vector();
    private final Hashtable<String, FailureRecoveryActionFactory> failureRecoveryAF = new Hashtable();
    private final Hashtable<String, MessageActionFactory> messageAF = new Hashtable();
    private final Vector<PlannedShutdownActionFactory> plannedShutdownAF = new Vector();
    private final Vector<JoinNotificationActionFactory> joinNotificationAF = new Vector();
    private final Vector<JoinedAndReadyNotificationActionFactory> joinedAndReadyNotificationAF = new Vector();
    private final Vector<FailureSuspectedActionFactory> failureSuspectedAF = new Vector();
    private final Vector<GroupLeadershipNotificationActionFactory> groupLeadershipNotificationAFs = new Vector();
    private final Vector<JoinedAndReadyNotificationActionFactory> systemJoinedAndReadyNotificationAF = new Vector();
    private final Vector<FailureNotificationActionFactory> systemFailureNotificationAF = new Vector();
    private final Vector<PlannedShutdownActionFactory> systemPlannedShutdownAF = new Vector();
    private final BlockingQueue<SignalPacket> queue;
    private AtomicInteger queueHighWaterMark = new AtomicInteger(0);
    private final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private final Logger monitorLogger = GMSLogDomain.getMonitorLogger();
    private final ExecutorService actionPool;
    private long startupTime;
    private static final int GROUP_WARMUP_TIME = 30000;
    private final int MAX_QUEUE_SIZE;
    private final Thread signalHandlerThread;
    private SignalHandler signalHandler;
    private ConcurrentHashMap<String, AtomicInteger> undeliveredMessages = new ConcurrentHashMap();

    public Router(int queueSize) {
        this.MAX_QUEUE_SIZE = queueSize;
        this.queue = new ArrayBlockingQueue<SignalPacket>(this.MAX_QUEUE_SIZE);
        this.signalHandler = new SignalHandler(this.queue, this);
        this.signalHandlerThread = new Thread((Runnable)this.signalHandler, this.getClass().getCanonicalName() + " Thread");
        this.signalHandlerThread.start();
        this.actionPool = Executors.newCachedThreadPool();
        this.startupTime = System.currentTimeMillis();
    }

    void addDestination(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.failureNotificationAF.add(failureNotificationActionFactory);
    }

    void addSystemDestination(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.systemFailureNotificationAF.add(failureNotificationActionFactory);
    }

    void addSystemDestination(PlannedShutdownActionFactory planneShutdownActionFactory) {
        this.systemPlannedShutdownAF.add(planneShutdownActionFactory);
    }

    void addSystemDestination(JoinedAndReadyNotificationActionFactory JoinedAndReadyNotificationActionFactory2) {
        this.systemJoinedAndReadyNotificationAF.add(JoinedAndReadyNotificationActionFactory2);
    }

    void addDestination(String componentName, FailureRecoveryActionFactory failureRecoveryActionFactory) {
        this.failureRecoveryAF.put(componentName, failureRecoveryActionFactory);
    }

    void addDestination(JoinNotificationActionFactory joinNotificationActionFactory) {
        this.joinNotificationAF.add(joinNotificationActionFactory);
    }

    void addDestination(JoinedAndReadyNotificationActionFactory joinedAndReadyNotificationActionFactory) {
        this.joinedAndReadyNotificationAF.add(joinedAndReadyNotificationActionFactory);
    }

    void addDestination(PlannedShutdownActionFactory plannedShutdownActionFactory) {
        this.plannedShutdownAF.add(plannedShutdownActionFactory);
    }

    void addDestination(FailureSuspectedActionFactory failureSuspectedActionFactory) {
        this.failureSuspectedAF.add(failureSuspectedActionFactory);
    }

    void addDestination(MessageActionFactory messageActionFactory, String componentName) {
        this.messageAF.put(componentName, messageActionFactory);
    }

    void addDestination(GroupLeadershipNotificationActionFactory groupLeadershipNotificationActionFactory) {
        this.groupLeadershipNotificationAFs.add(groupLeadershipNotificationActionFactory);
    }

    void removeDestination(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.failureNotificationAF.remove(failureNotificationActionFactory);
    }

    void removeDestination(JoinNotificationActionFactory joinNotificationActionFactory) {
        this.joinNotificationAF.remove(joinNotificationActionFactory);
    }

    void removeDestination(JoinedAndReadyNotificationActionFactory joinedAndReadyNotificationActionFactory) {
        this.joinedAndReadyNotificationAF.remove(joinedAndReadyNotificationActionFactory);
    }

    void removeDestination(PlannedShutdownActionFactory plannedShutdownActionFactory) {
        this.plannedShutdownAF.remove(plannedShutdownActionFactory);
    }

    void removeDestination(FailureSuspectedActionFactory failureSuspectedActionFactory) {
        this.failureSuspectedAF.remove(failureSuspectedActionFactory);
    }

    public void removeMessageAFDestination(String componentName) {
        this.messageAF.remove(componentName);
    }

    public void removeFailureRecoveryAFDestination(String componentName) {
        this.failureRecoveryAF.remove(componentName);
    }

    void removeDestination(GroupLeadershipNotificationActionFactory groupLeadershipNotificationActionFactory) {
        this.groupLeadershipNotificationAFs.remove(groupLeadershipNotificationActionFactory);
    }

    public void queueSignals(SignalPacket signalPacket) {
        this.queueSignal(signalPacket);
    }

    private void recordQueueHighWaterMark() {
        int localHighWater;
        int currentQueueSize;
        if (this.monitorLogger.isLoggable(Level.FINE) && (currentQueueSize = this.queue.size()) > (localHighWater = this.queueHighWaterMark.get())) {
            this.queueHighWaterMark.compareAndSet(localHighWater, currentQueueSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSignal(SignalPacket signalPacket) {
        try {
            boolean result = this.queue.offer(signalPacket);
            if (!result) {
                int fullcapacity = this.queue.size();
                long starttime = System.currentTimeMillis();
                try {
                    this.queue.put(signalPacket);
                }
                finally {
                    long duration = System.currentTimeMillis() - starttime;
                    if (duration > 0L) {
                        this.monitorLogger.info("signal processing blocked due to signal queue being full for " + duration + " ms. Router signal queue capacity: " + fullcapacity);
                    }
                }
            }
            this.recordQueueHighWaterMark();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void undocketAllDestinations() {
        Cloneable cloneable = this.failureRecoveryAF;
        synchronized (cloneable) {
            this.failureRecoveryAF.clear();
        }
        cloneable = this.failureNotificationAF;
        synchronized (cloneable) {
            this.failureNotificationAF.removeAllElements();
        }
        cloneable = this.plannedShutdownAF;
        synchronized (cloneable) {
            this.plannedShutdownAF.removeAllElements();
        }
        cloneable = this.joinNotificationAF;
        synchronized (cloneable) {
            this.joinNotificationAF.removeAllElements();
        }
        cloneable = this.messageAF;
        synchronized (cloneable) {
            this.messageAF.clear();
        }
        cloneable = this.failureSuspectedAF;
        synchronized (cloneable) {
            this.failureSuspectedAF.removeAllElements();
        }
        cloneable = this.groupLeadershipNotificationAFs;
        synchronized (cloneable) {
            this.groupLeadershipNotificationAFs.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFailureNotificationAction(FailureNotificationSignal signal) {
        FailureNotificationSignalImpl fns;
        FailureNotificationAction a;
        for (FailureNotificationActionFactory sysjraf : this.systemFailureNotificationAF) {
            a = (FailureNotificationAction)sysjraf.produceAction();
            fns = new FailureNotificationSignalImpl(signal);
            try {
                a.consumeSignal(fns);
            }
            catch (ActionException e) {
                this.logger.log(Level.WARNING, "action.exception", new Object[]{e.getLocalizedMessage()});
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "handled unexpected exception processing message signal " + signal.toString());
            }
        }
        this.logger.log(Level.INFO, "failurenotificationsignals.send.member", new Object[]{signal.getMemberToken()});
        Vector<FailureNotificationActionFactory> vector = this.failureNotificationAF;
        synchronized (vector) {
            for (FailureNotificationActionFactory fnaf : this.failureNotificationAF) {
                a = (FailureNotificationAction)fnaf.produceAction();
                fns = new FailureNotificationSignalImpl(signal);
                this.callAction(a, fns);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFailureRecoveryAction(FailureRecoverySignal signal) {
        this.logger.log(Level.INFO, "failurenotificationsignals.send.component", new Object[]{signal.getComponentName()});
        Hashtable<String, FailureRecoveryActionFactory> hashtable = this.failureRecoveryAF;
        synchronized (hashtable) {
            FailureRecoveryActionFactory fraf = this.failureRecoveryAF.get(signal.getComponentName());
            FailureRecoveryAction a = (FailureRecoveryAction)fraf.produceAction();
            FailureRecoverySignalImpl frs = new FailureRecoverySignalImpl(signal);
            this.callAction(a, frs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFailureSuspectedAction(FailureSuspectedSignal signal) {
        this.logger.log(Level.INFO, "failuresuspectedsignals.send.member", new Object[]{signal.getMemberToken()});
        Vector<FailureSuspectedActionFactory> vector = this.failureSuspectedAF;
        synchronized (vector) {
            for (FailureSuspectedActionFactory fsaf : this.failureSuspectedAF) {
                FailureSuspectedAction a = (FailureSuspectedAction)fsaf.produceAction();
                FailureSuspectedSignalImpl fss = new FailureSuspectedSignalImpl(signal);
                this.callAction(a, fss);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMessageAction(MessageSignal signal, String targetComponent) {
        MessageActionFactory maf = null;
        Hashtable<String, MessageActionFactory> hashtable = this.messageAF;
        synchronized (hashtable) {
            maf = this.messageAF.get(targetComponent);
        }
        if (maf != null) {
            MessageAction a = (MessageAction)maf.produceAction();
            try {
                a.consumeSignal(signal);
            }
            catch (ActionException e) {
                this.logger.log(Level.WARNING, "action.exception", new Object[]{e.getLocalizedMessage()});
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "handled unexpected exception processing message signal " + signal.toString());
            }
        }
    }

    void notifyMessageAction(MessageSignal signal) {
        String targetComponent = signal.getTargetComponent();
        if (targetComponent != null) {
            this.notifyMessageAction(signal, targetComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyJoinNotificationAction(JoinNotificationSignal signal) {
        if (this.isJoinNotificationAFRegistered()) {
            this.logger.log(Level.FINE, MessageFormat.format("Sending JoinNotificationSignals to registered Actions, Member {0}...", signal.getMemberToken()));
            Vector<JoinNotificationActionFactory> vector = this.joinNotificationAF;
            synchronized (vector) {
                for (JoinNotificationActionFactory jnaf : this.joinNotificationAF) {
                    JoinNotificationAction a = (JoinNotificationAction)jnaf.produceAction();
                    JoinNotificationSignalImpl jns = new JoinNotificationSignalImpl(signal);
                    this.callAction(a, jns);
                }
            }
        } else if (System.currentTimeMillis() - this.startupTime < 30000L) {
            this.queueSignal(new SignalPacket(signal));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyJoinedAndReadyNotificationAction(JoinedAndReadyNotificationSignal signal) {
        JoinedAndReadyNotificationSignalImpl jns;
        JoinedAndReadyNotificationAction a;
        for (JoinedAndReadyNotificationActionFactory sysjraf : this.systemJoinedAndReadyNotificationAF) {
            a = (JoinedAndReadyNotificationAction)sysjraf.produceAction();
            jns = new JoinedAndReadyNotificationSignalImpl(signal);
            try {
                a.consumeSignal(jns);
            }
            catch (ActionException e) {
                this.logger.log(Level.WARNING, "action.exception", new Object[]{e.getLocalizedMessage()});
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "handled unexpected exception processing message signal " + signal.toString());
            }
        }
        if (this.isJoinedAndReadyNotificationAFRegistered()) {
            this.logger.log(Level.FINE, MessageFormat.format("Sending JoinedAndReadyNotificationSignals to registered Actions, Member {0}...", signal.getMemberToken()));
            Vector<JoinedAndReadyNotificationActionFactory> vector = this.joinedAndReadyNotificationAF;
            synchronized (vector) {
                for (JoinedAndReadyNotificationActionFactory jnaf : this.joinedAndReadyNotificationAF) {
                    a = (JoinedAndReadyNotificationAction)jnaf.produceAction();
                    jns = new JoinedAndReadyNotificationSignalImpl(signal);
                    this.callAction(a, jns);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPlannedShutdownAction(PlannedShutdownSignal signal) {
        PlannedShutdownSignalImpl pss;
        PlannedShutdownAction a;
        this.logger.log(Level.INFO, "plannedshutdownsignals.send.member", new Object[]{signal.getEventSubType(), signal.getMemberToken()});
        for (PlannedShutdownActionFactory sysPsaf : this.systemPlannedShutdownAF) {
            a = (PlannedShutdownAction)sysPsaf.produceAction();
            pss = new PlannedShutdownSignalImpl(signal);
            try {
                a.consumeSignal(pss);
            }
            catch (ActionException e) {
                this.logger.log(Level.WARNING, "action.exception", new Object[]{e.getLocalizedMessage()});
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "handled unexpected exception processing message signal " + signal.toString());
            }
        }
        Vector<PlannedShutdownActionFactory> vector = this.plannedShutdownAF;
        synchronized (vector) {
            for (PlannedShutdownActionFactory psaf : this.plannedShutdownAF) {
                a = (PlannedShutdownAction)psaf.produceAction();
                pss = new PlannedShutdownSignalImpl(signal);
                this.callAction(a, pss);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyGroupLeadershipNotificationAction(GroupLeadershipNotificationSignal signal) {
        if (this.isGroupLeadershipNotificationAFRegistered()) {
            this.logger.log(Level.FINE, MessageFormat.format("Sending GroupLeadershipNotificationSignals to registered Actions, Member {0}...", signal.getMemberToken()));
            Vector<GroupLeadershipNotificationActionFactory> vector = this.groupLeadershipNotificationAFs;
            synchronized (vector) {
                for (GroupLeadershipNotificationActionFactory glsnaf : this.groupLeadershipNotificationAFs) {
                    GroupLeadershipNotificationAction a = (GroupLeadershipNotificationAction)glsnaf.produceAction();
                    GroupLeadershipNotificationSignalImpl glsns = new GroupLeadershipNotificationSignalImpl(signal);
                    this.callAction(a, glsns);
                }
            }
        }
    }

    private void callAction(Action a, Signal signal) {
        try {
            CallableAction task = new CallableAction(a, signal);
            this.actionPool.submit(task);
        }
        catch (RejectedExecutionException e) {
            this.logger.log(Level.WARNING, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailureNotificationAFRegistered() {
        boolean retval = true;
        Vector<FailureNotificationActionFactory> vector = this.failureNotificationAF;
        synchronized (vector) {
            if (this.failureNotificationAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailureRecoveryAFRegistered() {
        boolean retval = true;
        Hashtable<String, FailureRecoveryActionFactory> hashtable = this.failureRecoveryAF;
        synchronized (hashtable) {
            if (this.failureRecoveryAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMessageAFRegistered() {
        boolean retval = true;
        Hashtable<String, MessageActionFactory> hashtable = this.messageAF;
        synchronized (hashtable) {
            if (this.messageAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlannedShutdownAFRegistered() {
        boolean retval = true;
        Vector<PlannedShutdownActionFactory> vector = this.plannedShutdownAF;
        synchronized (vector) {
            if (this.plannedShutdownAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJoinNotificationAFRegistered() {
        boolean retval = true;
        Vector<JoinNotificationActionFactory> vector = this.joinNotificationAF;
        synchronized (vector) {
            if (this.joinNotificationAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJoinedAndReadyNotificationAFRegistered() {
        boolean retval = true;
        Vector<JoinedAndReadyNotificationActionFactory> vector = this.joinedAndReadyNotificationAF;
        synchronized (vector) {
            if (this.joinedAndReadyNotificationAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailureSuspectedAFRegistered() {
        boolean retval = true;
        Vector<FailureSuspectedActionFactory> vector = this.failureSuspectedAF;
        synchronized (vector) {
            if (this.failureSuspectedAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGroupLeadershipNotificationAFRegistered() {
        boolean retval = true;
        Vector<GroupLeadershipNotificationActionFactory> vector = this.groupLeadershipNotificationAFs;
        synchronized (vector) {
            if (this.groupLeadershipNotificationAFs.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    Hashtable<String, FailureRecoveryActionFactory> getFailureRecoveryAFRegistrations() {
        return new Hashtable<String, FailureRecoveryActionFactory>(this.failureRecoveryAF);
    }

    public Set<String> getFailureRecoveryComponents() {
        this.logger.log(Level.FINEST, MessageFormat.format("Router Returning failure recovery components={0}", this.failureRecoveryAF.keySet()));
        return this.failureRecoveryAF.keySet();
    }

    public void shutdown() {
        this.undocketAllDestinations();
        if (this.signalHandlerThread != null) {
            this.signalHandler.stop(this.signalHandlerThread);
        }
        if (this.monitorLogger.isLoggable(Level.FINE)) {
            this.monitorLogger.log(Level.FINE, "router signal queue high water mark:" + this.queueHighWaterMark.get() + " signal queue capacity:" + this.MAX_QUEUE_SIZE);
        }
        if (this.queue != null) {
            int unprocessedEventSize = this.queue.size();
            if (unprocessedEventSize > 0) {
                this.logger.warning("shutdown: cleared queue with " + this.queue.size() + " unprocessed events");
                try {
                    LinkedList unprocessedEvents = new LinkedList();
                    this.queue.drainTo(unprocessedEvents);
                    for (SignalPacket sp : unprocessedEvents) {
                        this.logger.info("shutdown: unprocessed signals:" + sp.toString());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.queue.clear();
        }
        if (this.actionPool != null) {
            this.actionPool.shutdownNow();
        }
    }

    private static class CallableAction
    implements Callable<Object> {
        private Action action;
        private Signal signal;

        CallableAction(Action action, Signal signal) {
            this.action = action;
            this.signal = signal;
        }

        @Override
        public Object call() throws ActionException {
            try {
                this.action.consumeSignal(this.signal);
            }
            catch (ActionException ae) {
                throw ae;
            }
            catch (Throwable t) {
                ActionException nae = new ActionException();
                nae.initCause(t);
                throw nae;
            }
            return null;
        }
    }
}

