/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport;

import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.mgmt.transport.Buffer;
import com.sun.enterprise.mgmt.transport.BufferInputStream;
import com.sun.enterprise.mgmt.transport.BufferUtils;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageIOException;
import com.sun.enterprise.mgmt.transport.NetworkUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageImpl
implements Message {
    static final long serialVersionUID = -3617083350698668655L;
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    public static final int DEFAULT_MAX_TOTAL_MESSAGE_LENGTH = 133120;
    private static int maxTotalMessageLength = 133120;
    public static final int UNSPECIFIED_MESSAGE_LENGTH = -1;
    private static final int MAGIC_NUMBER = 770303;
    private static final int VERSION = 1;
    private static final int MAGIC_NUMBER_LENGTH = 4;
    private static final int VERSION_LENGTH = 4;
    private static final int TYPE_LENGTH = 4;
    private static final int MESSAGE_LENGTH = 4;
    public static final int HEADER_LENGTH = 16;
    private volatile int version;
    private volatile int type;
    private final Map<String, Serializable> messages = new HashMap<String, Serializable>();
    private final ReentrantLock messageLock = new ReentrantLock();
    private transient ByteBuffer byteBuffer;
    private boolean modified;

    public static int getMaxMessageLength() {
        return maxTotalMessageLength;
    }

    public static void setMaxMessageLength(int maxMsgLength) {
        maxTotalMessageLength = maxMsgLength;
    }

    public MessageImpl() {
    }

    public MessageImpl(int type) {
        this.initialize(type, null);
    }

    public MessageImpl(int type, Map<String, Serializable> messages) {
        this.initialize(type, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(int type, Map<String, Serializable> messages) throws IllegalArgumentException {
        this.version = 1;
        this.type = type;
        if (messages != null) {
            this.messageLock.lock();
            try {
                this.messages.clear();
                this.messages.putAll(messages);
            }
            finally {
                this.modified = true;
                this.messageLock.unlock();
            }
        }
    }

    @Override
    public int parseHeader(byte[] bytes, int offset) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must be initialized");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset is too small");
        }
        if (bytes.length < offset + 16) {
            throw new IllegalArgumentException("bytes' length is too small");
        }
        if (bytes.length - offset < 16) {
            throw new IllegalArgumentException("byte[] is too small");
        }
        int magicNumber = MessageImpl.readInt(bytes, offset);
        if (magicNumber != 770303) {
            throw new IllegalArgumentException("magic number is not valid");
        }
        this.version = MessageImpl.readInt(bytes, offset + 4);
        this.type = MessageImpl.readInt(bytes, offset + 8);
        int messageLen = MessageImpl.readInt(bytes, offset + 12);
        return messageLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int parseHeader(Buffer buffer, int offset) throws IllegalArgumentException {
        int messageLen;
        if (buffer == null) {
            throw new IllegalArgumentException("byte buffer must be initialized");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset is too small");
        }
        int restorePosition = buffer.position();
        try {
            buffer.position(offset);
            if (buffer.remaining() < 16) {
                throw new IllegalArgumentException("byte buffer's remaining() is too small");
            }
            int magicNumber = buffer.getInt();
            if (magicNumber != 770303) {
                throw new IllegalArgumentException("magic number is not valid");
            }
            this.version = buffer.getInt();
            this.type = buffer.getInt();
            messageLen = buffer.getInt();
        }
        finally {
            buffer.position(restorePosition);
        }
        return messageLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseMessage(byte[] bytes, int offset, int length) throws IllegalArgumentException, MessageIOException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must be initialized");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset is too small");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is too small");
        }
        if (bytes.length < offset + length) {
            throw new IllegalArgumentException("bytes' length is too small");
        }
        if (length > 0) {
            int msgSize = 16 + length;
            if (msgSize > maxTotalMessageLength && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "total message size is too big: size = " + msgSize + ", max size = " + maxTotalMessageLength);
            }
            if (bytes.length - offset < length) {
                throw new IllegalArgumentException("byte[] is too small");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes, offset, length);
            try {
                this.readMessagesInputStream(bais);
            }
            finally {
                try {
                    bais.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseMessage(Buffer buffer, int offset, int length) throws IllegalArgumentException, MessageIOException {
        if (buffer == null) {
            throw new IllegalArgumentException("byte buffer must be initialized");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset is too small");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is too small");
        }
        if (length > 0) {
            int msgSize = 16 + length;
            if (msgSize > maxTotalMessageLength && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "total message size is too big: size = " + msgSize + ", max size = " + maxTotalMessageLength);
            }
            int restorePosition = buffer.position();
            int restoreLimit = buffer.limit();
            try {
                buffer.position(offset);
                if (buffer.remaining() < length) {
                    throw new IllegalArgumentException("byte buffer's remaining() is too small");
                }
                buffer.limit(offset + length);
                this.readMessagesInputStream(new BufferInputStream(buffer));
            }
            finally {
                BufferUtils.setPositionLimit(buffer, restorePosition, restoreLimit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMessagesInputStream(InputStream is) throws IllegalArgumentException, MessageIOException {
        try {
            int messageCount = MessageImpl.readInt(is);
            this.messageLock.lock();
            try {
                NetworkUtility.deserialize(is, messageCount, this.messages);
            }
            finally {
                this.modified = true;
                this.messageLock.unlock();
            }
        }
        catch (IOException ie) {
            throw new MessageIOException(ie);
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object addMessageElement(String key, Serializable value) {
        this.messageLock.lock();
        try {
            Serializable serializable = this.messages.put(key, value);
            return serializable;
        }
        finally {
            this.modified = true;
            this.messageLock.unlock();
        }
    }

    @Override
    public Object getMessageElement(String key) {
        return this.messages.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeMessageElement(String key) {
        this.messageLock.lock();
        Serializable removed = null;
        try {
            Serializable serializable = removed = this.messages.remove(key);
            return serializable;
        }
        finally {
            if (removed != null) {
                this.modified = true;
            }
            this.messageLock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<String, Serializable>> getMessageElements() {
        return Collections.unmodifiableSet(this.messages.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getPlainByteBuffer() throws MessageIOException {
        this.messageLock.lock();
        try {
            if (this.byteBuffer != null && !this.modified) {
                ByteBuffer byteBuffer = this.byteBuffer;
                return byteBuffer;
            }
            MessageByteArrayOutputStream mbaos = new MessageByteArrayOutputStream();
            DataOutputStream dos = null;
            try {
                dos = new DataOutputStream(mbaos);
                int tempInt = 0;
                dos.writeInt(tempInt);
                int messageCount = NetworkUtility.serialize(mbaos, this.messages);
                mbaos.writeIntWithoutCount(0, messageCount);
            }
            catch (IOException ie) {
                throw new MessageIOException(ie);
            }
            finally {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException e) {}
                }
            }
            byte[] messageBytes = mbaos.getPlainByteArray();
            int messageLen = messageBytes != null ? Math.min(messageBytes.length, mbaos.size()) : 0;
            int msgSize = 16 + messageLen;
            if (msgSize > maxTotalMessageLength) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "total message size is too big: size = " + msgSize + ", max size = " + maxTotalMessageLength);
                }
                throw new MessageIOException("total message size is too big: size = " + msgSize + ", max size = " + maxTotalMessageLength + this.toString());
            }
            this.byteBuffer = ByteBuffer.allocate(16 + messageLen);
            this.byteBuffer.putInt(770303);
            this.byteBuffer.putInt(this.version);
            this.byteBuffer.putInt(this.type);
            this.byteBuffer.putInt(messageLen);
            this.byteBuffer.put(messageBytes, 0, messageLen);
            this.byteBuffer.flip();
            ByteBuffer byteBuffer = this.byteBuffer;
            return byteBuffer;
        }
        finally {
            this.modified = false;
            this.messageLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getPlainBytes() throws MessageIOException {
        this.messageLock.lock();
        try {
            byte[] byArray = this.getPlainByteBuffer().array();
            return byArray;
        }
        finally {
            this.messageLock.unlock();
        }
    }

    public static String getStringType(int type) {
        switch (type) {
            case 1: {
                return "CLUSTER_MANAGER_MESSAGE";
            }
            case 2: {
                return "HEALTH_MONITOR_MESSAGE";
            }
            case 3: {
                return "MASTER_NODE_MESSAGE";
            }
            case 4: {
                return "MCAST_MESSAGE";
            }
            case 5: {
                return "PING_MESSAGE";
            }
            case 6: {
                return "PONG_MESSAGE";
            }
        }
        return "UNKNOWN_MESSAGE(" + type + ")";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50);
        sb.append(MessageImpl.class.getSimpleName());
        sb.append("[v" + this.version + ":");
        sb.append(MessageImpl.getStringType(this.type) + ":");
        for (String elementName : this.messages.keySet()) {
            if ("sourcePeerId".compareTo(elementName) == 0) {
                sb.append(" Source: " + this.messages.get("sourcePeerId") + ", ");
                continue;
            }
            if ("targetPeerId".compareTo(elementName) == 0) {
                sb.append(" Target: " + this.messages.get("targetPeerId") + " , ");
                continue;
            }
            sb.append(elementName + ", ");
        }
        return sb.toString();
    }

    private static int readInt(InputStream is) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read()) | (ch3 = is.read()) | (ch4 = is.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private static int readInt(byte[] bytes, int offset) {
        int ch1 = bytes[offset] & 0xFF;
        int ch2 = bytes[offset + 1] & 0xFF;
        int ch3 = bytes[offset + 2] & 0xFF;
        int ch4 = bytes[offset + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private class MessageByteArrayOutputStream
    extends ByteArrayOutputStream {
        private MessageByteArrayOutputStream() {
        }

        private synchronized byte[] getPlainByteArray() {
            return this.buf;
        }

        private synchronized void writeIntWithoutCount(int pos, int value) {
            NetworkUtility.writeIntToByteArray(this.buf, pos, value);
        }
    }
}

