/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.command.ReplicationFrame;
import org.shoal.ha.cache.impl.command.ReplicationFramePayloadCommand;

public class ReplicationCommandTransmitter<K, V>
implements Runnable {
    private AtomicInteger outgoingSeqno = new AtomicInteger();
    private AtomicInteger acknowledgedSeqno = new AtomicInteger();
    private DataStoreContext<K, V> dsc;
    private String targetName;
    private ConcurrentLinkedQueue<Command<K, V>> list = new ConcurrentLinkedQueue();

    public void initialize(String targetName, DataStoreContext<K, V> rsInfo) {
        this.targetName = targetName;
        this.dsc = rsInfo;
    }

    public void addCommand(Command<K, V> cmd) {
        this.list.add(cmd);
        System.out.println("ReplicationCommandTransmitter[" + this.targetName + "] just " + " accumulated: " + cmd.getOpcode());
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(15L);
                    if (this.list.peek() == null) continue;
                    ReplicationFrame<K, V> frame = new ReplicationFrame<K, V>(-1, this.dsc.getServiceName(), this.dsc.getInstanceName());
                    Command<K, V> cmd = this.list.poll();
                    while (cmd != null) {
                        frame.addCommand(cmd);
                        cmd = this.list.poll();
                        if (frame.getCommands().size() < 20) continue;
                        this.transmitFramePayload(frame);
                        frame = new ReplicationFrame(-1, this.dsc.getServiceName(), this.dsc.getInstanceName());
                    }
                    if (frame.getCommands().size() <= 0) continue;
                    this.transmitFramePayload(frame);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void transmitFramePayload(ReplicationFrame<K, V> frame) throws DataStoreException {
        frame.setSeqNo(this.outgoingSeqno.incrementAndGet());
        frame.setMinOutstandingPacketNumber(this.acknowledgedSeqno.get());
        frame.setTargetInstanceName(this.targetName);
        ReplicationFramePayloadCommand<K, V> cmd = new ReplicationFramePayloadCommand<K, V>();
        cmd.setReplicationFrame(frame);
        this.dsc.getCommandManager().execute(cmd);
    }
}

