/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.shoal.ha.cache.api.HashableKey;
import org.shoal.ha.group.GroupMemberEventListener;
import org.shoal.ha.mapper.KeyMapper;

public class DefaultKeyMapper<K>
implements KeyMapper<K>,
GroupMemberEventListener {
    private String myName;
    private String groupName;
    private ReentrantReadWriteLock.ReadLock rLock;
    private ReentrantReadWriteLock.WriteLock wLock;
    private volatile String[] members = new String[0];
    private volatile String[] previuousAliveAndReadyMembers = new String[0];

    public DefaultKeyMapper(String myName, String groupName) {
        this.myName = myName;
        this.groupName = groupName;
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.rLock = rwLock.readLock();
        this.wLock = rwLock.writeLock();
        this.previuousAliveAndReadyMembers = new String[]{myName};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMappedInstance(String groupName, K key1) {
        int hc = key1.hashCode();
        if (key1 instanceof HashableKey) {
            HashableKey k = (HashableKey)key1;
            hc = k.getHashKey() == null ? hc : k.getHashKey().hashCode();
        }
        hc = Math.abs(hc);
        try {
            this.rLock.lock();
            String string = this.members.length == 0 ? null : this.members[hc % this.members.length];
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findReplicaInstance(String groupName, K key1) {
        int hc = key1.hashCode();
        if (key1 instanceof HashableKey) {
            HashableKey k = (HashableKey)key1;
            hc = k.getHashKey() == null ? hc : k.getHashKey().hashCode();
        }
        hc = Math.abs(hc);
        try {
            this.rLock.lock();
            String string = this.previuousAliveAndReadyMembers.length == 0 ? null : this.previuousAliveAndReadyMembers[hc % this.previuousAliveAndReadyMembers.length];
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onViewChange(String memberName, Collection<String> readOnlyCurrentAliveAndReadyMembers, Collection<String> readOnlyPreviousAliveAndReadyMembers, boolean isJoinEvent) {
        try {
            this.wLock.lock();
            TreeSet<String> currentMemberSet = new TreeSet<String>();
            currentMemberSet.addAll(readOnlyCurrentAliveAndReadyMembers);
            currentMemberSet.remove(this.myName);
            this.members = currentMemberSet.toArray(new String[0]);
            TreeSet<String> previousView = new TreeSet<String>();
            previousView.addAll(readOnlyPreviousAliveAndReadyMembers);
            if (!isJoinEvent) {
                previousView.remove(memberName);
            }
            this.previuousAliveAndReadyMembers = previousView.toArray(new String[0]);
            this.printMemberStates("onViewChange");
        }
        finally {
            this.wLock.unlock();
        }
    }

    private static int getDigestHashCode(String val) {
        int hc = val.hashCode();
        try {
            String hcStr = "_" + val.hashCode() + "_";
            MessageDigest dig = MessageDigest.getInstance("MD5");
            dig.update(hcStr.getBytes());
            dig.update(val.getBytes());
            dig.update(hcStr.getBytes());
            BigInteger bi = new BigInteger(dig.digest());
            hc = bi.intValue();
            return hc;
        }
        catch (NoSuchAlgorithmException nsaEx) {
            hc = val.hashCode();
            return hc;
        }
    }

    public void printMemberStates(String message) {
        System.out.print(message + " DefaultKeyMapper<" + this.myName + "> [");
        for (String st : this.members) {
            System.out.print("<" + st + "> ");
        }
        System.out.println("]");
        System.out.print("\t MembersIncludingMe[");
        for (String st : this.previuousAliveAndReadyMembers) {
            System.out.print("<" + st + "> ");
        }
        System.out.println("]");
    }
}

