/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import java.lang.reflect.Array;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.interceptor.AbstractCommandInterceptor;
import org.shoal.ha.cache.impl.util.MessageReceiver;

public class CommandManager<K, V>
extends MessageReceiver {
    private String myName;
    private DataStoreContext<K, V> dsc;
    private Command<K, V>[] commands = (Command[])Array.newInstance(Command.class, 256);
    private volatile AbstractCommandInterceptor<K, V> head;
    private volatile AbstractCommandInterceptor<K, V> tail;

    public CommandManager(DataStoreContext<K, V> dsc) {
        super(dsc.getServiceName());
        this.dsc = dsc;
        this.myName = dsc.getInstanceName();
    }

    public void registerCommand(Command<K, V> command) {
        this.commands[command.getOpcode()] = command;
        command.initialize(this.dsc);
    }

    public synchronized void registerExecutionInterceptor(AbstractCommandInterceptor<K, V> interceptor) {
        interceptor.initialize(this.dsc);
        if (this.head == null) {
            this.head = interceptor;
        } else {
            this.tail.setNext(interceptor);
        }
        interceptor.setPrev(this.tail);
        interceptor.setNext(null);
        this.tail = interceptor;
    }

    public void execute(Command<K, V> cmd) throws DataStoreException {
        this.execute(cmd, true, this.myName);
    }

    public void execute(Command<K, V> cmd, boolean forward, String initiator) throws DataStoreException {
        cmd.initialize(this.dsc);
        if (this.head != null) {
            if (forward) {
                cmd.prepareToTransmit(this.dsc);
                if (!this.myName.equals(cmd.getTargetName())) {
                    this.head.onTransmit(cmd);
                } else {
                    cmd.execute(this.dsc);
                }
            } else {
                this.tail.onReceive(cmd);
            }
        }
    }

    public Command<K, V> createNewInstance(byte opcode, byte[] data, int offset) throws IOException {
        Command<K, V> cmd2 = this.commands[opcode];
        Command<K, V> cmd = null;
        if (cmd2 != null) {
            cmd = cmd2.createNewInstance();
            cmd.initialize(this.dsc);
            cmd.readCommandState(data, offset);
        }
        return cmd;
    }

    @Override
    protected void handleMessage(String sourceMemberName, String token, byte[] frameData) {
        byte opCode = frameData[0];
        Command<K, V> cmd2 = this.commands[opCode];
        if (cmd2 != null) {
            Command<K, V> cmd = cmd2.createNewInstance();
            cmd.initialize(this.dsc);
            try {
                cmd.readCommandState(frameData, 0);
                this.execute(cmd, false, sourceMemberName);
            }
            catch (IOException dse) {
                // empty catch block
            }
        }
    }
}

