/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.util.concurrent.ConcurrentHashMap;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.DirectedRemoveCommand;

public class ReplicaLocationHolder<K, V>
implements Runnable {
    private DataStoreConfigurator<K, V> conf;
    private DataStoreContext<K, V> dsc;
    private ConcurrentHashMap<K, LocationInfo<K, V>> localCache = new ConcurrentHashMap();
    private boolean cacheV;
    private DataStoreEntryHelper<K, V> dseHelper;

    public ReplicaLocationHolder(DataStoreConfigurator<K, V> conf, DataStoreContext<K, V> dsc) {
        this.conf = conf;
        this.dsc = dsc;
        this.cacheV = conf.isCacheLocally();
        System.out.println("*** ReplicaLocationHolder ==> " + this.cacheV);
        this.dseHelper = conf.getDataStoreEntryHelper();
    }

    public String put(K k, V v, String newLocation) throws DataStoreException {
        LocationInfo<K, V> le = this.localCache.get(k);
        DataStoreEntry<K, V> entry = null;
        if (le == null) {
            le = new LocationInfo(k, null);
            entry = new DataStoreEntry();
            le.setEntry(entry);
            LocationInfo<K, V> oldLE = this.localCache.putIfAbsent(k, le);
            if (oldLE != null) {
                le = oldLE;
            }
        } else {
            entry = le.getEntry();
        }
        if (this.cacheV) {
            this.dseHelper.updateState(k, entry, v);
        } else {
            this.dseHelper.updateMetadata(k, entry, v);
        }
        le.setUseV(this.cacheV);
        String staleLocation = le.setReplicaInstanceName(newLocation);
        if (staleLocation != null) {
            this.removeStaleData(k, staleLocation);
        }
        return le.getReplicaInstanceName();
    }

    public V get(K k) throws DataStoreException {
        V v = null;
        LocationInfo<K, V> entry = this.localCache.get(k);
        if (entry != null && this.cacheV) {
            v = entry.isUseV() ? (V)this.dseHelper.getV(entry.getEntry()) : (V)this.conf.getDataStoreEntryHelper().getV(entry.getEntry());
            System.out.println("**Loaded from local (non replica) cache: " + v);
        }
        return v;
    }

    public void remove(K k) throws DataStoreException {
        this.localCache.remove(k);
        System.out.println("*** ReplicaLocationHolder:remove ==> " + k);
    }

    public String touch(K k, long version, long accessTime, long maxIdle, String newLocation) throws DataStoreException {
        LocationInfo<K, V> le = this.localCache.get(k);
        DataStoreEntry<K, V> entry = null;
        if (le == null) {
            le = new LocationInfo(k, null);
            entry = new DataStoreEntry();
            le.setEntry(entry);
            LocationInfo<K, V> oldLE = this.localCache.putIfAbsent(k, le);
            if (oldLE != null) {
                le = oldLE;
            }
        } else {
            entry = le.getEntry();
        }
        entry.setVersion(version);
        entry.setLastAccessedAt(accessTime);
        entry.setMaxIdleTime(maxIdle);
        String staleLocation = le.setReplicaInstanceName(newLocation);
        le.setUseV(false);
        if (staleLocation != null) {
            this.removeStaleData(k, staleLocation);
        }
        return newLocation;
    }

    public int removeIdleEntries(long idleFor) {
        Thread th = new Thread(this);
        th.start();
        return 0;
    }

    public void close() {
        this.localCache = null;
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        for (LocationInfo<K, V> le : this.localCache.values()) {
            DataStoreEntry<K, V> dse = le.getEntry();
            if (dse.getLastAccessedAt() >= now - dse.getMaxIdleTime()) continue;
            this.localCache.remove(le.getK());
        }
    }

    private void removeStaleData(K k, String staleLocation) throws DataStoreException {
        DirectedRemoveCommand cmd = new DirectedRemoveCommand();
        cmd.setTargetName(staleLocation);
        cmd.setKey(k);
        this.dsc.getCommandManager().execute(cmd);
        System.out.println("*!!=> REMOVING STALE DATA from : " + staleLocation);
    }

    private static final class LocationInfo<K, V> {
        private K k;
        private V v;
        private DataStoreEntry<K, V> entry;
        private boolean useV = true;
        private String replicaInstanceName;

        private LocationInfo(K k, V v) {
            this.k = k;
            this.v = v;
            this.useV = true;
        }

        public K getK() {
            return this.k;
        }

        public V getV() {
            return this.v;
        }

        public void setV(V v) {
            this.v = v;
            this.useV = v != null;
        }

        public DataStoreEntry<K, V> getEntry() {
            return this.entry;
        }

        public void setEntry(DataStoreEntry<K, V> entry) {
            this.entry = entry;
            this.useV = false;
        }

        public boolean isUseV() {
            return this.useV;
        }

        public void setUseV(boolean useV) {
            this.useV = useV;
        }

        public String getReplicaInstanceName() {
            return this.replicaInstanceName;
        }

        public String setReplicaInstanceName(String replicaInstanceName) {
            String staleLocation = this.replicaInstanceName;
            this.replicaInstanceName = replicaInstanceName;
            if (staleLocation != null) {
                staleLocation = staleLocation.equals(replicaInstanceName) ? null : staleLocation;
            }
            return staleLocation;
        }
    }
}

