/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.AliveAndReadyView;
import com.sun.enterprise.ee.cms.core.Signal;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.SortedSet;

public class AliveAndReadyViewImpl
implements AliveAndReadyView {
    private Signal signal;
    private long signalTime;
    private final SortedSet<String> members;
    private final long viewId;
    private final long creationTime;

    public AliveAndReadyViewImpl(SortedSet<String> members, long viewId) {
        this.members = Collections.unmodifiableSortedSet(members);
        this.viewId = viewId;
        this.creationTime = System.currentTimeMillis();
        this.signal = null;
        this.signalTime = -1L;
    }

    public void setSignal(Signal signal) {
        if (signal == null) {
            throw new NullPointerException("setSignal: parameter signal is not allowed to be set to null");
        }
        this.signal = signal;
        this.signalTime = System.currentTimeMillis();
    }

    @Override
    public Signal getSignal() {
        return this.signal;
    }

    @Override
    public SortedSet<String> getMembers() {
        return this.members;
    }

    @Override
    public long getSignalTime() {
        return this.signalTime;
    }

    @Override
    public long getViewId() {
        return this.viewId;
    }

    @Override
    public long getViewCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getViewDuration() {
        long duration = this.signal != null ? this.signalTime - this.creationTime : System.currentTimeMillis() - this.creationTime;
        return duration;
    }

    public String toString() {
        int size;
        StringBuffer sb = new StringBuffer();
        sb.append("AliveAndReadyView  ViewId:").append(this.viewId);
        if (this.signal == null) {
            sb.append(" View created at ").append(MessageFormat.format("{0,date} {0,time,full}", this.creationTime));
        } else {
            sb.append(" Signal:").append(this.signal.getClass().getSimpleName());
            sb.append(" Duration(ms):").append(this.getViewDuration());
            sb.append(" View terminated at ").append(MessageFormat.format("{0,date} {0,time,full}", this.signalTime));
        }
        if (this.members != null && (size = this.members.size()) > 0) {
            sb.append(" Members[").append(this.members.size()).append("]:[");
            for (String member : this.members) {
                sb.append(member).append(",");
            }
            sb.setCharAt(sb.length() - 1, ']');
        }
        return sb.toString();
    }
}

