/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly;

import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.mgmt.ConfigConstants;
import com.sun.enterprise.mgmt.transport.AbstractNetworkManager;
import com.sun.enterprise.mgmt.transport.BlockingIOMulticastSender;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageEvent;
import com.sun.enterprise.mgmt.transport.MessageImpl;
import com.sun.enterprise.mgmt.transport.MessageSender;
import com.sun.enterprise.mgmt.transport.MulticastMessageSender;
import com.sun.enterprise.mgmt.transport.NetworkUtility;
import com.sun.enterprise.mgmt.transport.VirtualMulticastSender;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyCacheableSelectionKeyHandler;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyConfigConstants;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyMessageDispatcherFilter;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyMessageProtocolParser;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyPeerID;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyTCPConnectorWrapper;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyUDPConnectorWrapper;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyUtil;
import com.sun.enterprise.mgmt.transport.grizzly.MulticastSelectorHandler;
import com.sun.enterprise.mgmt.transport.grizzly.PingMessageListener;
import com.sun.enterprise.mgmt.transport.grizzly.PongMessageListener;
import com.sun.grizzly.ConnectorHandlerPool;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.ReusableTCPSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.connectioncache.client.CacheableConnectorHandlerPool;
import com.sun.grizzly.util.GrizzlyExecutorService;
import com.sun.grizzly.util.SelectorFactory;
import com.sun.grizzly.util.ThreadPoolConfig;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GrizzlyNetworkManager
extends AbstractNetworkManager {
    private static final Logger LOG = GrizzlyUtil.getLogger();
    private final Controller controller = new Controller();
    private final ConcurrentHashMap<String, PeerID<GrizzlyPeerID>> peerIDMap = new ConcurrentHashMap();
    private final Map<SelectionKey, String> selectionKeyMap = new ConcurrentHashMap<SelectionKey, String>();
    private volatile boolean running;
    private MessageSender tcpSender;
    private MessageSender udpSender;
    private MulticastMessageSender multicastSender;
    private String host;
    private int tcpPort;
    private int multicastPort;
    private String multicastAddress;
    private String networkInterfaceName;
    private long failTcpTimeout;
    private int maxPoolSize;
    private int corePoolSize;
    private long keepAliveTime;
    private int poolQueueSize;
    private int highWaterMark;
    private int numberToReclaim;
    private int maxParallel;
    private long startTimeout;
    private long writeTimeout;
    private int multicastPacketSize;
    private int writeSelectorPoolSize;
    private String virtualUriList;
    private GrizzlyExecutorService execService;
    private ExecutorService multicastSenderThreadPool = null;
    private TCPSelectorHandler tcpSelectorHandler = null;
    private final ConcurrentHashMap<PeerID, CountDownLatch> pingMessageLockMap = new ConcurrentHashMap();
    public static final String MESSAGE_SELECTION_KEY_TAG = "selectionKey";
    private final CountDownLatch controllerGate = new CountDownLatch(1);
    private boolean controllerGateIsReady = false;
    private Throwable controllerGateStartupException = null;

    private void configure(Map properties) {
        Logger shoalLogger = GrizzlyNetworkManager.getLogger();
        GrizzlyUtil.setLogger(LOG);
        this.host = Utility.getStringProperty(ConfigConstants.BIND_INTERFACE_ADDRESS.toString(), null, properties);
        int tcpStartPort = Utility.getIntProperty(GrizzlyConfigConstants.TCPSTARTPORT.toString(), 9090, properties);
        int tcpEndPort = Utility.getIntProperty(GrizzlyConfigConstants.TCPENDPORT.toString(), 9120, properties);
        this.tcpPort = NetworkUtility.getAvailableTCPPort(this.host, tcpStartPort, tcpEndPort);
        this.multicastPort = Utility.getIntProperty(ConfigConstants.MULTICASTPORT.toString(), 9090, properties);
        this.multicastAddress = Utility.getStringProperty(ConfigConstants.MULTICASTADDRESS.toString(), "230.30.1.1", properties);
        if (this.host != null) {
            try {
                InetAddress inetAddr = InetAddress.getByName(this.host);
                NetworkInterface ni = NetworkInterface.getByInetAddress(inetAddr);
                if (ni != null) {
                    this.networkInterfaceName = ni.getName();
                }
            }
            catch (SocketException ex) {
                shoalLogger.log(Level.WARNING, "GrizzlyNetworkManager.configure: unable to configure NetworkInterfaceName due to ", ex.getLocalizedMessage());
            }
            catch (UnknownHostException ex) {
                shoalLogger.log(Level.WARNING, "GrizzlyNetworkManager.configure: unable to configure NetworkInterfaceName due to ", ex.getLocalizedMessage());
            }
        }
        this.failTcpTimeout = Utility.getLongProperty(ConfigConstants.FAILURE_DETECTION_TCP_RETRANSMIT_TIMEOUT.toString(), 10000L, properties);
        this.maxPoolSize = Utility.getIntProperty(GrizzlyConfigConstants.MAX_POOLSIZE.toString(), 50, properties);
        this.corePoolSize = Utility.getIntProperty(GrizzlyConfigConstants.CORE_POOLSIZE.toString(), 20, properties);
        this.keepAliveTime = Utility.getLongProperty(GrizzlyConfigConstants.KEEP_ALIVE_TIME.toString(), 60000L, properties);
        this.poolQueueSize = Utility.getIntProperty(GrizzlyConfigConstants.POOL_QUEUE_SIZE.toString(), 4096, properties);
        this.highWaterMark = Utility.getIntProperty(GrizzlyConfigConstants.HIGH_WATER_MARK.toString(), 1024, properties);
        this.numberToReclaim = Utility.getIntProperty(GrizzlyConfigConstants.NUMBER_TO_RECLAIM.toString(), 10, properties);
        this.maxParallel = Utility.getIntProperty(GrizzlyConfigConstants.MAX_PARALLEL.toString(), 1, properties);
        this.startTimeout = Utility.getLongProperty(GrizzlyConfigConstants.START_TIMEOUT.toString(), 15000L, properties);
        this.writeTimeout = Utility.getLongProperty(GrizzlyConfigConstants.WRITE_TIMEOUT.toString(), 10000L, properties);
        this.multicastPacketSize = Utility.getIntProperty(ConfigConstants.MULTICAST_PACKET_SIZE.toString(), 65536, properties);
        this.writeSelectorPoolSize = Utility.getIntProperty(GrizzlyConfigConstants.MAX_WRITE_SELECTOR_POOL_SIZE.toString(), 30, properties);
        this.virtualUriList = Utility.getStringProperty(GrizzlyConfigConstants.VIRTUAL_MULTICAST_URI_LIST.toString(), null, properties);
        if (shoalLogger.isLoggable(Level.CONFIG)) {
            StringBuffer buf = new StringBuffer(256);
            buf.append("\nGrizzlyNetworkManager Configuration\n");
            buf.append("BIND_INTERFACE_ADDRESS:").append(this.host).append("  NetworkInterfaceName:").append(this.networkInterfaceName).append('\n');
            buf.append("TCPSTARTPORT..TCPENDPORT:").append(tcpStartPort).append("..").append(tcpEndPort).append(" tcpPort:").append(this.tcpPort).append('\n');
            buf.append("MULTICAST_ADDRESS:MULTICAST_PORT:").append(this.multicastAddress).append(':').append(this.multicastPort).append(" MULTICAST_PACKET_SIZE:").append(this.multicastPacketSize).append('\n');
            buf.append("FAILURE_DETECT_TCP_RETRANSMIT_TIMEOUT(ms):").append(this.failTcpTimeout).append('\n');
            buf.append("ThreadPool CORE_POOLSIZE:").append(this.corePoolSize).append(" MAX_POOLSIZE:").append(this.maxPoolSize).append(" POOL_QUEUE_SIZE:").append(this.poolQueueSize).append(" KEEP_ALIVE_TIME(ms):").append(this.keepAliveTime).append('\n');
            buf.append("HIGH_WATER_MARK:").append(this.highWaterMark).append(" NUMBER_TO_RECLAIM:").append(this.numberToReclaim).append(" MAX_PARALLEL:").append(this.maxParallel).append('\n');
            buf.append("START_TIMEOUT(ms):").append(this.startTimeout).append(" WRITE_TIMEOUT(ms):").append(this.writeTimeout).append('\n');
            buf.append("MAX_WRITE_SELECTOR_POOL_SIZE:").append(this.writeSelectorPoolSize).append('\n');
            buf.append("VIRTUAL_MULTICAST_URI_LIST:").append(this.virtualUriList).append('\n');
            shoalLogger.log(Level.CONFIG, buf.toString());
        }
    }

    @Override
    public synchronized void initialize(String groupName, String instanceName, Map properties) throws IOException {
        super.initialize(groupName, instanceName, properties);
        this.configure(properties);
        if (this.localPeerID == null) {
            String uniqueHost = this.host;
            if (uniqueHost == null) {
                InetAddress firstInetAddress = NetworkUtility.getFirstInetAddress(false);
                if (firstInetAddress == null) {
                    firstInetAddress = NetworkUtility.getFirstInetAddress(true);
                }
                if (firstInetAddress == null) {
                    throw new IOException("can not find a first InetAddress");
                }
                uniqueHost = firstInetAddress.getHostAddress();
            }
            if (uniqueHost == null) {
                throw new IOException("can not find an unique host");
            }
            this.localPeerID = new PeerID<GrizzlyPeerID>(new GrizzlyPeerID(uniqueHost, this.tcpPort, this.multicastPort), groupName, instanceName);
            this.peerIDMap.put(instanceName, this.localPeerID);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "local peer id = " + this.localPeerID);
            }
        }
        InetAddress localInetAddress = null;
        if (this.host != null) {
            localInetAddress = InetAddress.getByName(this.host);
        }
        ThreadPoolConfig threadPoolConfig = new ThreadPoolConfig("GMS-GrizzlyNetMgr-Group-" + groupName, this.corePoolSize, this.maxPoolSize, new ArrayBlockingQueue(this.poolQueueSize), this.poolQueueSize, this.keepAliveTime, TimeUnit.MILLISECONDS, null, 5, null);
        this.execService = GrizzlyExecutorService.createInstance((ThreadPoolConfig)threadPoolConfig);
        this.controller.setThreadPool((ExecutorService)this.execService);
        CacheableConnectorHandlerPool cacheableHandlerPool = new CacheableConnectorHandlerPool(this.controller, this.highWaterMark, this.numberToReclaim, this.maxParallel);
        this.controller.setConnectorHandlerPool((ConnectorHandlerPool)cacheableHandlerPool);
        this.tcpSelectorHandler = new ReusableTCPSelectorHandler();
        this.tcpSelectorHandler.setPort(this.tcpPort);
        this.tcpSelectorHandler.setSelectionKeyHandler((SelectionKeyHandler)new GrizzlyCacheableSelectionKeyHandler(this.highWaterMark, this.numberToReclaim, this));
        this.tcpSelectorHandler.setInet(localInetAddress);
        this.controller.addSelectorHandler((SelectorHandler)this.tcpSelectorHandler);
        MulticastSelectorHandler multicastSelectorHandler = new MulticastSelectorHandler();
        multicastSelectorHandler.setPort(this.multicastPort);
        multicastSelectorHandler.setSelectionKeyHandler((SelectionKeyHandler)new GrizzlyCacheableSelectionKeyHandler(this.highWaterMark, this.numberToReclaim, this));
        if (GrizzlyUtil.isSupportNIOMulticast()) {
            multicastSelectorHandler.setMulticastAddress(this.multicastAddress);
            multicastSelectorHandler.setNetworkInterface(this.networkInterfaceName);
            multicastSelectorHandler.setInet(localInetAddress);
            this.controller.addSelectorHandler((SelectorHandler)multicastSelectorHandler);
        }
        DefaultProtocolChainInstanceHandler pciHandler = new DefaultProtocolChainInstanceHandler(){

            public ProtocolChain poll() {
                ProtocolChain protocolChain = (ProtocolChain)this.protocolChains.poll();
                if (protocolChain == null) {
                    protocolChain = new DefaultProtocolChain();
                    protocolChain.addFilter((ProtocolFilter)GrizzlyMessageProtocolParser.createParserProtocolFilter(null));
                    protocolChain.addFilter((ProtocolFilter)new GrizzlyMessageDispatcherFilter(GrizzlyNetworkManager.this));
                }
                return protocolChain;
            }
        };
        this.controller.setProtocolChainInstanceHandler((ProtocolChainInstanceHandler)pciHandler);
        SelectorFactory.setMaxSelectors((int)this.writeSelectorPoolSize);
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        super.start();
        ControllerStateListener controllerStateListener = new ControllerStateListener(){

            public void onStarted() {
            }

            public void onReady() {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "GrizzlyNetworkManager is ready");
                }
                GrizzlyNetworkManager.this.controllerGateIsReady = true;
                GrizzlyNetworkManager.this.controllerGate.countDown();
            }

            public void onStopped() {
                GrizzlyNetworkManager.this.controllerGate.countDown();
            }

            public void onException(Throwable e) {
                if (GrizzlyNetworkManager.this.controllerGate.getCount() > 0L) {
                    GrizzlyNetworkManager.getLogger().log(Level.SEVERE, "Exception during starting the controller", e);
                    GrizzlyNetworkManager.this.controllerGate.countDown();
                    GrizzlyNetworkManager.this.controllerGateStartupException = e;
                } else {
                    GrizzlyNetworkManager.getLogger().log(Level.SEVERE, "Exception during controller processing", e);
                }
            }
        };
        this.controller.addStateListener(controllerStateListener);
        new Thread((Runnable)this.controller).start();
        long controllerStartTime = System.currentTimeMillis();
        try {
            this.controllerGate.await(this.startTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long durationInMillis = System.currentTimeMillis() - controllerStartTime;
        if (!this.controller.isStarted() || !this.controllerGateIsReady) {
            if (this.controllerGateStartupException != null) {
                throw new IllegalStateException("Grizzly Controller was not started and ready after " + durationInMillis + " ms", this.controllerGateStartupException);
            }
            throw new IllegalStateException("Grizzly Controller was not started and ready after " + durationInMillis + " ms");
        }
        if (this.controllerGateIsReady) {
            GrizzlyNetworkManager.getLogger().config("Grizzly controller started and is ready in " + durationInMillis + " ms");
        }
        this.tcpSender = new GrizzlyTCPConnectorWrapper(this.controller, this.writeTimeout, this.host, this.tcpPort, this.localPeerID);
        GrizzlyUDPConnectorWrapper udpConnectorWrapper = new GrizzlyUDPConnectorWrapper(this.controller, this.writeTimeout, this.host, this.multicastPort, this.multicastAddress, this.localPeerID);
        this.udpSender = udpConnectorWrapper;
        List<PeerID> virtualPeerIdList = this.getVirtualPeerIDList(this.virtualUriList);
        if (virtualPeerIdList != null && !virtualPeerIdList.isEmpty()) {
            this.multicastSenderThreadPool = new ThreadPoolExecutor(10, 10, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024));
            this.multicastSender = new VirtualMulticastSender(this.host, this.multicastAddress, this.multicastPort, this.networkInterfaceName, this.multicastPacketSize, this.localPeerID, this.multicastSenderThreadPool, this, virtualPeerIdList);
        } else if (GrizzlyUtil.isSupportNIOMulticast()) {
            this.multicastSender = udpConnectorWrapper;
        } else {
            this.multicastSenderThreadPool = new ThreadPoolExecutor(10, 10, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024));
            this.multicastSender = new BlockingIOMulticastSender(this.host, this.multicastAddress, this.multicastPort, this.networkInterfaceName, this.multicastPacketSize, this.localPeerID, this.multicastSenderThreadPool, this);
        }
        if (this.tcpSender != null) {
            this.tcpSender.start();
        }
        if (this.udpSender != null) {
            this.udpSender.start();
        }
        if (this.multicastSender != null) {
            this.multicastSender.start();
        }
        this.addMessageListener(new PingMessageListener());
        this.addMessageListener(new PongMessageListener());
        this.running = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<PeerID> getVirtualPeerIDList(String virtualUriList) {
        if (virtualUriList == null) {
            return null;
        }
        LOG.config("VIRTUAL_MULTICAST_URI_LIST = " + virtualUriList);
        ArrayList<PeerID> virtualPeerIdList = new ArrayList<PeerID>();
        if (virtualUriList.indexOf(",") > 0) {
            String[] addresses = virtualUriList.split(",");
            if (addresses.length <= 0) return virtualPeerIdList;
            List<String> virtualUriStringList = Arrays.asList(addresses);
            for (String uriString : virtualUriStringList) {
                try {
                    PeerID<GrizzlyPeerID> peerID = this.getPeerIDFromURI(uriString);
                    if (peerID == null) continue;
                    virtualPeerIdList.add(peerID);
                    LOG.config("VIRTUAL_MULTICAST_URI = " + uriString + ", Converted PeerID = " + peerID);
                }
                catch (URISyntaxException use) {
                    if (!LOG.isLoggable(Level.CONFIG)) continue;
                    LOG.log(Level.CONFIG, "failed to parse the virtual multicast uri(" + uriString + ")", use);
                }
            }
            return virtualPeerIdList;
        } else {
            try {
                PeerID<GrizzlyPeerID> peerID = this.getPeerIDFromURI(virtualUriList);
                if (peerID == null) return virtualPeerIdList;
                virtualPeerIdList.add(peerID);
                LOG.config("VIRTUAL_MULTICAST_URI = " + virtualUriList + ", Converted PeerID = " + peerID);
                return virtualPeerIdList;
            }
            catch (URISyntaxException use) {
                if (!LOG.isLoggable(Level.CONFIG)) return virtualPeerIdList;
                LOG.log(Level.CONFIG, "failed to parse the virtual multicast uri(" + virtualUriList + ")", use);
            }
        }
        return virtualPeerIdList;
    }

    private PeerID<GrizzlyPeerID> getPeerIDFromURI(String uri) throws URISyntaxException {
        if (uri == null) {
            return null;
        }
        URI virtualUri = new URI(uri);
        return new PeerID<GrizzlyPeerID>(new GrizzlyPeerID(virtualUri.getHost(), virtualUri.getPort(), this.multicastPort), this.localPeerID.getGroupName(), "Unknown");
    }

    @Override
    public synchronized void stop() throws IOException {
        if (!this.running) {
            return;
        }
        this.running = false;
        super.stop();
        if (this.tcpSender != null) {
            this.tcpSender.stop();
        }
        if (this.udpSender != null) {
            this.udpSender.stop();
        }
        if (this.multicastSender != null) {
            this.multicastSender.stop();
        }
        if (this.multicastSenderThreadPool != null) {
            this.multicastSenderThreadPool.shutdown();
        }
        this.peerIDMap.clear();
        this.selectionKeyMap.clear();
        this.pingMessageLockMap.clear();
        this.controller.stop();
        this.execService.shutdown();
    }

    @Override
    protected void beforeDispatchingMessage(MessageEvent messageEvent, Map piggyback) {
        Object value;
        if (messageEvent == null) {
            return;
        }
        SelectionKey selectionKey = null;
        if (piggyback != null && (value = piggyback.get(MESSAGE_SELECTION_KEY_TAG)) instanceof SelectionKey) {
            selectionKey = (SelectionKey)value;
        }
        this.addRemotePeer(messageEvent.getSourcePeerID(), selectionKey);
    }

    @Override
    protected void afterDispatchingMessage(MessageEvent messageEvent, Map piggyback) {
    }

    private void addRemotePeer(PeerID peerID, SelectionKey selectionKey) {
        if (peerID == null) {
            return;
        }
        if (peerID.equals(this.localPeerID)) {
            return;
        }
        String instanceName = peerID.getInstanceName();
        if (instanceName != null && peerID.getUniqueID() instanceof GrizzlyPeerID) {
            PeerID<GrizzlyPeerID> previous = this.peerIDMap.putIfAbsent(instanceName, peerID);
            if (previous == null && LOG.isLoggable(Level.FINE)) {
                LOG.fine("addRemotePeer: " + instanceName + " peerId:" + peerID);
            }
            if (selectionKey != null) {
                this.selectionKeyMap.put(selectionKey, instanceName);
            }
        }
    }

    @Override
    public void addRemotePeer(PeerID peerID) {
        Level debugLevel;
        PeerID<GrizzlyPeerID> previous;
        if (peerID == null) {
            return;
        }
        if (peerID.equals(this.localPeerID)) {
            return;
        }
        String instanceName = peerID.getInstanceName();
        if (instanceName != null && peerID.getUniqueID() instanceof GrizzlyPeerID && (previous = this.peerIDMap.putIfAbsent(instanceName, peerID)) == null && LOG.isLoggable(debugLevel = Level.FINEST)) {
            LOG.log(debugLevel, "addRemotePeer: " + instanceName + " peerId:" + peerID, new Exception("stack trace"));
        }
    }

    public void removeRemotePeer(String instanceName) {
        for (Map.Entry<SelectionKey, String> entry : this.selectionKeyMap.entrySet()) {
            if (!entry.getValue().equals(instanceName)) continue;
            GrizzlyNetworkManager.getLogger().log(Level.INFO, "remove selection key for instance name: " + entry.getValue() + " selectionKey:" + entry.getKey());
            this.tcpSelectorHandler.getSelectionKeyHandler().cancel(entry.getKey());
            this.selectionKeyMap.remove(entry.getKey());
        }
    }

    public void removeRemotePeer(SelectionKey selectionKey) {
        if (selectionKey == null) {
            return;
        }
        String instanceName = this.selectionKeyMap.remove(selectionKey);
    }

    @Override
    public boolean send(PeerID peerID, Message message) throws IOException {
        if (!this.running) {
            throw new IOException("network manager is not running");
        }
        MessageSender sender = this.tcpSender;
        if (sender == null) {
            throw new IOException("message sender is not initialized");
        }
        return sender.send(peerID, message);
    }

    @Override
    public boolean broadcast(Message message) throws IOException {
        if (!this.running) {
            throw new IOException("network manager is not running");
        }
        MulticastMessageSender sender = this.multicastSender;
        if (sender == null) {
            throw new IOException("multicast message sender is not initialized");
        }
        return sender.broadcast(message);
    }

    @Override
    public PeerID getPeerID(String instanceName) {
        PeerID<Serializable> peerID = null;
        if (instanceName != null) {
            peerID = this.peerIDMap.get(instanceName);
        }
        if (peerID == null) {
            peerID = PeerID.NULL_PEER_ID;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "getPeerID(" + instanceName + ")" + " returning null peerIDMap=" + this.peerIDMap);
            }
        }
        return peerID;
    }

    @Override
    public void removePeerID(PeerID peerID) {
        if (peerID == null) {
            return;
        }
        String instanceName = peerID.getInstanceName();
        if (instanceName == null) {
            return;
        }
        Level debugLevel = Level.FINEST;
        if (LOG.isLoggable(debugLevel)) {
            LOG.log(debugLevel, "removePeerID peerid=" + peerID, new Exception("stack trace"));
        }
        this.peerIDMap.remove(instanceName);
        this.removeRemotePeer(instanceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected(PeerID peerID) {
        boolean isConnected = false;
        if (peerID != null) {
            try {
                this.send(peerID, new MessageImpl(5));
                CountDownLatch latch = new CountDownLatch(1);
                CountDownLatch oldLatch = this.pingMessageLockMap.putIfAbsent(peerID, latch);
                if (oldLatch != null) {
                    latch = oldLatch;
                }
                try {
                    isConnected = latch.await(this.failTcpTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            catch (Throwable ie) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "isConnected( " + peerID + " ) = " + isConnected, ie);
                }
                boolean bl = isConnected;
                return bl;
            }
            finally {
                this.pingMessageLockMap.remove(peerID);
            }
            return isConnected;
        }
        return isConnected;
    }

    public CountDownLatch getPingMessageLock(PeerID peerID) {
        if (peerID != null) {
            return this.pingMessageLockMap.get(peerID);
        }
        return null;
    }

    @Override
    public MessageSender getMessageSender(int transport) {
        if (this.running) {
            MessageSender sender;
            switch (transport) {
                case 0: {
                    sender = this.tcpSender;
                    break;
                }
                case 1: {
                    sender = this.udpSender;
                    break;
                }
                default: {
                    sender = this.tcpSender;
                }
            }
            return sender;
        }
        return null;
    }

    @Override
    public MulticastMessageSender getMulticastMessageSender() {
        if (this.running) {
            return this.multicastSender;
        }
        return null;
    }
}

