/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import java.io.Serializable;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.Utility;

public class UpdateDeltaCommand<K, V>
extends Command<K, V> {
    private K k;
    private Serializable obj;

    UpdateDeltaCommand() {
        super((byte)34);
    }

    public UpdateDeltaCommand(K k, Serializable obj) {
        super((byte)34);
        this.k = k;
        this.obj = obj;
    }

    @Override
    protected void prepareToTransmit(DataStoreContext<K, V> ctx) {
        this.setTargetName(ctx.getKeyMapper().getMappedInstance(ctx.getGroupName(), this.k));
    }

    @Override
    protected UpdateDeltaCommand<K, V> createNewInstance() {
        return new UpdateDeltaCommand<K, V>();
    }

    @Override
    public void writeCommandPayload(DataStoreContext<K, V> ctx, ReplicationOutputStream ros) throws IOException {
        int keyLenMark = ros.mark();
        ros.write(Utility.intToBytes(0));
        ctx.getDataStoreKeyHelper().writeKey(ros, this.k);
        int valueOffset = ros.mark() - keyLenMark;
        ros.reWrite(keyLenMark, Utility.intToBytes(valueOffset));
        ctx.getDataStoreEntryHelper().writeObject(ros, this.obj);
    }

    @Override
    public void readCommandPayload(DataStoreContext<K, V> ctx, byte[] data, int offset) throws DataStoreException {
        int valueOffset = Utility.bytesToInt(data, offset);
        this.k = ctx.getDataStoreKeyHelper().readKey(data, offset + 4);
        this.obj = (Serializable)ctx.getDataStoreEntryHelper().readObject(data, offset + valueOffset);
    }

    @Override
    public void execute(DataStoreContext<K, V> ctx) {
    }
}

