/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.util.concurrent.ConcurrentHashMap;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreException;

public class ReplicaStore<K, V> {
    private DataStoreContext<K, V> ctx;
    private ConcurrentHashMap<K, DataStoreEntry<K, V>> map = new ConcurrentHashMap();

    public ReplicaStore(DataStoreContext<K, V> ctx) {
        this.ctx = ctx;
    }

    public void put(K k, Object obj) throws DataStoreException {
        DataStoreEntry<K, V> oldDSE;
        DataStoreEntry<K, V> dse = this.map.get(k);
        if (dse == null && (oldDSE = this.map.putIfAbsent(k, dse = new DataStoreEntry())) != null) {
            dse = oldDSE;
        }
        DataStoreEntryHelper<K, V> helper = this.ctx.getDataStoreEntryHelper();
        helper.updateState(k, dse, obj);
        System.out.println("** ReplicaStore::put(" + k + ", " + obj);
    }

    public DataStoreEntry<K, V> get(K k) throws DataStoreException {
        DataStoreEntryHelper<K, V> helper = this.ctx.getDataStoreEntryHelper();
        DataStoreEntry<K, V> dse = this.map.get(k);
        return dse;
    }

    public void remove(K k) {
        this.map.remove(k);
        System.out.println("** ReplicaStore::remove(" + k);
    }

    public void touch(K k, long version, long ts, long ttl) {
        DataStoreEntry<K, V> e = this.map.get(k);
        if (e != null) {
            e.setLastAccessedAt(ts);
            e.setMaxIdleTime(ttl);
            e.setVersion(version);
        }
    }

    public int size() {
        return this.map.size();
    }
}

