/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationIOUtils;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;
import org.shoal.ha.cache.impl.util.Utility;

public class LoadResponseCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.touch");
    private K key;
    private DataStoreEntry<K, V> entry;
    private long tokenId;
    private String originatingInstance;

    private LoadResponseCommand() {
        super((byte)37);
    }

    public LoadResponseCommand(K key, DataStoreEntry<K, V> e, long tokenId) {
        super((byte)37);
        this.key = key;
        this.entry = e;
        this.tokenId = tokenId;
    }

    public void setOriginatingInstance(String originatingInstance) {
        this.originatingInstance = originatingInstance;
    }

    @Override
    protected LoadResponseCommand<K, V> createNewInstance() {
        return new LoadResponseCommand<K, V>();
    }

    @Override
    public void writeCommandPayload(DataStoreContext<K, V> trans, ReplicationOutputStream ros) throws IOException {
        int vMark;
        int vOffset = vMark = ros.mark();
        ros.write(Utility.intToBytes(vOffset));
        ros.write(Utility.longToBytes(this.tokenId));
        ReplicationIOUtils.writeLengthPrefixedString(ros, this.originatingInstance);
        trans.getDataStoreKeyHelper().writeKey(ros, this.key);
        vOffset = ros.mark() - vOffset;
        ros.reWrite(vMark, Utility.intToBytes(vOffset));
        ros.write(Utility.intToBytes(this.entry == null ? 0 : 1));
        if (this.entry != null) {
            this.entry.writeDataStoreEntry(trans, ros);
        }
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, trans.getInstanceName() + " sending load_response " + this.key + " to " + this.getTargetName());
        }
    }

    @Override
    public void readCommandPayload(DataStoreContext<K, V> trans, byte[] data, int offset) throws IOException, DataStoreException {
        int vOffset = Utility.bytesToInt(data, offset);
        this.tokenId = Utility.bytesToLong(data, offset + 4);
        this.originatingInstance = ReplicationIOUtils.readLengthPrefixedString(data, offset + 12);
        int instOffset = 4 + (this.originatingInstance == null ? 0 : this.originatingInstance.length());
        this.key = trans.getDataStoreKeyHelper().readKey(data, offset + 12 + instOffset);
        int flag = Utility.bytesToInt(data, offset + vOffset);
        if (flag != 0) {
            this.entry = new DataStoreEntry();
            this.entry.readDataStoreEntry(trans, data, offset + vOffset + 4);
        }
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, trans.getInstanceName() + " received load_response " + this.key + " from " + this.originatingInstance);
        }
    }

    @Override
    protected void prepareToTransmit(DataStoreContext<K, V> ctx) {
        this.setTargetName(this.originatingInstance);
    }

    @Override
    public void execute(DataStoreContext<K, V> ctx) {
        ResponseMediator respMed = this.getDataStoreContext().getResponseMediator();
        CommandResponse resp = respMed.getCommandResponse(this.tokenId);
        if (resp != null) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, ctx.getInstanceName() + " executed load_response " + this.key + " value " + this.entry);
            }
            resp.setResult(this.entry);
        }
    }
}

