/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class RemoveCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.touch");
    private K key;

    public RemoveCommand() {
        super((byte)36);
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    @Override
    protected RemoveCommand<K, V> createNewInstance() {
        return new RemoveCommand<K, V>();
    }

    @Override
    protected void prepareToTransmit(DataStoreContext<K, V> ctx) {
        this.setTargetName(ctx.getKeyMapper().getMappedInstance(ctx.getGroupName(), this.key));
    }

    @Override
    public void writeCommandPayload(DataStoreContext<K, V> trans, ReplicationOutputStream ros) throws IOException {
        trans.getDataStoreKeyHelper().writeKey(ros, this.key);
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, trans.getInstanceName() + " sending remove " + this.key + " to " + this.getTargetName());
        }
    }

    @Override
    public void readCommandPayload(DataStoreContext<K, V> trans, byte[] data, int offset) throws DataStoreException {
        this.key = trans.getDataStoreKeyHelper().readKey(data, offset);
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, trans.getInstanceName() + " received remove " + this.key + " from " + this.getTargetName());
        }
    }

    @Override
    public void execute(DataStoreContext<K, V> ctx) {
        ctx.getReplicaStore().remove(this.key);
    }
}

