/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.ObjectInputOutputStreamFactory;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.Utility;

public class DefaultDataStoreEntryHelper<K, V>
implements DataStoreEntryHelper<K, V> {
    private ObjectInputOutputStreamFactory factory;
    private ClassLoader loader;
    private long defaultMaxIdleTime;

    public DefaultDataStoreEntryHelper(ObjectInputOutputStreamFactory factory, ClassLoader loader, long defaultMaxIdleTime) {
        this.factory = factory;
        this.loader = loader;
        this.defaultMaxIdleTime = defaultMaxIdleTime;
    }

    @Override
    public V getV(DataStoreEntry<K, V> replicationEntry) throws DataStoreException {
        if (replicationEntry == null) {
            return null;
        }
        byte[] data = (byte[])replicationEntry.getState();
        if (data == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream ois = null;
        Object v = null;
        try {
            ois = this.factory.createObjectInputStream(bis, this.loader);
            v = ois.readObject();
        }
        catch (IOException ioEx) {
            throw new DataStoreException(ioEx);
        }
        catch (ClassNotFoundException cnfEx) {
            throw new DataStoreException(cnfEx);
        }
        finally {
            try {
                ois.close();
            }
            catch (IOException ioEx1) {}
            try {
                bis.close();
            }
            catch (IOException ioEx2) {}
        }
        return (V)v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(ReplicationOutputStream ros, Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = this.factory.createObjectOutputStream(bos);
        try {
            oos.writeObject(obj);
            oos.flush();
            byte[] data = bos.toByteArray();
            ros.write(Utility.intToBytes(data.length));
            ros.write(data);
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException ioEx) {}
            try {
                bos.close();
            }
            catch (IOException ioEx) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readObject(byte[] data, int index) throws DataStoreException {
        Object object;
        int len = Utility.bytesToInt(data, index);
        ByteArrayInputStream bis = new ByteArrayInputStream(data, index + 4, len);
        ObjectInputStream ois = this.factory.createObjectInputStream(bis, this.loader);
        try {
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
                try {
                    bis.close();
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (ClassNotFoundException cnfEx) {
                throw new DataStoreException("Cannot desrialize value", cnfEx);
            }
            catch (IOException ioEx) {
                throw new DataStoreException("Cannot desrialize value", ioEx);
            }
        }
        try {
            ois.close();
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        try {
            bis.close();
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        return object;
    }

    @Override
    public void updateState(K k, DataStoreEntry<K, V> kvDataStoreEntry, Object obj) throws DataStoreException {
        kvDataStoreEntry.setKey(k);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
        }
        catch (IOException ioEx) {
            throw new DataStoreException("Error during updateState", ioEx);
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException ioEx) {}
            try {
                bos.close();
            }
            catch (IOException ioEx) {}
        }
        byte[] data = bos.toByteArray();
        kvDataStoreEntry.setState(data);
        kvDataStoreEntry.setLastAccessedAt(System.currentTimeMillis());
        kvDataStoreEntry.setMaxIdleTime(this.defaultMaxIdleTime);
    }

    @Override
    public void updateMetadata(K k, DataStoreEntry<K, V> kvDataStoreEntry, Object obj) {
        kvDataStoreEntry.setVersion(0x7FFFFFFFFFFFFFFEL);
        kvDataStoreEntry.setLastAccessedAt(System.currentTimeMillis());
        kvDataStoreEntry.setMaxIdleTime(this.defaultMaxIdleTime);
    }
}

