/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreKeyHelper;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.Utility;

public class ReplicationIOUtils {
    public static final void writeLengthPrefixedString(ByteArrayOutputStream bos, String str) {
        try {
            bos.write(Utility.intToBytes(str.length()));
            if (str != null && str.length() > 0) {
                bos.write(str.getBytes());
            }
        }
        catch (IOException ex) {
            try {
                bos.write(Utility.intToBytes(0));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final String readLengthPrefixedString(byte[] data, int offset) {
        int len = Utility.bytesToInt(data, offset);
        return new String(data, offset + 4, len);
    }

    public static final void write(ByteArrayOutputStream bos, int data) {
        try {
            bos.write(Utility.intToBytes(data));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final <K> int writeLengthPrefixedKey(K key, DataStoreKeyHelper<K> helper, ReplicationOutputStream ros) throws IOException {
        int mark = ros.mark();
        int keyDataLength = 0;
        ros.write(Utility.intToBytes(0));
        keyDataLength = ros.mark();
        helper.writeKey(ros, key);
        keyDataLength = ros.mark() - keyDataLength;
        ros.reWrite(mark, Utility.intToBytes(keyDataLength));
        return keyDataLength;
    }

    public static final <K, V> void writeLengthPrefixedHashKey(K hashKey, DataStoreEntryHelper<K, V> helper, ReplicationOutputStream ros) throws IOException {
        int mark = ros.mark();
        int keyDataLength = 0;
        ros.write(Utility.intToBytes(0));
        keyDataLength = ros.mark();
        helper.writeObject(ros, hashKey);
        keyDataLength = ros.mark() - keyDataLength;
        ros.reWrite(mark, Utility.intToBytes(keyDataLength));
    }

    public static final <K> KeyInfo<K> readTransformedKey(DataStoreEntryHelper<K, ?> trans, byte[] data, int offset) throws IOException {
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.keyLen = Utility.bytesToInt(data, offset);
        if (keyInfo.keyLen > 0) {
            keyInfo.key = trans.readObject(data, offset + 4);
        }
        return keyInfo;
    }

    public static final <K> KeyInfo<K> readLengthPrefixedKey(DataStoreKeyHelper<K> trans, byte[] data, int offset) throws IOException {
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.keyLen = Utility.bytesToInt(data, offset);
        if (keyInfo.keyLen > 0) {
            keyInfo.key = trans.readKey(data, offset + 4);
        }
        return keyInfo;
    }

    public static class KeyInfo<K> {
        public K key;
        public int keyLen;
    }
}

