/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.impl.util.ReplicationIOUtils;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.Utility;

public final class ReplicationState<K, V>
extends DataStoreEntry<K, V> {
    private Map<String, byte[]> attributes = new HashMap<String, byte[]>();
    private Set<String> deletedAttributes = new HashSet<String>();

    public void setAttribute(String name, byte[] data) {
        this.attributes.put(name, data);
    }

    public byte[] getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void removeAttribute(String ... names) {
        for (String name : names) {
            this.attributes.remove(name);
            this.deletedAttributes.add(name);
        }
    }

    public void update(ReplicationState<K, V> rs2) {
        this.setMaxIdleTime(rs2.getMaxIdleTime());
        this.setLastAccessedAt(rs2.getLastAccessedAt());
        for (String d : rs2.deletedAttributes) {
            this.removeAttribute(d);
        }
        for (String k : rs2.attributes.keySet()) {
            byte[] attr = rs2.attributes.get(k);
            this.attributes.put(k, attr);
        }
    }

    @Override
    protected void writePayloadState(DataStoreEntryHelper<K, V> transformer, ReplicationOutputStream ros) throws IOException {
        ros.write(Utility.intToBytes(this.deletedAttributes.size()));
        for (String key : this.deletedAttributes) {
            ReplicationIOUtils.writeLengthPrefixedString(ros, key);
        }
        int attrLen = this.attributes.size();
        ros.write(Utility.intToBytes(attrLen));
        for (String k : this.attributes.keySet()) {
            ReplicationIOUtils.writeLengthPrefixedString(ros, k);
            byte[] v = this.attributes.get(k);
            ros.write(Utility.intToBytes(v.length));
            ros.write(v);
        }
    }

    @Override
    protected void readPayloadState(DataStoreEntryHelper<K, V> trans, byte[] data, int index) {
        int delAttrSz = Utility.bytesToInt(data, index);
        index += 4;
        for (int i = 0; i < delAttrSz; ++i) {
            int dKeySz = Utility.bytesToInt(data, index);
            this.deletedAttributes.add(new String(data, index += 4, dKeySz));
            index += dKeySz;
        }
        int attrSz = Utility.bytesToInt(data, index);
        index += 4;
        for (int i = 0; i < attrSz; ++i) {
            String k = ReplicationIOUtils.readLengthPrefixedString(data, index);
            int len = Utility.bytesToInt(data, index += 4 + k.length());
            byte[] v = new byte[len];
            System.arraycopy(data, index + 4, v, 0, len);
            this.attributes.put(k, v);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ReplicationState: [");
        sb.append(super.toString()).append("; attrCount: ").append(this.attributes.size());
        for (String a : this.attributes.keySet()) {
            sb.append("\n\t attrName: ").append(a).append("; ").append(this.attributes.get(a).length).append("; ");
        }
        return sb.toString();
    }
}

