/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.base;

import com.sun.enterprise.ee.cms.core.AliveAndReadyView;
import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.GMSCacheable;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSMember;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.impl.base.DistributedStateCacheImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.ViewWindow;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.GMSMessage;
import com.sun.enterprise.ee.cms.spi.GroupCommunicationProvider;
import com.sun.enterprise.ee.cms.spi.MemberStates;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GroupHandleImpl
implements GroupHandle {
    private String groupName;
    private String serverToken;
    private GMSContext ctx;
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private static final String REC_PROGRESS_STATE = GroupManagementService.RECOVERY_STATE.RECOVERY_IN_PROGRESS.toString();
    private static final String REC_APPOINTED_STATE = GroupManagementService.RECOVERY_STATE.RECOVERY_SERVER_APPOINTED.toString();
    private static final int SYNC_WAIT = 2000;
    private static final List<String> EMPTY_LIST = new LinkedList<String>();
    private List<String> selfRecoveryList;

    public GroupHandleImpl(String groupName, String serverToken) {
        this.groupName = groupName;
        this.serverToken = serverToken;
        this.selfRecoveryList = new ArrayList<String>();
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = GMSContextFactory.getGMSContext(this.groupName);
        }
        return this.ctx;
    }

    @Override
    public void sendMessage(String componentName, byte[] message) throws GMSException {
        try {
            GMSMessage gMsg = new GMSMessage(componentName, message, this.groupName, this.getGMSContext().getStartTime());
            this.getGMSContext().getGroupCommunicationProvider().sendMessage(null, gMsg, true);
        }
        catch (Throwable t) {
            if (t instanceof GMSException) {
                throw (GMSException)t;
            }
            throw new GMSException("failed to brodcast message to group " + this.groupName + " to target component:" + componentName, t);
        }
    }

    @Override
    public void sendMessage(String targetServerToken, String targetComponentName, byte[] message) throws GMSException {
        try {
            GMSMessage gMsg = new GMSMessage(targetComponentName, message, this.groupName, this.getGMSContext().getStartTime());
            this.getGMSContext().getGroupCommunicationProvider().sendMessage(targetServerToken, gMsg, false);
        }
        catch (Throwable t) {
            if (t instanceof GMSException) {
                throw (GMSException)t;
            }
            throw new GMSException("failed to send message to target server:" + targetServerToken + " target component:" + targetComponentName, t);
        }
    }

    @Override
    public void sendMessage(List<String> targetServerTokens, String targetComponentName, byte[] message) throws GMSException {
        Throwable lastThrowable = null;
        String failedSendToken = null;
        GMSMessage gMsg = new GMSMessage(targetComponentName, message, this.groupName, this.getGMSContext().getStartTime());
        if (targetServerTokens.isEmpty()) {
            this.getGMSContext().getGroupCommunicationProvider().sendMessage(null, gMsg, true);
        } else {
            for (String token : targetServerTokens) {
                try {
                    this.getGMSContext().getGroupCommunicationProvider().sendMessage(token, gMsg, false);
                }
                catch (Throwable t) {
                    lastThrowable = t;
                    failedSendToken = token;
                    logger.warning("GroupHandleImpl.sendMesage: could not send message " + message + " for component " + targetComponentName + " to member " + token + " exception:" + t.getMessage());
                }
            }
        }
        if (lastThrowable != null) {
            if (lastThrowable instanceof GMSException) {
                throw (GMSException)lastThrowable;
            }
            throw new GMSException("failed to send message to target server:" + failedSendToken + " target component=" + targetComponentName, lastThrowable);
        }
    }

    @Override
    public DistributedStateCache getDistributedStateCache() {
        if (this.isWatchdog()) {
            return null;
        }
        return this.getGMSContext().getDistributedStateCache();
    }

    @Override
    public List<String> getCurrentCoreMembers() {
        ViewWindow viewWindow = this.getGMSContext().getViewWindow();
        if (viewWindow == null) {
            return EMPTY_LIST;
        }
        return viewWindow.getCurrentCoreMembers();
    }

    @Override
    public List<String> getAllCurrentMembers() {
        ViewWindow viewWindow = this.getGMSContext().getViewWindow();
        if (viewWindow == null) {
            return EMPTY_LIST;
        }
        return viewWindow.getAllCurrentMembers();
    }

    @Override
    public List<String> getCurrentCoreMembersWithStartTimes() {
        ViewWindow viewWindow = this.getGMSContext().getViewWindow();
        if (viewWindow == null) {
            return EMPTY_LIST;
        }
        return viewWindow.getCurrentCoreMembersWithStartTimes();
    }

    @Override
    public List<String> getAllCurrentMembersWithStartTimes() {
        ViewWindow viewWindow = this.getGMSContext().getViewWindow();
        if (viewWindow == null) {
            return EMPTY_LIST;
        }
        return viewWindow.getAllCurrentMembersWithStartTimes();
    }

    @Override
    public void raiseFence(String componentName, String failedMemberToken) throws GMSException {
        if (this.isWatchdog()) {
            return;
        }
        if (!this.isFenced(componentName, failedMemberToken)) {
            DistributedStateCache dsc = this.getGMSContext().getDistributedStateCache();
            dsc.addToCache(componentName, this.getGMSContext().getServerIdentityToken(), (Serializable)((Object)failedMemberToken), (Serializable)((Object)GroupHandleImpl.setStateAndTime()));
            if (this.fenceForSelfRecovery(failedMemberToken)) {
                this.saveRaisedFenceState(componentName, failedMemberToken);
            }
        } else {
            throw new GMSException("Could not raise fence. Fence for member " + failedMemberToken + " and Component " + componentName + " already exists");
        }
        logger.log(Level.FINE, "Fence raised for member " + failedMemberToken + " by member " + this.getGMSContext().getServerIdentityToken() + " component " + componentName);
    }

    private void saveRaisedFenceState(String componentName, String failedMemberToken) {
        this.selfRecoveryList.add(componentName + failedMemberToken);
    }

    private boolean fenceForSelfRecovery(String failedMemberToken) {
        return failedMemberToken.equals(this.getGMSContext().getServerIdentityToken());
    }

    @Override
    public void lowerFence(String componentName, String failedMemberToken) throws GMSException {
        if (this.isWatchdog()) {
            return;
        }
        if (componentName == null || failedMemberToken == null) {
            throw new IllegalArgumentException("parameters to GroupHandle.lowerFence must be non-null");
        }
        if (this.isFenced(componentName, failedMemberToken) || this.selfRecoveryList.contains(componentName + failedMemberToken)) {
            DistributedStateCache dsc = this.getGMSContext().getDistributedStateCache();
            dsc.removeFromCache(componentName, this.getGMSContext().getServerIdentityToken(), (Serializable)((Object)failedMemberToken));
            logger.log(Level.FINE, "Fence lowered for member " + failedMemberToken + " by member " + this.getGMSContext().getServerIdentityToken() + " component " + componentName);
            this.removeRecoveryAppointments(dsc.getFromCache(failedMemberToken), failedMemberToken);
            this.selfRecoveryList.remove(componentName + failedMemberToken);
        }
    }

    private void removeRecoveryAppointments(Map<GMSCacheable, Object> fromCache, String failedMemberToken) throws GMSException {
        if (this.isWatchdog()) {
            return;
        }
        DistributedStateCache dsc = this.getGMSContext().getDistributedStateCache();
        for (GMSCacheable cKey : fromCache.keySet()) {
            if (!cKey.getKey().equals(failedMemberToken) || !fromCache.get(cKey).toString().startsWith(REC_APPOINTED_STATE)) continue;
            dsc.removeFromCache(cKey.getComponentName(), cKey.getMemberTokenId(), (Serializable)cKey.getKey());
        }
    }

    @Override
    public boolean isFenced(String componentName, String memberToken) {
        if (this.isWatchdog()) {
            return false;
        }
        boolean retval = false;
        DistributedStateCache dsc = this.getDistributedStateCache();
        List<String> members = this.getAllCurrentMembers();
        int count = 0;
        while (members.size() > 1 && !dsc.isFirstSyncDone()) {
            logger.log(Level.FINE, "Waiting for DSC first Sync");
            try {
                Thread.sleep(2000L);
                if (++count <= 4) continue;
                this.forceDSCSync((DistributedStateCacheImpl)dsc);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
        Map<GMSCacheable, Object> entries = dsc.getFromCache(memberToken);
        for (GMSCacheable c : entries.keySet()) {
            if (!componentName.equals(c.getComponentName()) || !memberToken.equals(c.getKey()) || memberToken.equals(c.getMemberTokenId()) || !((String)entries.get(c)).startsWith(REC_PROGRESS_STATE)) continue;
            logger.log(Level.FINER, c.toString() + " value:" + entries.get(c));
            logger.log(Level.FINER, "Returning true for isFenced query");
            retval = true;
            break;
        }
        return retval;
    }

    private void forceDSCSync(DistributedStateCacheImpl dsc) {
        if (this.isWatchdog()) {
            return;
        }
        try {
            String token = this.getGMSContext().getGroupCommunicationProvider().getGroupLeader();
            logger.log(Level.FINE, "Force Syncing DistributedStateCache with " + token);
            dsc.syncCache(token, true);
        }
        catch (GMSException e) {
            logger.log(Level.WARNING, "Force Syncing of DistributedStateCache failed:" + e.getLocalizedMessage());
        }
    }

    @Override
    public boolean isMemberAlive(String memberToken) {
        if (memberToken == null) {
            throw new IllegalArgumentException("isMemberAlive parameter memberToken must be non-null");
        }
        return memberToken.equals(this.serverToken) || this.getAllCurrentMembers().contains(memberToken);
    }

    @Override
    public String getGroupLeader() {
        return this.getGMSContext().getGroupCommunicationProvider().getGroupLeader();
    }

    @Override
    public boolean isGroupLeader() {
        return this.getGMSContext().getGroupCommunicationProvider().isGroupLeader();
    }

    public List<String> getSuspectList() {
        return this.getGMSContext().getSuspectList();
    }

    public String toString() {
        return "group:" + this.groupName + " server:" + this.serverToken;
    }

    private static String setStateAndTime() {
        return GroupManagementService.RECOVERY_STATE.RECOVERY_IN_PROGRESS.toString() + "|" + System.currentTimeMillis();
    }

    @Override
    public List<String> getCurrentAliveOrReadyMembers() {
        List<String> members = this.getCurrentCoreMembers();
        ArrayList<String> currentAliveOrReadyMembers = new ArrayList<String>();
        GroupCommunicationProvider gcp = this.getGMSContext().getGroupCommunicationProvider();
        for (String member : members) {
            MemberStates state = gcp.getMemberState(member);
            if (state != MemberStates.ALIVE && state != MemberStates.READY && state != MemberStates.ALIVEANDREADY) continue;
            currentAliveOrReadyMembers.add(member);
        }
        return currentAliveOrReadyMembers;
    }

    @Override
    public MemberStates getMemberState(String member) {
        GroupCommunicationProvider gcp = this.getGMSContext().getGroupCommunicationProvider();
        return gcp.getMemberState(member);
    }

    @Override
    public MemberStates getMemberState(String member, long threshold, long timeout) {
        GroupCommunicationProvider gcp = this.getGMSContext().getGroupCommunicationProvider();
        return gcp.getMemberState(member, threshold, timeout);
    }

    public boolean isWatchdog() {
        return this.getGMSContext().getMemberType() == GroupManagementService.MemberType.WATCHDOG;
    }

    @Override
    public void announceWatchdogObservedFailure(String serverToken) throws GMSException {
        this.getGMSContext().getGroupCommunicationProvider().announceWatchdogObservedFailure(serverToken);
    }

    @Override
    public List<GMSMember> getCurrentView() {
        return this.getGMSContext().getViewWindow().getCurrentView();
    }

    @Override
    public List<GMSMember> getPreviousView() {
        return this.getGMSContext().getViewWindow().getPreviousView();
    }

    @Override
    public AliveAndReadyView getPreviousAliveAndReadyCoreView() {
        return this.getGMSContext().getPreviousAliveAndReadyView();
    }

    @Override
    public AliveAndReadyView getCurrentAliveAndReadyCoreView() {
        return this.getGMSContext().getCurrentAliveAndReadyView();
    }
}

