/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.gms.tools;

import com.sun.enterprise.gms.tools.MultiCastReceiverThread;
import com.sun.enterprise.gms.tools.MulticastSenderThread;
import com.sun.enterprise.gms.tools.StringManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;

public class MulticastTester {
    static final StringManager sm = StringManager.getInstance();
    static final String DASH = "--";
    static final String HELP_OPTION = "--" + sm.get("help.option", new Object[0]);
    static final String PORT_OPTION = "--" + sm.get("port.option", new Object[0]);
    static final String ADDRESS_OPTION = "--" + sm.get("address.option", new Object[0]);
    static final String BIND_OPTION = "--" + sm.get("bind.int.option", new Object[0]);
    static final String WAIT_PERIOD_OPTION = "--" + sm.get("period.option", new Object[0]);
    static final String TIMEOUT_OPTION = "--" + sm.get("timeout.option", new Object[0]);
    static final String DEBUG_OPTION = "--" + sm.get("debug.option", new Object[0]);
    int mcPort = 2048;
    String mcAddress = "228.9.3.1";
    String bindInterface = null;
    long msgPeriodInMillis = 2000L;
    boolean debug = false;
    long testerTimeoutInSeconds = 20L;

    private void run(String[] args) {
        String dataString;
        this.parseArgs(args);
        StringBuilder out = new StringBuilder();
        out.append(sm.get("port.set", this.mcPort)).append("\n");
        out.append(sm.get("address.set", this.mcAddress)).append("\n");
        out.append(sm.get("bind.int.set", this.bindInterface)).append("\n");
        out.append(sm.get("period.set", this.msgPeriodInMillis)).append("\n");
        System.out.println(out.toString());
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            dataString = localHost.getHostName() + "|" + UUID.randomUUID().toString();
        }
        catch (UnknownHostException uhe) {
            System.err.println(sm.get("whoops", uhe.getMessage()));
            return;
        }
        MultiCastReceiverThread receiver = new MultiCastReceiverThread(this.mcPort, this.mcAddress, this.bindInterface, this.debug, dataString);
        MulticastSenderThread sender = new MulticastSenderThread(this.mcPort, this.mcAddress, this.bindInterface, this.msgPeriodInMillis, this.debug, dataString);
        receiver.start();
        sender.start();
        try {
            Thread.sleep(1000L * this.testerTimeoutInSeconds);
            this.log("interrupting sender thread");
            sender.interrupt();
            this.log("joining sender thread");
            sender.join(1000L);
            if (sender.isAlive()) {
                this.log("could not join sender thread. exiting");
            } else {
                this.log("joined sender thread");
            }
            this.log("interrupting receiver thread");
            receiver.interrupt();
            this.log("joining receiver thread");
            receiver.join(1000L);
            if (receiver.isAlive()) {
                this.log("could not join receiver thread. exiting");
            } else {
                this.log("joined receiver thread");
            }
        }
        catch (InterruptedException ie) {
            System.err.println(sm.get("whoops", ie.getMessage()));
            ie.printStackTrace();
        }
        System.out.println(sm.get("timeout.exit", this.testerTimeoutInSeconds, TIMEOUT_OPTION));
        if (!receiver.receivedAnything.get()) {
            System.out.println(sm.get("no.data.for.you", new Object[0]));
        }
        this.printAndExit(null, 0);
    }

    private void parseArgs(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (HELP_OPTION.equals(arg)) {
                    this.doHelpAndExit(0);
                    continue;
                }
                if (PORT_OPTION.equals(arg)) {
                    try {
                        arg = args[++i];
                        this.mcPort = Integer.parseInt(arg);
                    }
                    catch (NumberFormatException nfe) {
                        this.printAndExit(sm.get("bad.num.param", arg, PORT_OPTION), 1);
                    }
                    continue;
                }
                if (ADDRESS_OPTION.equals(arg)) {
                    this.mcAddress = args[++i];
                    continue;
                }
                if (BIND_OPTION.equals(arg)) {
                    this.bindInterface = args[++i];
                    continue;
                }
                if (WAIT_PERIOD_OPTION.equals(arg)) {
                    try {
                        arg = args[++i];
                        this.msgPeriodInMillis = Long.parseLong(arg);
                    }
                    catch (NumberFormatException nfe) {
                        this.printAndExit(sm.get("bad.num.param", arg, WAIT_PERIOD_OPTION), 1);
                    }
                    continue;
                }
                if (TIMEOUT_OPTION.equals(arg)) {
                    try {
                        arg = args[++i];
                        this.testerTimeoutInSeconds = Long.parseLong(arg);
                    }
                    catch (NumberFormatException nfe) {
                        this.printAndExit(sm.get("bad.num.param", arg, TIMEOUT_OPTION), 1);
                    }
                    System.out.println(sm.get("timeout.set", this.testerTimeoutInSeconds));
                    continue;
                }
                if (DEBUG_OPTION.equals(arg)) {
                    System.err.println(sm.get("debug.set", new Object[0]));
                    this.debug = true;
                    continue;
                }
                this.printAndExit(sm.get("unknown.option", arg, HELP_OPTION), 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException badUser) {
            System.err.println(sm.get("bad.user.param", new Object[0]));
            this.doHelpAndExit(1);
        }
    }

    private void doHelpAndExit(int status) {
        StringBuilder sb = new StringBuilder();
        sb.append(sm.get("help.message", new Object[0])).append("\n");
        sb.append(HELP_OPTION).append("\n");
        sb.append(PORT_OPTION).append("\n");
        sb.append(ADDRESS_OPTION).append("\n");
        sb.append(BIND_OPTION).append("\n");
        sb.append(WAIT_PERIOD_OPTION).append("\n");
        sb.append(DEBUG_OPTION).append("\n");
        this.printAndExit(sb.toString(), status);
    }

    private void printAndExit(String msg, int status) {
        if (msg != null) {
            if (status == 0) {
                System.out.println(msg);
            } else {
                System.err.println(msg);
            }
        }
        System.exit(status);
    }

    private void log(String msg) {
        if (this.debug) {
            System.err.println(msg);
        }
    }

    public static void main(String[] args) {
        MulticastTester tester = new MulticastTester();
        tester.run(args);
    }
}

