/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport;

import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.mgmt.transport.AbstractMulticastMessageSender;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageIOException;
import com.sun.enterprise.mgmt.transport.MessageImpl;
import com.sun.enterprise.mgmt.transport.NetworkManager;
import com.sun.enterprise.mgmt.transport.NetworkUtility;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockingIOMulticastSender
extends AbstractMulticastMessageSender
implements Runnable {
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    private final InetSocketAddress localSocketAddress;
    private final InetAddress multicastAddress;
    private final int multicastPort;
    private final InetSocketAddress multicastSocketAddress;
    private final Executor executor;
    private final NetworkManager networkManager;
    private NetworkInterface anInterface;
    private int multicastPacketSize;
    private MulticastSocket multicastSocket;
    private Thread multicastThread;
    private volatile boolean running;
    private CountDownLatch endGate = new CountDownLatch(1);
    private long shutdownTimeout = 30000L;
    private static final String DEFAULT_MULTICAST_ADDRESS = "230.30.1.1";
    private static final int DEFAULT_MULTICAST_PACKET_SIZE = 16384;

    public BlockingIOMulticastSender(String host, String multicastAddress, int multicastPort, String networkInterfaceName, int multicastPacketSize, PeerID localPeerID, Executor executor, NetworkManager networkManager) throws IOException {
        NetworkInterface anInterface;
        if (host != null) {
            this.localSocketAddress = new InetSocketAddress(host, multicastPort);
        } else {
            InetAddress firstInetAddress = null;
            InetAddress multicastInetAddress = InetAddress.getByName(multicastAddress);
            firstInetAddress = multicastInetAddress instanceof Inet6Address ? NetworkUtility.getFirstInetAddress(true) : NetworkUtility.getFirstInetAddress(false);
            this.localSocketAddress = firstInetAddress != null ? new InetSocketAddress(firstInetAddress, multicastPort) : null;
        }
        this.multicastPort = multicastPort;
        if (multicastAddress == null) {
            multicastAddress = DEFAULT_MULTICAST_ADDRESS;
        }
        this.multicastAddress = InetAddress.getByName(multicastAddress);
        this.multicastSocketAddress = new InetSocketAddress(multicastAddress, multicastPort);
        if (networkInterfaceName != null && NetworkUtility.supportsMulticast(anInterface = NetworkInterface.getByName(networkInterfaceName))) {
            this.anInterface = anInterface;
        }
        if (this.anInterface == null) {
            this.anInterface = NetworkUtility.getFirstNetworkInterface();
        }
        this.multicastPacketSize = multicastPacketSize < 16384 ? 16384 : multicastPacketSize;
        this.localPeerID = localPeerID;
        this.executor = executor;
        this.networkManager = networkManager;
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        super.start();
        if (this.localSocketAddress != null) {
            this.multicastSocket = new MulticastSocket(this.localSocketAddress.getPort());
            this.multicastSocket.setInterface(this.localSocketAddress.getAddress());
        } else {
            this.multicastSocket = new MulticastSocket(this.multicastPort);
        }
        this.multicastSocket.setLoopbackMode(false);
        this.running = true;
        this.multicastThread = new Thread((Runnable)this, "IP Multicast Listener for " + this.multicastSocketAddress);
        this.multicastThread.setDaemon(true);
        this.multicastThread.start();
        if (this.anInterface != null) {
            this.multicastSocket.joinGroup(this.multicastSocketAddress, this.anInterface);
        } else {
            this.multicastSocket.joinGroup(this.multicastAddress);
        }
    }

    @Override
    public synchronized void stop() throws IOException {
        if (!this.running) {
            return;
        }
        this.running = false;
        super.stop();
        if (this.multicastSocket != null) {
            try {
                if (this.anInterface != null) {
                    this.multicastSocket.leaveGroup(this.multicastSocketAddress, this.anInterface);
                } else {
                    this.multicastSocket.leaveGroup(this.multicastAddress);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this.multicastSocket.close();
        }
        boolean finished = false;
        try {
            finished = this.endGate.await(this.shutdownTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!finished && this.multicastThread != null) {
            this.multicastThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.running) {
                DatagramPacket packet;
                block16: {
                    byte[] buffer = new byte[this.multicastPacketSize];
                    packet = new DatagramPacket(buffer, buffer.length);
                    this.multicastSocket.receive(packet);
                    if (this.running) break block16;
                    return;
                }
                try {
                    MessageProcessTask processor = new MessageProcessTask(packet);
                    if (this.executor != null) {
                        this.executor.execute(processor);
                        continue;
                    }
                    processor.run();
                }
                catch (InterruptedIOException iie) {
                    Thread.interrupted();
                }
                catch (IOException e) {
                    if (!this.running) {
                    } else if (LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "failure during multicast receive", e);
                    }
                    break;
                }
            }
        }
        catch (Throwable t) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), t);
            }
        }
        finally {
            this.multicastThread = null;
            this.endGate.countDown();
        }
    }

    @Override
    protected boolean doBroadcast(Message message) throws IOException {
        DatagramPacket packet;
        if (!this.running || this.multicastSocket == null) {
            throw new IOException("multicast server is not running");
        }
        if (message == null) {
            throw new IOException("message is null");
        }
        byte[] messageBytes = message.getPlainBytes();
        int numBytesInPacket = messageBytes.length;
        if (numBytesInPacket > this.multicastPacketSize && LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "Multicast datagram exceeds multicast size");
        }
        if (this.localSocketAddress != null) {
            if (this.multicastSocketAddress == null) {
                throw new IOException("multicast address can not be null");
            }
            packet = new DatagramPacket(messageBytes, numBytesInPacket, this.multicastSocketAddress);
        } else {
            if (this.multicastAddress == null) {
                throw new IOException("multicast address can not be null");
            }
            packet = new DatagramPacket(messageBytes, numBytesInPacket, this.multicastAddress, this.multicastPort);
        }
        if (this.multicastSocket != null) {
            this.multicastSocket.send(packet);
            return true;
        }
        return false;
    }

    private class MessageProcessTask
    implements Runnable {
        private final DatagramPacket packet;

        public MessageProcessTask(DatagramPacket packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            block9: {
                if (this.packet == null) {
                    return;
                }
                try {
                    byte[] byteMessage = this.packet.getData();
                    MessageImpl message = new MessageImpl();
                    try {
                        int messageLen = message.parseHeader(byteMessage, 0);
                        message.parseMessage(byteMessage, 16, messageLen);
                    }
                    catch (IllegalArgumentException iae) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.log(Level.WARNING, "damaged multicast discarded", iae);
                        }
                        return;
                    }
                    catch (MessageIOException mie) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.log(Level.WARNING, "damaged multicast discarded", mie);
                        }
                        return;
                    }
                    if (BlockingIOMulticastSender.this.networkManager != null) {
                        BlockingIOMulticastSender.this.networkManager.receiveMessage(message, null);
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.WARNING)) break block9;
                    LOG.log(Level.WARNING, "failed to process a received message", t);
                }
            }
        }
    }
}

