/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public abstract class Command<K, V> {
    private byte opcode;
    protected DataStoreContext<K, V> dsc;
    private CommandManager<K, V> cm;
    private ReplicationOutputStream cachedROS;
    private String commandName;
    protected String targetInstanceName;

    protected Command(byte opcode) {
        this.opcode = opcode;
        this.commandName = this.getClass().getName();
        int index = this.commandName.lastIndexOf(46);
        this.commandName = this.commandName.substring(index + 1);
    }

    public void initialize(DataStoreContext<K, V> rs) {
        this.dsc = rs;
        this.cm = rs.getCommandManager();
    }

    protected final DataStoreContext<K, V> getDataStoreContext() {
        return this.dsc;
    }

    protected final CommandManager<K, V> getCommandManager() {
        return this.cm;
    }

    public String getTargetName() {
        return this.targetInstanceName;
    }

    public final byte getOpcode() {
        return this.opcode;
    }

    protected void setTargetName(String val) {
        this.targetInstanceName = val;
    }

    public final void prepareTransmit(DataStoreContext<K, V> ctx) throws IOException {
        this.cachedROS = new ReplicationOutputStream();
        this.cachedROS.write(this.getOpcode());
        this.writeCommandPayload(this.cachedROS);
    }

    public final void write(ReplicationOutputStream globalROS) throws IOException {
        try {
            byte[] data = this.cachedROS.toByteArray();
            globalROS.write(data);
            globalROS.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public final void prepareToExecute(ReplicationInputStream ris) throws IOException, DataStoreException {
        ris.read();
        this.readCommandPayload(ris);
    }

    protected void selectReplicaInstance(K key) {
        this.targetInstanceName = this.dsc.getKeyMapper().getMappedInstance(this.dsc.getGroupName(), key);
    }

    public String getKeyMappingInfo() {
        return (this.targetInstanceName == null ? "" : this.targetInstanceName) + ":-1";
    }

    public final String getName() {
        return this.commandName + ":" + this.opcode;
    }

    protected abstract void writeCommandPayload(ReplicationOutputStream var1) throws IOException;

    protected abstract void readCommandPayload(ReplicationInputStream var1) throws IOException;

    protected abstract Command<K, V> createNewInstance();

    public abstract void execute(String var1) throws DataStoreException;
}

