/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.interceptor;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.interceptor.ReplicationFrame;
import org.shoal.ha.cache.impl.interceptor.ReplicationFramePayloadCommand;
import org.shoal.ha.cache.impl.util.ASyncThreadPool;

public class ReplicationCommandTransmitter<K, V>
implements Runnable {
    private AtomicInteger outgoingSeqno = new AtomicInteger();
    private AtomicInteger acknowledgedSeqno = new AtomicInteger();
    private DataStoreContext<K, V> dsc;
    private volatile String targetName;
    private ConcurrentLinkedQueue<Command<K, V>> list = new ConcurrentLinkedQueue();
    private ScheduledFuture future;

    public void initialize(String targetName, DataStoreContext<K, V> rsInfo, ASyncThreadPool asyncPool) {
        this.targetName = targetName;
        this.dsc = rsInfo;
        this.future = asyncPool.scheduleAtFixedRate(this, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public void addCommand(Command<K, V> cmd) {
        this.list.add(cmd);
    }

    @Override
    public void run() {
        try {
            if (this.list.peek() != null) {
                ReplicationFrame<K, V> frame = new ReplicationFrame<K, V>(0, this.dsc.getInstanceName());
                Command<K, V> cmd = this.list.poll();
                while (cmd != null) {
                    frame.addCommand(cmd);
                    if (frame.getCommands().size() >= 20) {
                        this.transmitFramePayload(frame);
                        frame = new ReplicationFrame(0, this.dsc.getInstanceName());
                    }
                    cmd = this.list.poll();
                }
                if (frame.getCommands().size() > 0) {
                    this.transmitFramePayload(frame);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void transmitFramePayload(ReplicationFrame<K, V> frame) throws DataStoreException {
        frame.setSeqNo(this.outgoingSeqno.incrementAndGet());
        frame.setTargetInstanceName(this.targetName);
        ReplicationFramePayloadCommand<K, V> cmd = new ReplicationFramePayloadCommand<K, V>();
        cmd.setReplicationFrame(frame);
        this.dsc.getCommandManager().execute(cmd);
    }
}

