/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.interceptor;

import java.io.IOException;
import java.util.List;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.interceptor.ReplicationFrame;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class ReplicationFramePayloadCommand<K, V>
extends Command<K, V> {
    private ReplicationFrame<K, V> frame;

    public ReplicationFramePayloadCommand() {
        super((byte)16);
    }

    public void setReplicationFrame(ReplicationFrame<K, V> frame) {
        this.frame = frame;
    }

    @Override
    protected ReplicationFramePayloadCommand<K, V> createNewInstance() {
        return new ReplicationFramePayloadCommand<K, V>();
    }

    @Override
    public void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        this.setTargetName(this.frame.getTargetInstanceName());
        ros.write(this.frame.getSerializedData());
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws DataStoreException {
        ReplicationFrame frame = ReplicationFrame.toReplicationFrame(this.dsc, ris);
        this.setReplicationFrame(frame);
    }

    @Override
    public void execute(String initiator) throws DataStoreException {
        List<Command<K, V>> commands = this.frame.getCommands();
        for (Command<K, V> cmd : commands) {
            this.getCommandManager().executeCommand(cmd, false, this.frame.getSourceInstanceName());
        }
    }

    public String toString() {
        return "ReplicationFramePayloadCommand: contains " + this.frame.getCommands().size() + " commands";
    }
}

