/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.base;

import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.base.DistributedStateCacheImpl;
import com.sun.enterprise.ee.cms.impl.base.MessagePacket;
import com.sun.enterprise.ee.cms.impl.base.SystemAdvertisement;
import com.sun.enterprise.ee.cms.impl.common.DSCMessage;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.MessageSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.impl.common.ShutdownHelper;
import com.sun.enterprise.ee.cms.impl.common.SignalPacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.GMSMessage;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageWindow
implements Runnable {
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private final Logger monitorLogger = GMSLogDomain.getMonitorLogger();
    private GMSContext ctx;
    private ArrayBlockingQueue<MessagePacket> messageQueue;
    private AtomicInteger messageQueueHighWaterMark = new AtomicInteger(0);
    private final String groupName;

    public MessageWindow(String groupName, ArrayBlockingQueue<MessagePacket> messageQueue) {
        this.groupName = groupName;
        this.messageQueue = messageQueue;
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = GMSContextFactory.getGMSContext(this.groupName);
        }
        return this.ctx;
    }

    private void recordMessageQueueHighWaterMark() {
        int localHighWater;
        int currentQueueSize;
        if (this.monitorLogger.isLoggable(Level.FINE) && (currentQueueSize = this.messageQueue.size()) > (localHighWater = this.messageQueueHighWaterMark.get())) {
            this.messageQueueHighWaterMark.compareAndSet(localHighWater, currentQueueSize);
        }
    }

    @Override
    public void run() {
        while (!this.getGMSContext().isShuttingDown()) {
            try {
                this.recordMessageQueueHighWaterMark();
                MessagePacket packet = this.messageQueue.take();
                if (packet == null) continue;
                this.logger.log(Level.FINER, "Processing received message .... " + packet.getMessage());
                this.newMessageReceived(packet);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINEST, e.getLocalizedMessage());
            }
        }
        if (this.monitorLogger.isLoggable(Level.FINE)) {
            int msgQueueCapacity = this.messageQueue == null ? 0 : this.messageQueue.remainingCapacity();
            this.monitorLogger.log(Level.FINE, "message queue high water mark:" + this.messageQueueHighWaterMark.get() + " msg queue remaining capacity:" + msgQueueCapacity);
        }
        if (this.messageQueue != null && this.messageQueue.size() > 0) {
            int messageQueueSize = this.messageQueue.size();
            this.logger.warning("MessageWindow thread for group " + this.groupName + " terminated due to shutdown notification with " + messageQueueSize + " unprocessed messages");
            if (messageQueueSize > 0 && this.logger.isLoggable(Level.FINER)) {
                Iterator<MessagePacket> mqIter = this.messageQueue.iterator();
                this.logger.finer("Dumping received but unprocessed messages for group: " + this.groupName);
                while (mqIter.hasNext()) {
                    MessagePacket mp = mqIter.next();
                    Object message = mp.getMessage();
                    String sender = mp.getAdvertisement().getName();
                    if (message instanceof GMSMessage) {
                        this.writeLog(sender, (GMSMessage)mp.getMessage());
                        continue;
                    }
                    if (!(message instanceof DSCMessage)) continue;
                    this.logger.log(Level.FINER, MessageFormat.format("Unprocessed DSCMessageReceived from :{0}, Operation :{1}", sender, ((DSCMessage)message).getOperation()));
                }
            }
        } else {
            this.logger.info("MessageWindow thread for group " + this.groupName + " terminated due to shutdown notification");
        }
    }

    private void newMessageReceived(MessagePacket packet) {
        Object message = packet.getMessage();
        SystemAdvertisement adv = packet.getAdvertisement();
        String sender = adv.getName();
        if (message instanceof GMSMessage) {
            this.handleGMSMessage((GMSMessage)message, sender);
        } else if (message instanceof DSCMessage) {
            this.handleDSCMessage((DSCMessage)message, sender);
        }
    }

    private void handleDSCMessage(DSCMessage dMsg, String token) {
        if (this.ctx.isWatchdog()) {
            return;
        }
        String ops = dMsg.getOperation();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, MessageFormat.format("DSCMessageReceived from :{0}, Operation :{1}", token, ops));
        }
        DistributedStateCacheImpl dsc = (DistributedStateCacheImpl)this.getGMSContext().getDistributedStateCache();
        if (ops.equals(DSCMessage.OPERATION.ADD.toString())) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Adding Message: " + dMsg.getKey() + ":" + dMsg.getValue());
            }
            dsc.addToLocalCache(dMsg.getKey(), dMsg.getValue());
        } else if (ops.equals(DSCMessage.OPERATION.REMOVE.toString())) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Removing Values with Key: " + dMsg.getKey());
            }
            dsc.removeFromLocalCache(dMsg.getKey());
        } else if (ops.equals(DSCMessage.OPERATION.ADDALLLOCAL.toString())) {
            if (dMsg.isCoordinator()) {
                try {
                    this.logger.log(Level.FINER, "Syncing local cache with group ...");
                    dsc.addAllToRemoteCache();
                    this.logger.log(Level.FINER, "done with local to group sync...");
                }
                catch (GMSException e) {
                    this.logger.log(Level.WARNING, e.getLocalizedMessage());
                }
                this.logger.log(Level.FINER, "adding group cache state to local cache..");
                dsc.addAllToLocalCache(dMsg.getCache());
            }
        } else if (ops.equals(DSCMessage.OPERATION.ADDALLREMOTE.toString())) {
            dsc.addAllToLocalCache(dMsg.getCache());
        }
    }

    private void handleGMSMessage(GMSMessage gMsg, String sender) {
        if (gMsg.getComponentName() != null && gMsg.getComponentName().equals(GMSConstants.shutdownType.GROUP_SHUTDOWN.toString())) {
            ShutdownHelper sh = GMSContextFactory.getGMSContext(gMsg.getGroupName()).getShutdownHelper();
            this.logger.log(Level.INFO, "member.groupshutdown", new Object[]{sender, this.groupName});
            sh.addToGroupShutdownList(gMsg.getGroupName());
            this.logger.log(Level.FINE, "setting clusterStopping variable to true");
            GMSContextFactory.getGMSContext(gMsg.getGroupName()).getGroupCommunicationProvider().setGroupStoppingState();
        } else if (this.getRouter().isMessageAFRegistered()) {
            this.writeLog(sender, gMsg);
            MessageSignalImpl ms = new MessageSignalImpl(gMsg.getMessage(), gMsg.getComponentName(), sender, gMsg.getGroupName(), gMsg.getStartTime());
            SignalPacket signalPacket = new SignalPacket((Signal)ms);
            this.getRouter().queueSignal(signalPacket);
        }
    }

    private Router getRouter() {
        return this.getGMSContext().getRouter();
    }

    private void writeLog(String sender, GMSMessage message) {
        String localId = this.getGMSContext().getServerIdentityToken();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, MessageFormat.format("Sender:{0}, Receiver :{1}, TargetComponent :{2}, Message :{3}", sender, localId, message.getComponentName(), new String(message.getMessage())));
        }
    }
}

