/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.client;

import com.sun.enterprise.ee.cms.core.ActionException;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureRecoveryAction;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FailureRecoveryActionImpl
implements FailureRecoveryAction {
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private CallBack caller;

    public FailureRecoveryActionImpl(CallBack caller) {
        this.caller = caller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeSignal(Signal signal) throws ActionException {
        boolean signalAcquired = false;
        String component = ((FailureRecoverySignal)signal).getComponentName();
        try {
            signal.acquire();
            signalAcquired = true;
            this.logger.log(Level.FINE, component + ":Failure Recovery Signal acquired");
            this.notifyListeners(signal);
        }
        catch (SignalAcquireException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        finally {
            if (signalAcquired) {
                try {
                    signal.release();
                    this.logger.log(Level.FINE, component + ":Failure Recovery Signal released");
                }
                catch (SignalReleaseException e) {
                    this.logger.log(Level.SEVERE, e.getLocalizedMessage());
                }
            }
        }
    }

    private void notifyListeners(Signal signal) {
        this.caller.processNotification(signal);
    }
}

