/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.client;

import com.sun.enterprise.ee.cms.core.ActionException;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.MessageAction;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageActionImpl
implements MessageAction {
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private CallBack callback;

    public MessageActionImpl(CallBack callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeSignal(Signal signal) throws ActionException {
        boolean signalAcquired = false;
        try {
            signal.acquire();
            signalAcquired = true;
            this.processMessage(signal);
        }
        catch (SignalAcquireException e) {
            this.logger.log(Level.SEVERE, "Failed to consumeSignal(" + signal + ") due to exception " + e.getLocalizedMessage());
        }
        finally {
            if (signalAcquired) {
                try {
                    signal.release();
                }
                catch (SignalReleaseException e) {
                    this.logger.log(Level.SEVERE, e.getLocalizedMessage());
                }
            }
        }
    }

    private void processMessage(Signal signal) throws ActionException {
        try {
            this.callback.processNotification(signal);
        }
        catch (Throwable t) {
            String callbackClassName = this.callback == null ? "<null>" : this.callback.getClass().getName();
            this.logger.log(Level.WARNING, "handled unexpected exception " + t.getClass().getName() + " when calling registered application callback method " + callbackClassName + ".processNotification.  The method should have handled this exception.", t);
            ActionException ae = new ActionException("unhandled exception processing signal " + signal.toString());
            ae.initCause(t);
            throw ae;
        }
    }
}

