/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.AcknowledgedCommand;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class SaveCommand<K, V>
extends AcknowledgedCommand<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.save");
    private K k;
    private V v;
    private transient byte[] rawReadState;
    String replicaChoices;

    public SaveCommand() {
        super((byte)33);
    }

    public SaveCommand(K k, V v) {
        this();
        this.setKey(k);
        this.setValue(v);
    }

    public void setKey(K k) {
        this.k = k;
    }

    public void setValue(V v) {
        this.v = v;
    }

    @Override
    protected SaveCommand<K, V> createNewInstance() {
        return new SaveCommand<K, V>();
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        if (!this.dsc.isDoASyncReplication()) {
            super.writeAcknowledgementId(ros);
        }
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.k);
        this.dsc.getDataStoreEntryHelper().writeObject(ros, this.v);
    }

    @Override
    public boolean computeTarget() {
        this.replicaChoices = this.dsc.getKeyMapper().getMappedInstance(this.dsc.getGroupName(), this.k);
        super.setTargetName(this.replicaChoices);
        return this.getTargetName() != null;
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        if (!this.dsc.isDoASyncReplication()) {
            super.readAcknowledgementId(ris);
        }
        this.k = this.dsc.getDataStoreKeyHelper().readKey(ris);
        this.v = this.dsc.getDataStoreEntryHelper().readObject(ris);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreEntry entry;
        DataStoreEntry dataStoreEntry = entry = this.dsc.getReplicaStore().getOrCreateEntry(this.k);
        synchronized (dataStoreEntry) {
            entry.setV(this.v);
        }
        if (!this.dsc.isDoASyncReplication()) {
            _logger.log(Level.WARNING, "SaveCommand Sending SIMPLE_ACK");
            super.sendAcknowledgement();
        }
    }

    public String toString() {
        return this.getName() + "(" + this.k + ")";
    }

    @Override
    public String getKeyMappingInfo() {
        return this.replicaChoices;
    }

    @Override
    public void onSuccess() {
        if (!this.dsc.isDoASyncReplication()) {
            try {
                super.onSuccess();
                super.waitForAck();
            }
            catch (Exception ex) {
                System.out.println("** Got exception: " + ex);
            }
        }
    }
}

