/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.Storeable;
import org.shoal.adapter.store.commands.StoreableLoadResponseCommand;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class StoreableBroadcastLoadRequestCommand<K, V extends Storeable>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.load_request");
    private K key;
    CommandResponse resp;
    private Future future;
    private long tokenId;
    private Long version;
    private String originatingInstance;

    public StoreableBroadcastLoadRequestCommand() {
        super((byte)70);
    }

    public StoreableBroadcastLoadRequestCommand(K key, Long version) {
        this();
        this.key = key;
        this.version = version;
    }

    @Override
    protected StoreableBroadcastLoadRequestCommand<K, V> createNewInstance() {
        return new StoreableBroadcastLoadRequestCommand<K, V>();
    }

    @Override
    public boolean computeTarget() {
        super.setTargetName(null);
        return true;
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        this.originatingInstance = this.dsc.getInstanceName();
        this.setTargetName(null);
        ResponseMediator respMed = this.dsc.getResponseMediator();
        this.resp = respMed.createCommandResponse();
        this.future = this.resp.getFuture();
        ros.writeLong(this.resp.getTokenId());
        ros.writeLong(this.version == null ? Long.MIN_VALUE : this.version);
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.key);
        ros.writeLengthPrefixedString(this.originatingInstance);
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.tokenId = ris.readLong();
        this.version = ris.readLong();
        this.key = this.dsc.getDataStoreKeyHelper().readKey(ris);
        this.originatingInstance = ris.readLengthPrefixedString();
    }

    @Override
    public void execute(String initiator) {
        try {
            DataStoreEntry e = this.dsc.getReplicaStore().getEntry(this.key);
            if (!this.originatingInstance.equals(this.dsc.getInstanceName()) && e != null) {
                Storeable v = (Storeable)e.getV();
                if (v != null && v._storeable_getVersion() >= this.version) {
                    StoreableLoadResponseCommand rsp = new StoreableLoadResponseCommand(this.key, this.dsc.getDataStoreEntryHelper().getV(e), this.tokenId);
                    rsp.setOriginatingInstance(this.originatingInstance);
                    this.getCommandManager().execute(rsp);
                } else if (v != null) {
                    e.markAsRemoved("Removed due to stale version. requested: " + this.version + " > " + v._storeable_getVersion());
                }
            }
        }
        catch (DataStoreException dsEx) {
            this.resp.setException(dsEx);
        }
    }

    public String getRespondingInstanceName() {
        return this.resp.getRespondingInstanceName();
    }

    public V getResult(long waitFor, TimeUnit unit) throws DataStoreException {
        try {
            Object result = this.future.get(waitFor, unit);
            if (result instanceof Exception) {
                throw new DataStoreException((Exception)result);
            }
            return (V)((Storeable)result);
        }
        catch (DataStoreException dsEx) {
            throw dsEx;
        }
        catch (InterruptedException inEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand Interrupted while waiting for result", inEx);
            throw new DataStoreException(inEx);
        }
        catch (TimeoutException timeoutEx) {
            _logger.log(Level.FINE, "LoadRequestCommand timed out while waiting for result", timeoutEx);
            return null;
        }
        catch (ExecutionException exeEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand got an exception while waiting for result", exeEx);
            throw new DataStoreException(exeEx);
        }
    }

    public String toString() {
        return this.getName() + "(" + this.key + ")";
    }
}

