/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.Storeable;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class StoreableTouchCommand<K, V extends Storeable>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.touch");
    private K k;
    private long version = -1L;
    private long accessTime;
    private long maxIdleTime;
    private String replicaChoices;

    public StoreableTouchCommand() {
        super((byte)73);
    }

    public StoreableTouchCommand(K k, long version, long accessTime, long maxIdleTime) {
        this();
        this.k = k;
        this.version = version;
        this.accessTime = accessTime;
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    protected StoreableTouchCommand<K, V> createNewInstance() {
        return new StoreableTouchCommand<K, V>();
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.k);
        ros.writeLong(this.version);
        ros.writeLong(this.accessTime);
        ros.writeLong(this.maxIdleTime);
    }

    @Override
    public boolean computeTarget() {
        String replicaChoices = this.dsc.getKeyMapper().getReplicaChoices(this.dsc.getGroupName(), this.k);
        String[] choices = replicaChoices == null ? null : replicaChoices.split(":");
        super.setTargetName(replicaChoices == null ? null : choices[0]);
        return this.getTargetName() != null;
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.k = this.dsc.getDataStoreKeyHelper().readKey(ris);
        this.version = ris.readLong();
        this.accessTime = ris.readLong();
        this.maxIdleTime = ris.readLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreEntry entry = this.dsc.getReplicaStore().getEntry(this.k);
        if (entry != null) {
            DataStoreEntry dataStoreEntry = entry;
            synchronized (dataStoreEntry) {
                if (!entry.isRemoved()) {
                    Storeable entryV = (Storeable)entry.getV();
                    if (entryV != null) {
                        if (entryV._storeable_getVersion() + 1L == this.version) {
                            entryV._storeable_setVersion(this.version);
                            entryV._storeable_setLastAccessTime(this.accessTime);
                            entryV._storeable_setMaxIdleTime(this.maxIdleTime);
                        } else if (entryV._storeable_getVersion() < this.version) {
                            List commands = entry.getPendingUpdates();
                            _logger.log(Level.INFO, "Added to pending updates.... for key: " + this.k);
                        }
                    } else {
                        List commands = entry.getPendingUpdates();
                        _logger.log(Level.INFO, "Added to pending updates.... for key: " + this.k);
                    }
                }
            }
        }
    }

    @Override
    public String getKeyMappingInfo() {
        return this.replicaChoices;
    }
}

