/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands.monitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.RepliatedBackingStoreRegistry;
import org.shoal.adapter.store.commands.monitor.ListBackingStoreConfigurationResponseCommand;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.store.ReplicaStore;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class ListReplicaStoreEntriesCommand
extends Command {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.monitor");
    private String storeName;
    CommandResponse resp;
    private Future future;
    private long tokenId;
    private String originatingInstance;

    public ListReplicaStoreEntriesCommand(String storeName) {
        super((byte)87);
        this.storeName = storeName;
    }

    protected ListReplicaStoreEntriesCommand createNewInstance() {
        return new ListReplicaStoreEntriesCommand(null);
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        this.originatingInstance = this.dsc.getInstanceName();
        this.setTargetName(null);
        ResponseMediator respMed = this.dsc.getResponseMediator();
        this.resp = respMed.createCommandResponse();
        this.future = this.resp.getFuture();
        ros.writeLong(this.resp.getTokenId());
        ros.writeLengthPrefixedString(this.originatingInstance);
        ros.writeLengthPrefixedString(this.storeName);
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.tokenId = ris.readLong();
        this.originatingInstance = ris.readLengthPrefixedString();
        this.storeName = ris.readLengthPrefixedString();
    }

    public String getRespondingInstanceName() {
        return this.resp.getRespondingInstanceName();
    }

    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreContext ctx = RepliatedBackingStoreRegistry.getContext(this.storeName);
        ReplicaStore store = ctx.getReplicaStore();
        ArrayList<String> confList = new ArrayList<String>();
        for (DataStoreEntry entry : store.values()) {
            confList.add(entry.getKey() + ":" + entry);
        }
        ListBackingStoreConfigurationResponseCommand respCmd = new ListBackingStoreConfigurationResponseCommand(this.originatingInstance, this.tokenId, confList);
        this.getCommandManager().execute(respCmd);
    }

    public ArrayList<String> getResult(long waitFor, TimeUnit unit) throws DataStoreException {
        try {
            Object result = this.future.get(waitFor, unit);
            if (result instanceof Exception) {
                throw new DataStoreException((Exception)result);
            }
            return (ArrayList)result;
        }
        catch (DataStoreException dsEx) {
            throw dsEx;
        }
        catch (InterruptedException inEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand Interrupted while waiting for result", inEx);
            throw new DataStoreException(inEx);
        }
        catch (TimeoutException timeoutEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand timed out while waiting for result", timeoutEx);
            throw new DataStoreException(timeoutEx);
        }
        catch (ExecutionException exeEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand got an exception while waiting for result", exeEx);
            throw new DataStoreException(exeEx);
        }
    }
}

