/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.base;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.GMSCacheable;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.MemberNotInViewException;
import com.sun.enterprise.ee.cms.impl.common.DSCMessage;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DistributedStateCacheImpl
implements DistributedStateCache {
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private static final ConcurrentHashMap<String, DistributedStateCacheImpl> ctxCache = new ConcurrentHashMap();
    private final String groupName;
    private final ConcurrentHashMap<GMSCacheable, Object> cache;
    private final AtomicReference<GMSContext> ctxRef;
    private volatile boolean firstSyncDone;

    private DistributedStateCacheImpl(String groupName) {
        this.groupName = groupName;
        this.cache = new ConcurrentHashMap();
        this.ctxRef = new AtomicReference<Object>(null);
        this.firstSyncDone = false;
    }

    static DistributedStateCache getInstance(String groupName) {
        DistributedStateCacheImpl otherInstance;
        DistributedStateCacheImpl instance = ctxCache.get(groupName);
        if (instance == null && (otherInstance = ctxCache.putIfAbsent(groupName, instance = new DistributedStateCacheImpl(groupName))) != null) {
            instance = otherInstance;
        }
        return instance;
    }

    public void addToCache(String componentName, String memberTokenId, Serializable key, Serializable state) throws GMSException {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Adding to DSC by local Member:" + memberTokenId + ",Component:" + componentName + ",key:" + key + ",State:" + state);
        }
        GMSCacheable cKey = DistributedStateCacheImpl.createCompositeKey(componentName, memberTokenId, key);
        this.addToLocalCache(cKey, state);
        this.addToRemoteCache(cKey, state);
    }

    public void addToCache(String componentName, String memberTokenId, Serializable key, byte[] state) throws GMSException {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Adding to DSC by local Member:" + memberTokenId + ",Component:" + componentName + ",key:" + key + ",State:" + state);
        }
        GMSCacheable cKey = DistributedStateCacheImpl.createCompositeKey(componentName, memberTokenId, key);
        this.addToLocalCache(cKey, state);
        this.addToRemoteCache(cKey, state);
    }

    public void addToLocalCache(String componentName, String memberTokenId, Serializable key, Serializable state) {
        GMSCacheable cKey = DistributedStateCacheImpl.createCompositeKey(componentName, memberTokenId, key);
        this.addToLocalCache(cKey, state);
    }

    public void addToLocalCache(String componentName, String memberTokenId, Serializable key, byte[] state) {
        GMSCacheable cKey = DistributedStateCacheImpl.createCompositeKey(componentName, memberTokenId, key);
        this.addToLocalCache(cKey, state);
    }

    public void addToLocalCache(GMSCacheable cKey, Object state) {
        cKey = this.getTrueKey(cKey);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Adding cKey=" + cKey.toString() + " state=" + state.toString());
        }
        this.cache.put(cKey, state);
        this.printDSCContents();
    }

    private void printDSCContents() {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, this.getGMSContext().getServerIdentityToken() + ":DSC now contains ---------\n" + this.getDSCContents());
        }
    }

    private GMSContext getGMSContext() {
        GMSContext ctx = this.ctxRef.get();
        if (ctx == null) {
            ctx = GMSContextFactory.getGMSContext(this.groupName);
            if (ctx == null) {
                logger.log(Level.WARNING, "dsc.no.ctx", new Object[]{this.groupName});
            } else {
                boolean oldValueWasNull = this.ctxRef.compareAndSet(null, ctx);
                if (!oldValueWasNull) {
                    ctx = this.ctxRef.get();
                }
            }
        }
        return ctx;
    }

    private String getDSCContents() {
        StringBuffer buf = new StringBuffer();
        ConcurrentHashMap<GMSCacheable, Object> copy = new ConcurrentHashMap<GMSCacheable, Object>(this.cache);
        for (GMSCacheable c : copy.keySet()) {
            buf.append(c.hashCode()).append(" key=").append(c.toString()).append(" : value=").append(copy.get(c)).append("\n");
        }
        return buf.toString();
    }

    private void addToRemoteCache(GMSCacheable cKey, Object state) throws GMSException {
        DSCMessage msg = new DSCMessage(cKey, state, DSCMessage.OPERATION.ADD.toString());
        this.sendMessage(null, msg);
    }

    public void removeFromCache(String componentName, String memberTokenId, Serializable key) throws GMSException {
        GMSCacheable cKey = DistributedStateCacheImpl.createCompositeKey(componentName, memberTokenId, key);
        this.removeFromLocalCache(cKey);
        this.removeFromRemoteCache(cKey);
    }

    void removeFromLocalCache(GMSCacheable cKey) {
        cKey = this.getTrueKey(cKey);
        this.cache.remove(cKey);
    }

    private void removeFromRemoteCache(GMSCacheable cKey) throws GMSException {
        cKey = this.getTrueKey(cKey);
        DSCMessage msg = new DSCMessage(cKey, null, DSCMessage.OPERATION.REMOVE.toString());
        this.sendMessage(null, msg);
    }

    public Object getFromCache(String componentName, String memberTokenId, Serializable key) throws GMSException {
        if (key != null && componentName != null && memberTokenId != null) {
            GMSCacheable cKey = DistributedStateCacheImpl.createCompositeKey(componentName, memberTokenId, key);
            cKey = this.getTrueKey(cKey);
            return this.cache.get(cKey);
        }
        throw new GMSException(new StringBuffer().append("DistributedStateCache: ").append("componentName, memberTokenId and key ").append("are required parameters and cannot be null").toString());
    }

    public Map<GMSCacheable, Object> getAllCache() {
        return new ConcurrentHashMap<GMSCacheable, Object>(this.cache);
    }

    private Map<Serializable, Serializable> getEntryFromCacheForPattern(String componentName, String memberToken) {
        Hashtable<Serializable, Serializable> retval = new Hashtable<Serializable, Serializable>();
        for (GMSCacheable c : this.cache.keySet()) {
            if (!componentName.equals(c.getComponentName()) || !memberToken.equals(c.getMemberTokenId())) continue;
            retval.put((Serializable)c.getKey(), (Serializable)this.cache.get(c));
        }
        return retval;
    }

    public Map<Serializable, Serializable> getFromCacheForPattern(String componentName, String memberToken) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DSCImpl.getCacheFromPattern() for " + memberToken);
        }
        Hashtable<Serializable, Serializable> retval = new Hashtable<Serializable, Serializable>();
        if (componentName == null || memberToken == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "DistributedStateCacheImpl.getFromCachePattern() parameter is null.  component=" + componentName + " member=" + memberToken);
            }
            return retval;
        }
        retval.putAll(this.getEntryFromCacheForPattern(componentName, memberToken));
        if (!retval.isEmpty()) {
            return retval;
        }
        if (!this.getGMSContext().isShuttingDown() && !memberToken.equals(this.getGMSContext().getServerIdentityToken()) && this.getGMSContext().getGroupHandle().getAllCurrentMembers().contains(memberToken)) {
            ConcurrentHashMap<GMSCacheable, Object> temp = new ConcurrentHashMap<GMSCacheable, Object>(this.cache);
            DSCMessage msg = new DSCMessage(temp, DSCMessage.OPERATION.ADDALLLOCAL.toString(), true);
            try {
                boolean sent = this.sendMessage(memberToken, msg);
                if (sent) {
                    Thread.sleep(3000L);
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "DistributedStateCacheImpl.getFromCachePattern() send failed for component=" + componentName + " member=" + memberToken);
                }
                retval.putAll(this.getEntryFromCacheForPattern(componentName, memberToken));
            }
            catch (GMSException e) {
                logger.log(Level.WARNING, "dsc.sync.exception", e);
            }
            catch (InterruptedException e) {}
        } else {
            logger.log(Level.FINE, "getFromCacheForPattern(" + componentName + "," + memberToken + ")" + ": returning empty map. " + "reason: isShuttingDown()=" + this.getGMSContext().isShuttingDown() + " isCurrentMember=" + this.getGMSContext().getGroupHandle().getAllCurrentMembers().contains(memberToken));
        }
        if (retval.isEmpty()) {
            logger.finer("retVal is empty");
        }
        return retval;
    }

    public Map<GMSCacheable, Object> getFromCache(Object key) {
        Hashtable<GMSCacheable, Object> retval = new Hashtable<GMSCacheable, Object>();
        for (GMSCacheable c : this.cache.keySet()) {
            if (!key.equals(c.getComponentName()) && !key.equals(c.getMemberTokenId()) && !key.equals(c.getKey())) continue;
            retval.put(c, this.cache.get(c));
        }
        return retval;
    }

    public boolean contains(Object key) {
        boolean retval = false;
        for (GMSCacheable c : this.cache.keySet()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, new StringBuffer().append("key=").append(key).append(" underlying key=").append(c.getKey()).toString());
            }
            if (!key.equals(c.getKey())) continue;
            retval = true;
        }
        return retval;
    }

    public boolean contains(String componentName, Object key) {
        boolean retval = false;
        for (GMSCacheable c : this.cache.keySet()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, new StringBuffer().append("comp=").append(componentName).append(" underlying comp=").append(c.getComponentName()).toString());
                logger.log(Level.FINER, new StringBuffer().append("key=").append(key).append(" underlying key=").append(c.getKey()).toString());
            }
            if (!key.equals(c.getKey()) || !componentName.equals(c.getComponentName())) continue;
            retval = true;
        }
        return retval;
    }

    void addAllToLocalCache(Map<GMSCacheable, Object> map) {
        if (map != null && map.size() > 0) {
            this.cache.putAll(map);
        }
        this.indicateFirstSyncDone();
        logger.log(Level.FINER, "done adding all to Distributed State Cache");
    }

    void addAllToRemoteCache() throws GMSException {
        ConcurrentHashMap<GMSCacheable, Object> temp = new ConcurrentHashMap<GMSCacheable, Object>(this.cache);
        DSCMessage msg = new DSCMessage(temp, DSCMessage.OPERATION.ADDALLREMOTE.toString(), false);
        this.sendMessage(null, msg);
    }

    void removeAllFromCache(String componentName, String memberTokenId, List<Serializable> exempted) {
    }

    Hashtable<GMSCacheable, Object> getAllEntries() {
        Hashtable<GMSCacheable, Object> temp = new Hashtable<GMSCacheable, Object>();
        for (GMSCacheable key : this.cache.keySet()) {
            temp.put(key, this.cache.get(key));
        }
        return temp;
    }

    void syncCache(String memberToken, boolean isCoordinator) throws GMSException {
        ConcurrentHashMap<GMSCacheable, Object> temp = new ConcurrentHashMap<GMSCacheable, Object>(this.cache);
        DSCMessage msg = new DSCMessage(temp, DSCMessage.OPERATION.ADDALLLOCAL.toString(), isCoordinator);
        if (!memberToken.equals(this.getGMSContext().getServerIdentityToken())) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Sending sync message from DistributedStateCache to member " + memberToken);
            }
            this.sendMessage(memberToken, msg);
        }
        if (isCoordinator) {
            this.indicateFirstSyncDone();
        }
    }

    private GMSCacheable getTrueKey(GMSCacheable cKey) {
        Set keys = this.cache.keySet();
        for (GMSCacheable comp : keys) {
            if (!comp.equals((Object)cKey)) continue;
            cKey = comp;
            break;
        }
        return cKey;
    }

    private static GMSCacheable createCompositeKey(String componentName, String memberTokenId, Object key) {
        return new GMSCacheable(componentName, memberTokenId, key);
    }

    private boolean sendMessage(String member, DSCMessage msg) throws GMSException {
        boolean sent = false;
        try {
            this.getGMSContext().getGroupCommunicationProvider().sendMessage(member, (Serializable)msg, true);
            sent = true;
        }
        catch (MemberNotInViewException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Member " + member + " is not in the view anymore. Hence not performing sendMessage operation", e);
            }
        }
        catch (GMSException ge) {
            logger.log(Level.WARNING, "dsc.send.failed", new Object[]{member, msg});
        }
        return sent;
    }

    private void indicateFirstSyncDone() {
        if (!this.firstSyncDone) {
            this.firstSyncDone = true;
        }
    }

    public boolean isFirstSyncDone() {
        return this.firstSyncDone;
    }

    public void removeAll() {
        this.cache.clear();
    }

    public void removeAllForMember(String memberToken) {
        Set<GMSCacheable> keys = this.getFromCache(memberToken).keySet();
        for (GMSCacheable key : keys) {
            this.removeFromLocalCache(key);
        }
    }
}

