/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.SizeResponseCommand;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class SizeRequestCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.size");
    private long tokenId;
    private String targetInstanceName;
    private Future future;

    public SizeRequestCommand() {
        super((byte)51);
    }

    public SizeRequestCommand(String targetInstanceName) {
        this();
        this.targetInstanceName = targetInstanceName;
    }

    @Override
    protected SizeRequestCommand<K, V> createNewInstance() {
        return new SizeRequestCommand<K, V>();
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        ResponseMediator respMed = this.dsc.getResponseMediator();
        CommandResponse resp = respMed.createCommandResponse();
        this.future = resp.getFuture();
        this.setTargetName(this.targetInstanceName);
        ros.writeLengthPrefixedString(this.dsc.getInstanceName());
        ros.writeLengthPrefixedString(this.targetInstanceName);
        ros.writeLong(resp.getTokenId());
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.targetInstanceName = ris.readLengthPrefixedString();
        String myName = ris.readLengthPrefixedString();
        this.tokenId = ris.readLong();
    }

    @Override
    public void execute(String initiator) throws DataStoreException {
        int size = this.dsc.getReplicaStore().size();
        SizeResponseCommand srCmd = new SizeResponseCommand(this.targetInstanceName, this.tokenId, size);
        this.dsc.getCommandManager().execute(srCmd);
    }

    public String toString() {
        return this.getName() + "; tokenId=" + this.tokenId;
    }

    public int getResult() {
        int result = 0;
        try {
            result = (Integer)this.future.get(3L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

