/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.Storeable;
import org.shoal.adapter.store.commands.StoreableLoadResponseCommand;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class StoreableLoadRequestCommand<K, V extends Storeable>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.load_request");
    private K key;
    private Long minimumRequiredVersion = Long.MIN_VALUE;
    CommandResponse resp;
    private Future future;
    private long tokenId;
    private String originatingInstance;
    private String replicaLocationHint;

    public StoreableLoadRequestCommand() {
        super((byte)69);
    }

    public StoreableLoadRequestCommand(K key, long requestHint, String targetReplicaInstance) {
        this();
        this.key = key;
        this.minimumRequiredVersion = requestHint;
        this.replicaLocationHint = targetReplicaInstance;
    }

    @Override
    protected StoreableLoadRequestCommand<K, V> createNewInstance() {
        return new StoreableLoadRequestCommand<K, V>();
    }

    public void setKey(K key) {
        this.key = key;
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        this.originatingInstance = this.dsc.getInstanceName();
        this.setTargetName(this.replicaLocationHint);
        ResponseMediator respMed = this.dsc.getResponseMediator();
        this.resp = respMed.createCommandResponse();
        this.future = this.resp.getFuture();
        ros.writeLong(this.resp.getTokenId());
        ros.writeLong(this.minimumRequiredVersion);
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.key);
        ros.writeLengthPrefixedString(this.originatingInstance);
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.tokenId = ris.readLong();
        this.minimumRequiredVersion = ris.readLong();
        this.key = this.dsc.getDataStoreKeyHelper().readKey(ris);
        this.originatingInstance = ris.readLengthPrefixedString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) {
        try {
            DataStoreEntry e = this.dsc.getReplicaStore().getEntry(this.key);
            Storeable result = null;
            if (e != null) {
                DataStoreEntry dataStoreEntry = e;
                synchronized (dataStoreEntry) {
                    Storeable v = (Storeable)e.getV();
                    if (!e.isRemoved()) {
                        if (v != null && v._storeable_getVersion() >= this.minimumRequiredVersion) {
                            result = (Storeable)e.getV();
                        }
                    } else {
                        e.markAsRemoved("Removed by StoreableLoadRequestCommand");
                    }
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.dsc.getInstanceName() + this.getName() + " will send " + this.key + " => " + result + " to " + initiator);
            }
            if (!this.originatingInstance.equals(this.dsc.getInstanceName())) {
                StoreableLoadResponseCommand<K, Object> rsp = new StoreableLoadResponseCommand<K, Object>(this.key, result, this.tokenId);
                rsp.setOriginatingInstance(this.originatingInstance);
                this.getCommandManager().execute(rsp);
            } else {
                this.resp.setResult(result);
            }
        }
        catch (DataStoreException dsEx) {
            this.resp.setException(dsEx);
        }
    }

    public String getRespondingInstanceName() {
        return this.resp.getRespondingInstanceName();
    }

    public V getResult(long waitFor, TimeUnit unit) throws DataStoreException {
        Storeable result = null;
        try {
            result = (Storeable)this.future.get(waitFor, unit);
            if (result instanceof Exception) {
                throw new DataStoreException((Exception)result);
            }
        }
        catch (DataStoreException dsEx) {
            throw dsEx;
        }
        catch (InterruptedException inEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand Interrupted while waiting for result", inEx);
            throw new DataStoreException(inEx);
        }
        catch (TimeoutException timeoutEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand timed out while waiting for result", timeoutEx);
        }
        catch (ExecutionException exeEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand got an exception while waiting for result", exeEx);
            throw new DataStoreException(exeEx);
        }
        return (V)result;
    }

    public String toString() {
        return "StoreableLoadRequestCommand{key=" + this.key + ", minimumRequiredVersion=" + this.minimumRequiredVersion + ", resp=" + this.resp + ", tokenId=" + this.tokenId + ", originatingInstance='" + this.originatingInstance + '\'' + '}';
    }
}

