/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.AbstractCommandInterceptor;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.interceptor.CommandHandlerInterceptor;
import org.shoal.ha.cache.impl.interceptor.TransmitInterceptor;
import org.shoal.ha.cache.impl.util.MessageReceiver;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;

public class CommandManager<K, V>
extends MessageReceiver {
    private String myName;
    private DataStoreContext<K, V> dsc;
    private Command<K, V>[] commands = (Command[])Array.newInstance(Command.class, 256);
    private volatile AbstractCommandInterceptor<K, V> head;
    private volatile AbstractCommandInterceptor<K, V> tail;
    private static Logger _logger = Logger.getLogger("org.shoal.ha.cache.command");

    public CommandManager(DataStoreContext<K, V> dsc) {
        super(dsc.getServiceName());
        this.dsc = dsc;
        this.myName = dsc.getInstanceName();
        this.head = new CommandHandlerInterceptor();
        this.head.initialize(dsc);
        this.tail = new TransmitInterceptor();
        this.tail.initialize(dsc);
        this.head.setNext(this.tail);
        this.tail.setPrev(this.head);
    }

    public void registerCommand(Command command) {
        this.commands[command.getOpcode()] = command;
        command.initialize(this.dsc);
    }

    public synchronized void registerExecutionInterceptor(AbstractCommandInterceptor<K, V> interceptor) {
        interceptor.initialize(this.dsc);
        interceptor.setPrev(this.tail.getPrev());
        this.tail.getPrev().setNext(interceptor);
        interceptor.setNext(this.tail);
        this.tail.setPrev(interceptor);
    }

    public void execute(Command<K, V> cmd) throws DataStoreException {
        this.executeCommand(cmd, true, this.myName);
    }

    public final void reExecute(Command<K, V> cmd) throws DataStoreException {
        cmd.computeTarget();
        this.tail.onTransmit(cmd, this.myName);
    }

    public final void executeCommand(Command<K, V> cmd, boolean forward, String initiator) throws DataStoreException {
        cmd.initialize(this.dsc);
        if (forward) {
            try {
                this.head.onTransmit(cmd, initiator);
                cmd.onSuccess();
            }
            catch (DataStoreException dseEx) {
                cmd.onError(dseEx);
            }
        } else {
            this.tail.onReceive(cmd, initiator);
        }
    }

    public Command<K, V> createNewInstance(byte opcode) throws IOException {
        Command<K, V> cmd2 = this.commands[opcode];
        Command<K, V> cmd = null;
        if (cmd2 == null) {
            throw new IOException("Illegal opcode: " + opcode);
        }
        cmd = cmd2.createNewInstance();
        cmd.initialize(this.dsc);
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleMessage(String sourceMemberName, String token, byte[] messageData) {
        ByteArrayInputStream ris = null;
        try {
            byte opCode = messageData[0];
            Command<K, V> cmd = this.createNewInstance(opCode);
            ris = new ReplicationInputStream(messageData);
            cmd.prepareToExecute((ReplicationInputStream)ris);
            this.executeCommand(cmd, false, sourceMemberName);
        }
        catch (IOException dse) {
            _logger.log(Level.WARNING, "Error during parsing command", dse);
        }
        finally {
            try {
                ris.close();
            }
            catch (Exception ex) {}
        }
    }
}

