/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.api.Storeable;
import org.shoal.adapter.store.ReplicatedBackingStoreFactory;
import org.shoal.adapter.store.commands.NoOpCommand;
import org.shoal.adapter.store.commands.RemoveExpiredCommand;
import org.shoal.adapter.store.commands.SimpleAckCommand;
import org.shoal.adapter.store.commands.SizeRequestCommand;
import org.shoal.adapter.store.commands.SizeResponseCommand;
import org.shoal.adapter.store.commands.StaleCopyRemoveCommand;
import org.shoal.adapter.store.commands.StoreableFullSaveCommand;
import org.shoal.adapter.store.commands.StoreableLoadRequestCommand;
import org.shoal.adapter.store.commands.StoreableLoadResponseCommand;
import org.shoal.adapter.store.commands.StoreableRemoveCommand;
import org.shoal.adapter.store.commands.StoreableSaveCommand;
import org.shoal.adapter.store.commands.StoreableTouchCommand;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.DefaultObjectInputOutputStreamFactory;
import org.shoal.ha.cache.api.IdleEntryDetector;
import org.shoal.ha.cache.api.ReplicationFramework;
import org.shoal.ha.cache.impl.store.ReplicaStore;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ResponseMediator;
import org.shoal.ha.mapper.KeyMapper;

public class StoreableReplicatedBackingStore<K extends Serializable, V extends Storeable>
extends BackingStore<K, V> {
    private static final int MAX_REPLICA_TRIES = 1;
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.store");
    private static final Logger _loadLogger = Logger.getLogger("org.shoal.ha.cache.command.load_request");
    private ReplicationFramework<K, V> framework;
    private ReplicaStore<K, V> replicaStore;
    boolean localCachingEnabled;
    private ReplicatedBackingStoreFactory factory;
    private AtomicInteger broadcastLoadRequestCount = new AtomicInteger(0);
    private AtomicInteger simpleBroadcastCount = new AtomicInteger(0);
    private AtomicInteger foundLocallyCount = new AtomicInteger(0);
    private String debugName = "StoreableReplicatedBackingStore";

    void setBackingStoreFactory(ReplicatedBackingStoreFactory factory) {
        this.factory = factory;
    }

    public BackingStoreFactory getBackingStoreFactory() {
        return this.factory;
    }

    public void initialize(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        ClassLoader cl;
        super.initialize(conf);
        DataStoreConfigurator dsConf = new DataStoreConfigurator();
        dsConf.setInstanceName(conf.getInstanceName()).setGroupName(conf.getClusterName()).setStoreName(conf.getStoreName()).setKeyClazz(conf.getKeyClazz()).setValueClazz(conf.getValueClazz());
        Map vendorSpecificMap = conf.getVendorSpecificSettings();
        Object stGMS = vendorSpecificMap.get("start.gms");
        boolean startGMS = false;
        if (stGMS != null) {
            if (stGMS instanceof String) {
                try {
                    startGMS = Boolean.valueOf((String)stGMS);
                }
                catch (Throwable th) {}
            } else if (stGMS instanceof Boolean) {
                startGMS = (Boolean)stGMS;
            }
        }
        Object cacheLocally = vendorSpecificMap.get("local.caching");
        boolean enableLocalCaching = false;
        if (cacheLocally != null) {
            if (cacheLocally instanceof String) {
                try {
                    enableLocalCaching = Boolean.valueOf((String)cacheLocally);
                }
                catch (Throwable th) {}
            } else if (cacheLocally instanceof Boolean) {
                enableLocalCaching = (Boolean)stGMS;
            }
        }
        if ((cl = (ClassLoader)vendorSpecificMap.get("class.loader")) == null) {
            cl = conf.getValueClazz().getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        dsConf.setClassLoader(cl).setStartGMS(startGMS).setCacheLocally(enableLocalCaching);
        boolean asyncReplication = vendorSpecificMap.get("async.replication") == null ? true : (Boolean)vendorSpecificMap.get("async.replication");
        dsConf.setDoSynchronousReplication(!asyncReplication);
        dsConf.setObjectInputOutputStreamFactory(new DefaultObjectInputOutputStreamFactory());
        dsConf.addCommand(new StoreableSaveCommand());
        dsConf.addCommand(new StoreableFullSaveCommand());
        dsConf.addCommand(new SimpleAckCommand());
        dsConf.addCommand(new StoreableRemoveCommand());
        dsConf.addCommand(new StoreableTouchCommand());
        dsConf.addCommand(new StoreableLoadRequestCommand());
        dsConf.addCommand(new StoreableLoadResponseCommand());
        dsConf.addCommand(new StoreableRemoveCommand());
        dsConf.addCommand(new StaleCopyRemoveCommand());
        dsConf.addCommand(new SizeRequestCommand());
        dsConf.addCommand(new SizeResponseCommand());
        dsConf.addCommand(new NoOpCommand());
        KeyMapper keyMapper = (KeyMapper)vendorSpecificMap.get("key.mapper");
        if (keyMapper != null) {
            dsConf.setKeyMapper(keyMapper);
        }
        dsConf.setIdleEntryDetector(new IdleEntryDetector<K, V>(){

            @Override
            public boolean isIdle(DataStoreEntry<K, V> kvDataStoreEntry, long nowInMillis) {
                boolean result;
                Storeable v = (Storeable)kvDataStoreEntry.getV();
                boolean bl = result = v != null && v._storeable_getMaxIdleTime() > 0L && v._storeable_getLastAccessTime() + v._storeable_getMaxIdleTime() < nowInMillis;
                if (result) {
                    _logger.log(Level.WARNING, "**Removing expired entry: " + v);
                }
                return result;
            }
        });
        this.framework = new ReplicationFramework(dsConf);
        this.replicaStore = this.framework.getReplicaStore();
        this.localCachingEnabled = this.framework.getDataStoreConfigurator().isCacheLocally();
        this.debugName = dsConf.getStoreName();
    }

    public V load(K key, String versionInfo) throws BackingStoreException {
        long version = Long.MIN_VALUE;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "StoreableReplicatedBackingStore.load(" + key + ", " + versionInfo + ")");
            }
            version = Long.valueOf(versionInfo);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this.doLoad(key, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V doLoad(K key, long version) throws BackingStoreException {
        Object v;
        block27: {
            v = null;
            DataStoreEntry<K, Storeable> entry = this.replicaStore.getEntry(key);
            if (entry != null) {
                if (!entry.isRemoved()) {
                    v = (Storeable)entry.getV();
                    if (v != null) {
                        if (v._storeable_getVersion() < version) {
                            entry.setV(null);
                            v = null;
                        } else {
                            this.foundLocallyCount.incrementAndGet();
                            if (_loadLogger.isLoggable(Level.FINE)) {
                                _loadLogger.log(Level.FINE, "StoreableReplicatedBackingStore.doLoad(" + key + "). LOCAL REPLICA CACHE HIT: " + v + "; hitCount: " + this.foundLocallyCount.get());
                            }
                        }
                    }
                } else {
                    return null;
                }
            }
            if (v == null) {
                String replicachoices = this.framework.getKeyMapper().getReplicaChoices(this.framework.getGroupName(), key);
                String[] replicaHint = replicachoices.split(":");
                if (_loadLogger.isLoggable(Level.FINE)) {
                    _loadLogger.log(Level.FINE, "StoreableReplicatedBackingStore.doLoad(" + key + ", " + version + "); ReplicaChoices: " + replicachoices);
                }
                try {
                    String respondingInstance = null;
                    for (int replicaIndex = 0; replicaIndex < replicaHint.length && replicaIndex < 1; ++replicaIndex) {
                        String target = replicaHint[replicaIndex];
                        if (target == null || target.trim().length() == 0 || target.equals(this.framework.getInstanceName())) continue;
                        this.simpleBroadcastCount.incrementAndGet();
                        StoreableLoadRequestCommand command = new StoreableLoadRequestCommand(key, version, target);
                        if (_loadLogger.isLoggable(Level.FINE)) {
                            _loadLogger.log(Level.FINE, "StoreableReplicatedBackingStore: For Key=" + key + "; Trying to load from Replica[" + replicaIndex + "]: " + replicaHint[replicaIndex]);
                        }
                        this.framework.execute(command);
                        v = command.getResult(3L, TimeUnit.SECONDS);
                        if (v == null) continue;
                        if (_loadLogger.isLoggable(Level.FINE)) {
                            _loadLogger.log(Level.FINE, "StoreableReplicatedBackingStore.doLoad(" + key + ") ==> GOT:  " + v);
                        }
                        respondingInstance = command.getRespondingInstanceName();
                        break;
                    }
                    if (v == null) {
                        String[] targetInstances;
                        if (_loadLogger.isLoggable(Level.FINE)) {
                            _loadLogger.log(Level.FINE, "StoreableReplicatedBackingStore.doLoad(" + key + ") Performing broadcast load");
                        }
                        this.broadcastLoadRequestCount.incrementAndGet();
                        for (String targetInstance : targetInstances = this.framework.getKeyMapper().getCurrentMembers()) {
                            if (targetInstance.equals(this.framework.getInstanceName())) continue;
                            StoreableLoadRequestCommand command = new StoreableLoadRequestCommand(key, version, targetInstance);
                            if (_loadLogger.isLoggable(Level.FINE)) {
                                _loadLogger.log(Level.FINE, "*StoreableReplicatedBackingStore: For Key=" + key + "; Trying to load from " + targetInstance);
                            }
                            this.framework.execute(command);
                            v = command.getResult(3L, TimeUnit.SECONDS);
                            if (v == null) continue;
                            if (_loadLogger.isLoggable(Level.FINE)) {
                                _loadLogger.log(Level.FINE, "2.StoreableReplicatedBackingStore.doLoad(" + key + ") ==> GOT:  " + v);
                            }
                            respondingInstance = targetInstance;
                            break;
                        }
                    }
                    if (v == null || (entry = this.replicaStore.getEntry(key)) == null) break block27;
                    DataStoreEntry<K, Storeable> dataStoreEntry = entry;
                    synchronized (dataStoreEntry) {
                        if (!entry.isRemoved()) {
                            if (this.localCachingEnabled) {
                                entry.setV((Storeable)v);
                            }
                            if (_loadLogger.isLoggable(Level.FINE)) {
                                _loadLogger.log(Level.FINE, "StoreableReplicatedBackingStore: For Key=" + key + "; Successfully loaded data from " + respondingInstance);
                            }
                            entry.setReplicaInstanceName(respondingInstance);
                        } else {
                            _loadLogger.log(Level.WARNING, "StoreableReplicatedBackingStore: For Key=" + key + "; Got data from " + respondingInstance + ", but another concurrent thread removed the entry");
                        }
                    }
                }
                catch (DataStoreException dseEx) {
                    throw new BackingStoreException("Error during load", (Throwable)dseEx);
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "StoreableReplicatedBackingStore.load(" + key + ") Final result: " + v);
        }
        return (V)v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(K key, V value, boolean isNew) throws BackingStoreException {
        String result = null;
        try {
            DataStoreEntry<K, V> entry;
            DataStoreEntry<K, V> dataStoreEntry = entry = this.replicaStore.getOrCreateEntry(key);
            synchronized (dataStoreEntry) {
                StoreableSaveCommand<K, V> cmd = new StoreableSaveCommand<K, V>(key, value);
                cmd.setEntry(entry);
                this.framework.execute(cmd);
                if (this.localCachingEnabled) {
                    entry.setV(value);
                }
                String oldLocation = entry.setReplicaInstanceName(cmd.getTargetName());
                result = cmd.getTargetName();
                if (oldLocation != null) {
                    StaleCopyRemoveCommand staleCmd = new StaleCopyRemoveCommand();
                    staleCmd.setKey(key);
                    staleCmd.setStaleTargetName(oldLocation);
                    this.framework.execute(staleCmd);
                    _logger.log(Level.WARNING, "StoreableReplicatedBackingStore.save(" + key + "). " + "Just Saved data to: " + result + "& removed stale copy from " + oldLocation);
                }
                result = cmd.getKeyMappingInfo();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.debugName + "save(" + key + "). Saved to " + result);
                }
            }
            return result;
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during save: " + key, (Throwable)dsEx);
        }
    }

    public void remove(K key) throws BackingStoreException {
        try {
            this.replicaStore.remove(key);
            String[] targets = this.framework.getDataStoreContext().getKeyMapper().getCurrentMembers();
            if (targets != null) {
                for (String target : targets) {
                    StoreableRemoveCommand cmd = new StoreableRemoveCommand(key);
                    cmd.setTarget(target);
                    this.framework.execute(cmd);
                }
            }
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during remove: " + key, (Throwable)dsEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeExpired(long idleTime) throws BackingStoreException {
        String[] targets = this.framework.getKeyMapper().getCurrentMembers();
        ResponseMediator respMed = this.framework.getResponseMediator();
        CommandResponse resp = respMed.createCommandResponse();
        long tokenId = resp.getTokenId();
        resp.setTransientResult(new Integer(0));
        FutureTask future = resp.getFuture();
        int finalResult = 0;
        try {
            if (targets != null) {
                resp.setExpectedUpdateCount(targets.length);
                for (String target : targets) {
                    RemoveExpiredCommand cmd = new RemoveExpiredCommand(idleTime, tokenId);
                    cmd.setTarget(target);
                    try {
                        this.framework.execute(cmd);
                    }
                    catch (DataStoreException dse) {
                        _logger.log(Level.FINE, "Exception during removeIdleEntries...", dse);
                    }
                }
            }
            int localResult = this.replicaStore.removeExpired();
            CommandResponse commandResponse = resp;
            synchronized (commandResponse) {
                Integer existingValue = (Integer)resp.getTransientResult();
                Integer newResult = new Integer(existingValue + localResult);
                resp.setTransientResult(newResult);
            }
            finalResult = (Integer)resp.getTransientResult();
            int n = (Integer)future.get(2L, TimeUnit.SECONDS);
            return n;
        }
        catch (Exception ex) {
        }
        finally {
            respMed.removeCommandResponse(tokenId);
        }
        return finalResult;
    }

    public int size() throws BackingStoreException {
        int i;
        int result = 0;
        KeyMapper km = this.framework.getKeyMapper();
        String[] targets = km.getCurrentMembers();
        int targetCount = targets.length;
        SizeRequestCommand[] commands = new SizeRequestCommand[targetCount];
        for (i = 0; i < targetCount; ++i) {
            commands[i] = new SizeRequestCommand(targets[i]);
            try {
                this.framework.execute(commands[i]);
                continue;
            }
            catch (DataStoreException dse) {
                // empty catch block
            }
        }
        for (i = 0; i < targetCount; ++i) {
            result += commands[i].getResult();
        }
        return result;
    }

    public void destroy() throws BackingStoreException {
        this.framework = null;
    }

    public void updateTimestamp(K key, long t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateTimestamp(K key, Long version, Long accessTime, Long maxIdleTime) throws BackingStoreException {
        String result;
        block8: {
            result = "";
            try {
                DataStoreEntry<K, V> entry = this.replicaStore.getEntry(key);
                if (entry == null) break block8;
                DataStoreEntry<K, V> dataStoreEntry = entry;
                synchronized (dataStoreEntry) {
                    if (!entry.isRemoved()) {
                        if (entry.getReplicaInstanceName() != null) {
                            StoreableTouchCommand cmd = new StoreableTouchCommand(key, version, accessTime, maxIdleTime);
                            this.framework.execute(cmd);
                            result = entry.getReplicaInstanceName().equals(cmd.getTargetName()) ? cmd.getTargetName() : "";
                        }
                    } else {
                        _logger.log(Level.WARNING, "Ignored updateTimeStamp as the entry is already removed. Key = " + key);
                    }
                }
            }
            catch (DataStoreException dsEx) {
                throw new BackingStoreException("Error during load: " + key, (Throwable)dsEx);
            }
        }
        return result;
    }

    public ReplicationFramework<K, V> getFramework() {
        return this.framework;
    }

    public DataStoreContext<K, V> getDataStoreContext() {
        return this.framework.getDataStoreContext();
    }
}

