/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.AcknowledgedCommand;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;

public class SaveCommand<K, V>
extends AcknowledgedCommand<K, V> {
    private static final transient Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.save");
    private K k;
    private V v;
    private long version;
    private long lastAccessedAt;
    private String targetInstanceName;

    public SaveCommand() {
        super((byte)33);
    }

    public SaveCommand(K k, V v, long version, long lastAccessedAt) {
        this();
        this.setKey(k);
        this.setValue(v);
        this.version = version;
        this.lastAccessedAt = lastAccessedAt;
    }

    @Override
    public void setKey(K k) {
        this.k = k;
    }

    public void setValue(V v) {
        this.v = v;
    }

    @Override
    public boolean beforeTransmit() {
        this.targetInstanceName = this.dsc.getKeyMapper().getMappedInstance(this.dsc.getGroupName(), this.k);
        super.setTargetName(this.targetInstanceName);
        super.beforeTransmit();
        return this.getTargetName() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreEntry entry;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getServiceName() + this.getName() + " received save_command for " + this.k + " from " + initiator);
        }
        DataStoreEntry dataStoreEntry = entry = this.dsc.getReplicaStore().getOrCreateEntry(this.k);
        synchronized (dataStoreEntry) {
            entry.setV(this.v);
            entry.setLastAccessedAt(this.lastAccessedAt);
        }
        if (this.dsc.isDoSynchronousReplication()) {
            _logger.log(Level.WARNING, "SaveCommand Sending SIMPLE_ACK");
            super.sendAcknowledgement();
        }
    }

    public String toString() {
        return this.getName() + "(" + this.k + ")";
    }

    @Override
    public String getKeyMappingInfo() {
        return this.targetInstanceName;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.k);
        out.writeObject(this.v);
        out.writeLong(this.version);
        out.writeLong(this.lastAccessedAt);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getServiceName() + " sending save_command for " + this.k + "; v = " + this.v + "; to " + this.getTargetName());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.k = in.readObject();
        this.v = in.readObject();
        this.version = in.readLong();
        this.lastAccessedAt = in.readLong();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "==> read data for key " + this.k + " => " + this.v + " using " + in.getClass().getCanonicalName());
        }
    }
}

