/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class StoreableLoadResponseCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.load_response");
    private K key;
    private V v;
    private long tokenId;
    private String originatingInstance;
    private String respondingInstanceName;

    public StoreableLoadResponseCommand() {
        super((byte)72);
    }

    public StoreableLoadResponseCommand(K key, V v, long tokenId) {
        this();
        this.key = key;
        this.v = v;
        this.tokenId = tokenId;
    }

    public void setOriginatingInstance(String originatingInstance) {
        this.originatingInstance = originatingInstance;
    }

    @Override
    protected boolean beforeTransmit() {
        this.setTargetName(this.originatingInstance);
        return this.originatingInstance != null;
    }

    private void writeObject(ObjectOutputStream ros) throws IOException {
        ros.writeLong(this.tokenId);
        ros.writeUTF(this.originatingInstance);
        ros.writeUTF(this.dsc.getInstanceName());
        ros.writeObject(this.key);
        ros.writeBoolean(this.v != null);
        if (this.v != null) {
            ros.writeObject(this.v);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getInstanceName() + this.getName() + " sending load_response command for " + this.key + " to " + this.originatingInstance + "; " + this.v);
        }
    }

    private void readObject(ObjectInputStream ris) throws IOException, ClassNotFoundException {
        this.tokenId = ris.readLong();
        this.originatingInstance = ris.readUTF();
        this.respondingInstanceName = ris.readUTF();
        this.key = ris.readObject();
        boolean notNull = ris.readBoolean();
        if (notNull) {
            this.v = ris.readObject();
        }
    }

    @Override
    public void execute(String initaitor) {
        ResponseMediator respMed = this.getDataStoreContext().getResponseMediator();
        CommandResponse resp = respMed.getCommandResponse(this.tokenId);
        if (resp != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.dsc.getInstanceName() + " received load_response key=" + this.key + "; value=" + this.v + "; from " + this.respondingInstanceName);
            }
            resp.setRespondingInstanceName(this.respondingInstanceName);
            resp.setResult(this.v);
        }
    }

    public String toString() {
        return this.getName() + "(" + this.key + ")";
    }
}

