/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.Storeable;
import org.shoal.adapter.store.commands.AcknowledgedCommand;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;

public class StoreableSaveCommand<K, V extends Storeable>
extends AcknowledgedCommand<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.save");
    private K k;
    private Storeable v;
    private long version;
    private transient byte[] rawReadState;
    private boolean wasFullWrite;
    private DataStoreEntry<K, V> entry;
    private String replicaChoices;

    public StoreableSaveCommand() {
        super((byte)68);
    }

    public StoreableSaveCommand(K k, V v) {
        this();
        this.setKey(k);
        this.setValue(v);
        this.version = v._storeable_getVersion();
    }

    @Override
    public void setKey(K k) {
        this.k = k;
    }

    public void setValue(V v) {
        this.v = v;
        this.version = v._storeable_getVersion();
    }

    public void setEntry(DataStoreEntry<K, V> entry) {
        this.entry = entry;
    }

    @Override
    protected boolean beforeTransmit() {
        this.replicaChoices = this.dsc.getKeyMapper().getMappedInstance(this.dsc.getGroupName(), this.k);
        super.setTargetName(this.replicaChoices);
        super.beforeTransmit();
        return this.getTargetName() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream ros) throws IOException {
        this.version = this.v._storeable_getVersion();
        boolean requiresFullSave = true;
        if (this.entry.getReplicaInstanceName() != null) {
            requiresFullSave = !this.entry.getReplicaInstanceName().equals(this.getTargetName());
        }
        ros.writeObject(this.k);
        ros.writeLong(this.v._storeable_getVersion());
        ros.writeBoolean(requiresFullSave);
        if (requiresFullSave) {
            ros.writeObject(this.v);
        } else {
            byte[] data = new byte[]{};
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                this.v._storeable_writeState((OutputStream)bos);
                data = bos.toByteArray();
            }
            finally {
                try {
                    bos.close();
                }
                catch (Exception ex) {}
            }
            ros.writeInt(data.length);
            ros.write(data);
        }
    }

    private void readObject(ObjectInputStream ris) throws IOException, ClassNotFoundException {
        this.k = ris.readObject();
        this.version = ris.readLong();
        this.wasFullWrite = ris.readBoolean();
        if (this.wasFullWrite) {
            this.v = (Storeable)ris.readObject();
        } else {
            int sz = ris.readInt();
            this.rawReadState = new byte[sz];
            ris.readFully(this.rawReadState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreEntry entry;
        DataStoreEntry dataStoreEntry = entry = this.dsc.getReplicaStore().getOrCreateEntry(this.k);
        synchronized (dataStoreEntry) {
            if (this.wasFullWrite) {
                entry.setV(this.v);
                entry.clearPendingUpdates();
            } else {
                Storeable entryV = (Storeable)entry.getV();
                if (entryV != null) {
                    if (entryV._storeable_getVersion() <= this.version) {
                        ByteArrayInputStream bis = new ByteArrayInputStream(this.rawReadState);
                        try {
                            entryV._storeable_readState((InputStream)bis);
                        }
                        catch (IOException ex) {
                            throw new DataStoreException(ex);
                        }
                        finally {
                            try {
                                bis.close();
                            }
                            catch (Exception ex2) {}
                        }
                    }
                    if (entryV._storeable_getVersion() > this.version) {
                        _logger.log(Level.FINE, "Ignoring stale data " + entryV._storeable_getVersion() + " > " + this.version + "; for key: " + this.k);
                    }
                } else {
                    List commands = entry.getPendingUpdates();
                    _logger.log(Level.FINE, "Added to pending updates[2].... for key: " + this.k);
                }
            }
        }
        if (this.dsc.isDoSynchronousReplication()) {
            _logger.log(Level.WARNING, "StoreableSaveCommand Sending SIMPLE_ACK");
            super.sendAcknowledgement();
        }
    }

    public String toString() {
        return this.getName() + "(" + this.k + ")";
    }

    @Override
    public String getKeyMappingInfo() {
        return this.replicaChoices;
    }
}

