/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.Storeable;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;

public class StoreableTouchCommand<K, V extends Storeable>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.touch");
    private K k;
    private long version = -1L;
    private long accessTime;
    private long maxIdleTime;
    private String replicaChoices;

    public StoreableTouchCommand() {
        super((byte)73);
    }

    public StoreableTouchCommand(K k, long version, long accessTime, long maxIdleTime) {
        this();
        this.k = k;
        this.version = version;
        this.accessTime = accessTime;
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    protected boolean beforeTransmit() {
        String replicaChoices = this.dsc.getKeyMapper().getReplicaChoices(this.dsc.getGroupName(), this.k);
        String[] choices = replicaChoices == null ? null : replicaChoices.split(":");
        super.setTargetName(replicaChoices == null ? null : choices[0]);
        return this.getTargetName() != null;
    }

    private void writeObject(ObjectOutputStream ros) throws IOException {
        ros.writeObject(this.k);
        ros.writeLong(this.version);
        ros.writeLong(this.accessTime);
        ros.writeLong(this.maxIdleTime);
    }

    private void readObject(ObjectInputStream ris) throws IOException, ClassNotFoundException {
        this.k = ris.readObject();
        this.version = ris.readLong();
        this.accessTime = ris.readLong();
        this.maxIdleTime = ris.readLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreEntry entry = this.dsc.getReplicaStore().getEntry(this.k);
        if (entry != null) {
            DataStoreEntry dataStoreEntry = entry;
            synchronized (dataStoreEntry) {
                if (!entry.isRemoved()) {
                    Storeable entryV = (Storeable)entry.getV();
                    if (entryV != null) {
                        if (entryV._storeable_getVersion() + 1L == this.version) {
                            entryV._storeable_setVersion(this.version);
                            entryV._storeable_setLastAccessTime(this.accessTime);
                            entryV._storeable_setMaxIdleTime(this.maxIdleTime);
                        } else if (entryV._storeable_getVersion() < this.version) {
                            List commands = entry.getPendingUpdates();
                            _logger.log(Level.INFO, "Added[1] to pending updates.... for key: " + this.k);
                        }
                    } else {
                        List commands = entry.getPendingUpdates();
                        _logger.log(Level.INFO, "Added to pending updates.... for key: " + this.k);
                    }
                }
            }
        }
    }

    @Override
    public String getKeyMappingInfo() {
        return this.replicaChoices;
    }
}

